/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="consumptionFacets", type="BFacets", defaultValue="BFacets.makeNumeric(UnitDatabase.getUnit(\"kilowatt hour\"), 1)"), @NiagaraProperty(name="demandFacets", type="BFacets", defaultValue="BFacets.makeNumeric(UnitDatabase.getUnit(\"kilowatt\"), 1)"), @NiagaraProperty(name="kwhPerPulseFacets", type="BFacets", defaultValue="BFacets.makeNumeric(UnitDatabase.getUnit(\"kilowatt hour\"), 3)"), @NiagaraProperty(name="currentPulseCount", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=2), @NiagaraProperty(name="timeOfReset", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="demand5", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="demand15", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="demand30", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="kwh", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="kwhHourly", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="kwhLastHour", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="kwhDaily", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="kwhLastDay", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="kwhPerPulse", type="double", defaultValue="1.0"), @NiagaraProperty(name="enableReset", type="boolean", defaultValue="true"), @NiagaraProperty(name="resetDayOfMonth", type="int", defaultValue="1", facets={@Facet(value="BFacets.makeInt(1, 31)")}), @NiagaraProperty(name="resetDayOfWeek", type="BWeekday", defaultValue="BWeekday.sunday"), @NiagaraProperty(name="resetTime", type="BTime", defaultValue="BTime.make(0,0,0)"), @NiagaraProperty(name="meterRollover", type="long", defaultValue="65535L")})
@NiagaraActions(value={@NiagaraAction(name="calculate", flags=4), @NiagaraAction(name="hourUpdate", flags=4), @NiagaraAction(name="dayUpdate", flags=4), @NiagaraAction(name="resetMonthly"), @NiagaraAction(name="resetData")})
public class BSlidingWindowDemandCalc
extends BComponent {
    @Generated
    public static final Property consumptionFacets = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt hour"), (int)1), null);
    @Generated
    public static final Property demandFacets = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt"), (int)1), null);
    @Generated
    public static final Property kwhPerPulseFacets = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt hour"), (int)3), null);
    @Generated
    public static final Property currentPulseCount = BSlidingWindowDemandCalc.newProperty((int)2, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property timeOfReset = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property demand5 = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property demand15 = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property demand30 = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property kwh = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property kwhHourly = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property kwhLastHour = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property kwhDaily = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property kwhLastDay = BSlidingWindowDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property kwhPerPulse = BSlidingWindowDemandCalc.newProperty((int)0, (double)1.0, null);
    @Generated
    public static final Property enableReset = BSlidingWindowDemandCalc.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property resetDayOfMonth = BSlidingWindowDemandCalc.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)31));
    @Generated
    public static final Property resetDayOfWeek = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BWeekday.sunday, null);
    @Generated
    public static final Property resetTime = BSlidingWindowDemandCalc.newProperty((int)0, (BValue)BTime.make((int)0, (int)0, (int)0), null);
    @Generated
    public static final Property meterRollover = BSlidingWindowDemandCalc.newProperty((int)0, (long)65535L, null);
    @Generated
    public static final Action calculate = BSlidingWindowDemandCalc.newAction((int)4, null);
    @Generated
    public static final Action hourUpdate = BSlidingWindowDemandCalc.newAction((int)4, null);
    @Generated
    public static final Action dayUpdate = BSlidingWindowDemandCalc.newAction((int)4, null);
    @Generated
    public static final Action resetMonthly = BSlidingWindowDemandCalc.newAction((int)0, null);
    @Generated
    public static final Action resetData = BSlidingWindowDemandCalc.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSlidingWindowDemandCalc.class);
    Clock.Ticket ticket = null;
    private static int FIFTY_SECONDS = 50000;
    BAbsTime now;
    BAbsTime previousTime;
    boolean reset = false;
    boolean resetFlag = false;
    double diffSec;
    double kwhNew;
    int lastHour;
    int lastDay;
    boolean firstTime = true;
    int maxPulseDiff;
    double lastPulseCount;
    double pulseCountDiff;
    long lastCountChangeTicks = 0L;
    long countChangePeriod = 0L;
    boolean isSlowRate = false;

    @Generated
    public BFacets getConsumptionFacets() {
        return (BFacets)this.get(consumptionFacets);
    }

    @Generated
    public void setConsumptionFacets(BFacets v) {
        this.set(consumptionFacets, (BValue)v, null);
    }

    @Generated
    public BFacets getDemandFacets() {
        return (BFacets)this.get(demandFacets);
    }

    @Generated
    public void setDemandFacets(BFacets v) {
        this.set(demandFacets, (BValue)v, null);
    }

    @Generated
    public BFacets getKwhPerPulseFacets() {
        return (BFacets)this.get(kwhPerPulseFacets);
    }

    @Generated
    public void setKwhPerPulseFacets(BFacets v) {
        this.set(kwhPerPulseFacets, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getCurrentPulseCount() {
        return (BStatusNumeric)this.get(currentPulseCount);
    }

    @Generated
    public void setCurrentPulseCount(BStatusNumeric v) {
        this.set(currentPulseCount, (BValue)v, null);
    }

    @Generated
    public BAbsTime getTimeOfReset() {
        return (BAbsTime)this.get(timeOfReset);
    }

    @Generated
    public void setTimeOfReset(BAbsTime v) {
        this.set(timeOfReset, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getDemand5() {
        return (BStatusNumeric)this.get(demand5);
    }

    @Generated
    public void setDemand5(BStatusNumeric v) {
        this.set(demand5, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getDemand15() {
        return (BStatusNumeric)this.get(demand15);
    }

    @Generated
    public void setDemand15(BStatusNumeric v) {
        this.set(demand15, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getDemand30() {
        return (BStatusNumeric)this.get(demand30);
    }

    @Generated
    public void setDemand30(BStatusNumeric v) {
        this.set(demand30, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getKwh() {
        return (BStatusNumeric)this.get(kwh);
    }

    @Generated
    public void setKwh(BStatusNumeric v) {
        this.set(kwh, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getKwhHourly() {
        return (BStatusNumeric)this.get(kwhHourly);
    }

    @Generated
    public void setKwhHourly(BStatusNumeric v) {
        this.set(kwhHourly, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getKwhLastHour() {
        return (BStatusNumeric)this.get(kwhLastHour);
    }

    @Generated
    public void setKwhLastHour(BStatusNumeric v) {
        this.set(kwhLastHour, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getKwhDaily() {
        return (BStatusNumeric)this.get(kwhDaily);
    }

    @Generated
    public void setKwhDaily(BStatusNumeric v) {
        this.set(kwhDaily, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getKwhLastDay() {
        return (BStatusNumeric)this.get(kwhLastDay);
    }

    @Generated
    public void setKwhLastDay(BStatusNumeric v) {
        this.set(kwhLastDay, (BValue)v, null);
    }

    @Generated
    public double getKwhPerPulse() {
        return this.getDouble(kwhPerPulse);
    }

    @Generated
    public void setKwhPerPulse(double v) {
        this.setDouble(kwhPerPulse, v, null);
    }

    @Generated
    public boolean getEnableReset() {
        return this.getBoolean(enableReset);
    }

    @Generated
    public void setEnableReset(boolean v) {
        this.setBoolean(enableReset, v, null);
    }

    @Generated
    public int getResetDayOfMonth() {
        return this.getInt(resetDayOfMonth);
    }

    @Generated
    public void setResetDayOfMonth(int v) {
        this.setInt(resetDayOfMonth, v, null);
    }

    @Generated
    public BWeekday getResetDayOfWeek() {
        return (BWeekday)this.get(resetDayOfWeek);
    }

    @Generated
    public void setResetDayOfWeek(BWeekday v) {
        this.set(resetDayOfWeek, (BValue)v, null);
    }

    @Generated
    public BTime getResetTime() {
        return (BTime)this.get(resetTime);
    }

    @Generated
    public void setResetTime(BTime v) {
        this.set(resetTime, (BValue)v, null);
    }

    @Generated
    public long getMeterRollover() {
        return this.getLong(meterRollover);
    }

    @Generated
    public void setMeterRollover(long v) {
        this.setLong(meterRollover, v, null);
    }

    @Generated
    public void calculate() {
        this.invoke(calculate, null, null);
    }

    @Generated
    public void hourUpdate() {
        this.invoke(hourUpdate, null, null);
    }

    @Generated
    public void dayUpdate() {
        this.invoke(dayUpdate, null, null);
    }

    @Generated
    public void resetMonthly() {
        this.invoke(resetMonthly, null, null);
    }

    @Generated
    public void resetData() {
        this.invoke(resetData, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
        super.started();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)kwh) || slot.equals((Object)kwhDaily) || slot.equals((Object)kwhHourly) || slot.equals((Object)kwhLastDay) || slot.equals((Object)kwhLastHour)) {
            return this.getConsumptionFacets();
        }
        if (slot.equals((Object)demand5) || slot.equals((Object)demand15) || slot.equals((Object)demand30)) {
            return this.getDemandFacets();
        }
        if (slot.equals((Object)kwhPerPulse)) {
            return this.getKwhPerPulseFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doHourUpdate() {
    }

    public void doDayUpdate() {
    }

    public void doResetData() {
        if (this.now == null) {
            return;
        }
        this.getKwh().setValue(0.0);
        this.getKwhHourly().setValue(0.0);
        this.getKwhLastHour().setValue(0.0);
        this.getKwhDaily().setValue(0.0);
        this.getKwhLastDay().setValue(0.0);
        this.getDemand5().setValue(0.0);
        this.getDemand15().setValue(0.0);
        this.getDemand30().setValue(0.0);
        this.previousTime = this.now;
        this.lastHour = this.now.getHour();
        this.lastDay = this.now.getDay();
        this.resetFlag = true;
        this.setTimeOfReset(Clock.time());
    }

    public void setDataFaultStatus(boolean fault) {
        this.getKwh().setStatusFault(fault);
        this.getKwhHourly().setStatusFault(fault);
        this.getKwhLastHour().setStatusFault(fault);
        this.getKwhDaily().setStatusFault(fault);
        this.getKwhLastDay().setStatusFault(fault);
        this.getDemand5().setStatusFault(fault);
        this.getDemand15().setStatusFault(fault);
        this.getDemand30().setStatusFault(fault);
    }

    public void doResetMonthly() {
        if (this.now == null) {
            return;
        }
        this.getKwh().setValue(0.0);
        this.getKwhHourly().setValue(0.0);
        this.getKwhLastHour().setValue(0.0);
        this.getKwhDaily().setValue(0.0);
        this.getKwhLastDay().setValue(0.0);
        this.previousTime = this.now;
        this.lastHour = this.now.getHour();
        this.lastDay = this.now.getDay();
        this.resetFlag = true;
        this.setTimeOfReset(Clock.time());
    }

    public void doPulseCalculate() {
        if (this.getCurrentPulseCount().getValue() == this.lastPulseCount) {
            return;
        }
        if (!this.getCurrentPulseCount().getStatus().isValid() || Double.isNaN(this.getCurrentPulseCount().getValue())) {
            return;
        }
        long thisCountChangeTicks = Clock.millis();
        this.countChangePeriod = thisCountChangeTicks - this.lastCountChangeTicks;
        if (this.countChangePeriod < (long)FIFTY_SECONDS) {
            this.isSlowRate = false;
            this.lastCountChangeTicks = thisCountChangeTicks;
            this.doCalculate();
        } else {
            this.isSlowRate = true;
            this.lastCountChangeTicks = thisCountChangeTicks;
        }
    }

    public void doCalculate() {
        int resetDayOfMonth;
        int today;
        this.now = Clock.time();
        if (this.firstTime) {
            this.lastPulseCount = this.getCurrentPulseCount().getValue();
            if (!this.getCurrentPulseCount().getStatus().isValid() || Double.isNaN(this.getCurrentPulseCount().getValue())) {
                this.setDataFaultStatus(true);
                return;
            }
            this.setDataFaultStatus(false);
            this.lastCountChangeTicks = this.now.getMillis();
            this.previousTime = this.now;
            this.setTimeOfReset(this.now);
            this.lastHour = this.now.getHour();
            this.lastDay = this.now.getDay();
            this.firstTime = false;
            return;
        }
        if (!this.reset && (today = this.now.getDay()) >= (resetDayOfMonth = this.getResetDayOfMonth()) && resetDayOfMonth < resetDayOfMonth + 7 && this.now.getWeekday().equals((Object)this.getResetDayOfWeek()) && this.now.getTimeOfDayMillis() >= this.getResetTime().getTimeOfDayMillis()) {
            this.reset = true;
            this.setTimeOfReset(Clock.time());
        }
        if (this.reset && !this.now.getWeekday().equals((Object)this.getResetDayOfWeek())) {
            this.reset = false;
        }
        if (this.getEnableReset() && this.reset && !this.resetFlag) {
            this.getKwh().setValue(0.0);
            this.getKwhHourly().setValue(0.0);
            this.getKwhLastHour().setValue(0.0);
            this.getKwhDaily().setValue(0.0);
            this.getKwhLastDay().setValue(0.0);
            this.previousTime = this.now;
            this.lastHour = this.now.getHour();
            this.lastDay = this.now.getDay();
            this.resetFlag = true;
        }
        if (!this.reset) {
            this.resetFlag = false;
        }
        this.diffSec = (double)this.previousTime.delta(this.now).getMillis() / 1000.0;
        this.previousTime = this.now;
        this.maxPulseDiff = (int)(this.diffSec * 10.0);
        double currentCount = this.getCurrentPulseCount().getValue();
        if (!this.getCurrentPulseCount().getStatus().isValid() || Double.isNaN(this.getCurrentPulseCount().getValue())) {
            this.setDataFaultStatus(true);
            return;
        }
        this.setDataFaultStatus(false);
        this.pulseCountDiff = currentCount >= this.lastPulseCount ? currentCount - this.lastPulseCount : (double)this.getMeterRollover() + 1.0 + currentCount - this.lastPulseCount;
        if (this.pulseCountDiff > (double)this.maxPulseDiff || this.pulseCountDiff < 0.0) {
            this.lastPulseCount = currentCount;
            return;
        }
        if (this.pulseCountDiff > 0.0 && this.isSlowRate) {
            this.diffSec = (double)this.countChangePeriod / 1000.0;
        }
        this.kwhNew = this.pulseCountDiff * this.getKwhPerPulse();
        this.getKwh().setValue(this.getKwh().getValue() + this.kwhNew);
        this.lastPulseCount = currentCount;
        if (this.lastHour != this.now.getHour()) {
            this.lastHour = this.now.getHour();
            this.getKwhLastHour().setValue(this.getKwhHourly().getValue());
            this.hourUpdate();
            this.getKwhHourly().setValue(this.kwhNew);
        } else {
            this.getKwhHourly().setValue(this.getKwhHourly().getValue() + this.kwhNew);
        }
        if (this.lastDay != this.now.getDay()) {
            this.lastDay = this.now.getDay();
            this.getKwhLastDay().setValue(this.getKwhDaily().getValue());
            this.dayUpdate();
            this.getKwhDaily().setValue(this.kwhNew);
        } else {
            this.getKwhDaily().setValue(this.getKwhDaily().getValue() + this.kwhNew);
        }
        double x = (1.0 - this.diffSec * 0.00751) * this.getDemand5().getValue();
        this.getDemand5().setValue(this.pulseCountDiff * this.getKwhPerPulse() * 0.00751 * 3600.0 + x);
        x = (1.0 - this.diffSec * 0.002535) * this.getDemand15().getValue();
        this.getDemand15().setValue(this.pulseCountDiff * this.getKwhPerPulse() * 0.002535 * 3600.0 + x);
        x = (1.0 - this.diffSec * 0.001278) * this.getDemand30().getValue();
        this.getDemand30().setValue(this.pulseCountDiff * this.getKwhPerPulse() * 0.001278 * 3600.0 + x);
    }
}

