/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.makeBoolean()"), @NiagaraProperty(name="in", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=8), @NiagaraProperty(name="numberOutputs", type="int", defaultValue="2", facets={@Facet(value="BFacets.makeInt(null, 2, 10)")}), @NiagaraProperty(name="maxRuntime", type="BRelTime", defaultValue="BRelTime.make(360000)"), @NiagaraProperty(name="feedback", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=10), @NiagaraProperty(name="feedbackDelay", type="BRelTime", defaultValue="BRelTime.make(5000)"), @NiagaraProperty(name="clearAlarmTime", type="BRelTime", defaultValue="BRelTime.makeHours(1)"), @NiagaraProperty(name="outA", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=10), @NiagaraProperty(name="outB", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=10), @NiagaraProperty(name="outC", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=2), @NiagaraProperty(name="outD", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=2), @NiagaraProperty(name="outE", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=2), @NiagaraProperty(name="outF", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=2), @NiagaraProperty(name="outG", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=2), @NiagaraProperty(name="outH", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=2), @NiagaraProperty(name="outI", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=2), @NiagaraProperty(name="outJ", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=2), @NiagaraProperty(name="cycleCountA", type="int", defaultValue="0", flags=10), @NiagaraProperty(name="cycleCountB", type="int", defaultValue="0", flags=10), @NiagaraProperty(name="cycleCountC", type="int", defaultValue="0", flags=2), @NiagaraProperty(name="cycleCountD", type="int", defaultValue="0", flags=2), @NiagaraProperty(name="cycleCountE", type="int", defaultValue="0", flags=2), @NiagaraProperty(name="cycleCountF", type="int", defaultValue="0", flags=2), @NiagaraProperty(name="cycleCountG", type="int", defaultValue="0", flags=2), @NiagaraProperty(name="cycleCountH", type="int", defaultValue="0", flags=2), @NiagaraProperty(name="cycleCountI", type="int", defaultValue="0", flags=2), @NiagaraProperty(name="cycleCountJ", type="int", defaultValue="0", flags=2)})
@NiagaraActions(value={@NiagaraAction(name="rotateTimerExpired", flags=4), @NiagaraAction(name="feedbackTimerExpired", flags=4), @NiagaraAction(name="clearAlarmState")})
public class BLeadLagCycles
extends BComponent {
    @Generated
    public static final Property facets = BLeadLagCycles.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    @Generated
    public static final Property in = BLeadLagCycles.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property numberOutputs = BLeadLagCycles.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    @Generated
    public static final Property maxRuntime = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.make((long)360000L), null);
    @Generated
    public static final Property feedback = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property feedbackDelay = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.make((long)5000L), null);
    @Generated
    public static final Property clearAlarmTime = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), null);
    @Generated
    public static final Property outA = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outB = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outC = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outD = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outE = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outF = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outG = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outH = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outI = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outJ = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property cycleCountA = BLeadLagCycles.newProperty((int)10, (int)0, null);
    @Generated
    public static final Property cycleCountB = BLeadLagCycles.newProperty((int)10, (int)0, null);
    @Generated
    public static final Property cycleCountC = BLeadLagCycles.newProperty((int)2, (int)0, null);
    @Generated
    public static final Property cycleCountD = BLeadLagCycles.newProperty((int)2, (int)0, null);
    @Generated
    public static final Property cycleCountE = BLeadLagCycles.newProperty((int)2, (int)0, null);
    @Generated
    public static final Property cycleCountF = BLeadLagCycles.newProperty((int)2, (int)0, null);
    @Generated
    public static final Property cycleCountG = BLeadLagCycles.newProperty((int)2, (int)0, null);
    @Generated
    public static final Property cycleCountH = BLeadLagCycles.newProperty((int)2, (int)0, null);
    @Generated
    public static final Property cycleCountI = BLeadLagCycles.newProperty((int)2, (int)0, null);
    @Generated
    public static final Property cycleCountJ = BLeadLagCycles.newProperty((int)2, (int)0, null);
    @Generated
    public static final Action rotateTimerExpired = BLeadLagCycles.newAction((int)4, null);
    @Generated
    public static final Action feedbackTimerExpired = BLeadLagCycles.newAction((int)4, null);
    @Generated
    public static final Action clearAlarmState = BLeadLagCycles.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLeadLagCycles.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    int numOutputs;
    int lastNumberOutputs;
    boolean feedbackTimerActive = false;
    boolean currentIn;
    boolean wasOn = false;
    int[] cycleCounts = new int[10];
    Clock.Ticket rotateTicket;
    Clock.Ticket feedbackTicket;
    Clock.Ticket alarmClearTicket;

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getIn() {
        return (BStatusBoolean)this.get(in);
    }

    @Generated
    public void setIn(BStatusBoolean v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    @Generated
    public void setNumberOutputs(int v) {
        this.setInt(numberOutputs, v, null);
    }

    @Generated
    public BRelTime getMaxRuntime() {
        return (BRelTime)this.get(maxRuntime);
    }

    @Generated
    public void setMaxRuntime(BRelTime v) {
        this.set(maxRuntime, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getFeedback() {
        return (BStatusBoolean)this.get(feedback);
    }

    @Generated
    public void setFeedback(BStatusBoolean v) {
        this.set(feedback, (BValue)v, null);
    }

    @Generated
    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    @Generated
    public void setFeedbackDelay(BRelTime v) {
        this.set(feedbackDelay, (BValue)v, null);
    }

    @Generated
    public BRelTime getClearAlarmTime() {
        return (BRelTime)this.get(clearAlarmTime);
    }

    @Generated
    public void setClearAlarmTime(BRelTime v) {
        this.set(clearAlarmTime, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    @Generated
    public void setOutA(BStatusBoolean v) {
        this.set(outA, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    @Generated
    public void setOutB(BStatusBoolean v) {
        this.set(outB, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    @Generated
    public void setOutC(BStatusBoolean v) {
        this.set(outC, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    @Generated
    public void setOutD(BStatusBoolean v) {
        this.set(outD, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    @Generated
    public void setOutE(BStatusBoolean v) {
        this.set(outE, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    @Generated
    public void setOutF(BStatusBoolean v) {
        this.set(outF, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    @Generated
    public void setOutG(BStatusBoolean v) {
        this.set(outG, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    @Generated
    public void setOutH(BStatusBoolean v) {
        this.set(outH, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    @Generated
    public void setOutI(BStatusBoolean v) {
        this.set(outI, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    @Generated
    public void setOutJ(BStatusBoolean v) {
        this.set(outJ, (BValue)v, null);
    }

    @Generated
    public int getCycleCountA() {
        return this.getInt(cycleCountA);
    }

    @Generated
    public void setCycleCountA(int v) {
        this.setInt(cycleCountA, v, null);
    }

    @Generated
    public int getCycleCountB() {
        return this.getInt(cycleCountB);
    }

    @Generated
    public void setCycleCountB(int v) {
        this.setInt(cycleCountB, v, null);
    }

    @Generated
    public int getCycleCountC() {
        return this.getInt(cycleCountC);
    }

    @Generated
    public void setCycleCountC(int v) {
        this.setInt(cycleCountC, v, null);
    }

    @Generated
    public int getCycleCountD() {
        return this.getInt(cycleCountD);
    }

    @Generated
    public void setCycleCountD(int v) {
        this.setInt(cycleCountD, v, null);
    }

    @Generated
    public int getCycleCountE() {
        return this.getInt(cycleCountE);
    }

    @Generated
    public void setCycleCountE(int v) {
        this.setInt(cycleCountE, v, null);
    }

    @Generated
    public int getCycleCountF() {
        return this.getInt(cycleCountF);
    }

    @Generated
    public void setCycleCountF(int v) {
        this.setInt(cycleCountF, v, null);
    }

    @Generated
    public int getCycleCountG() {
        return this.getInt(cycleCountG);
    }

    @Generated
    public void setCycleCountG(int v) {
        this.setInt(cycleCountG, v, null);
    }

    @Generated
    public int getCycleCountH() {
        return this.getInt(cycleCountH);
    }

    @Generated
    public void setCycleCountH(int v) {
        this.setInt(cycleCountH, v, null);
    }

    @Generated
    public int getCycleCountI() {
        return this.getInt(cycleCountI);
    }

    @Generated
    public void setCycleCountI(int v) {
        this.setInt(cycleCountI, v, null);
    }

    @Generated
    public int getCycleCountJ() {
        return this.getInt(cycleCountJ);
    }

    @Generated
    public void setCycleCountJ(int v) {
        this.setInt(cycleCountJ, v, null);
    }

    @Generated
    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    @Generated
    public void feedbackTimerExpired() {
        this.invoke(feedbackTimerExpired, null, null);
    }

    @Generated
    public void clearAlarmState() {
        this.invoke(clearAlarmState, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.initNumberOutputs();
    }

    public void atSteadyState() {
        this.currentIn = this.getIn().getValue();
        this.calculate();
    }

    public void changed(Property p, Context cx) {
        if (p == numberOutputs) {
            this.initNumberOutputs();
        }
        if (!this.isRunning()) {
            return;
        }
        if (p == in) {
            this.currentIn = this.getIn().getValue();
            this.calculate();
        } else if (p == feedback) {
            if (!this.currentIn) {
                return;
            }
            if (this.getFeedback().getValue()) {
                return;
            }
            if (this.feedbackTimerActive) {
                return;
            }
            this.setCurrentOutputAlarm(true);
            this.getCycleCounts();
            this.startOutput();
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        block12: for (int i = 0; i < 10; ++i) {
            int setFlags = i >= this.numOutputs ? 6 : 10;
            switch (i) {
                case 0: {
                    this.initSlot("outA", setFlags | 1);
                    this.initSlot("cycleCountA", setFlags);
                    continue block12;
                }
                case 1: {
                    this.initSlot("outB", setFlags | 1);
                    this.initSlot("cycleCountB", setFlags);
                    continue block12;
                }
                case 2: {
                    this.initSlot("outC", setFlags | 1);
                    this.initSlot("cycleCountC", setFlags);
                    continue block12;
                }
                case 3: {
                    this.initSlot("outD", setFlags | 1);
                    this.initSlot("cycleCountD", setFlags);
                    continue block12;
                }
                case 4: {
                    this.initSlot("outE", setFlags | 1);
                    this.initSlot("cycleCountE", setFlags);
                    continue block12;
                }
                case 5: {
                    this.initSlot("outF", setFlags | 1);
                    this.initSlot("cycleCountF", setFlags);
                    continue block12;
                }
                case 6: {
                    this.initSlot("outG", setFlags | 1);
                    this.initSlot("cycleCountG", setFlags);
                    continue block12;
                }
                case 7: {
                    this.initSlot("outH", setFlags | 1);
                    this.initSlot("cycleCountH", setFlags);
                    continue block12;
                }
                case 8: {
                    this.initSlot("outI", setFlags | 1);
                    this.initSlot("cycleCountI", setFlags);
                    continue block12;
                }
                case 9: {
                    this.initSlot("outJ", setFlags | 1);
                    this.initSlot("cycleCountJ", setFlags);
                }
            }
        }
    }

    void initSlot(String slot, int flags) {
        try {
            this.setFlags(this.getSlot(slot), flags, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doClearAlarmState() {
        if (this.alarmClearTicket != null) {
            this.alarmClearTicket.cancel();
            this.alarmClearTicket = null;
        }
        for (int i = 0; i < this.numOutputs; ++i) {
            this.getStatusOutput(i).setStatusInAlarm(false);
        }
    }

    public void doRotateTimerExpired() {
        if (!this.currentIn) {
            return;
        }
        this.getCycleCounts();
        this.startOutput();
    }

    public void doFeedbackTimerExpired() {
        this.feedbackTimerActive = false;
        if (!this.currentIn) {
            return;
        }
        if (this.getFeedback().getValue()) {
            return;
        }
        this.setCurrentOutputAlarm(true);
        this.getCycleCounts();
        this.startOutput();
    }

    void calculate() {
        this.getCycleCounts();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
                if (this.feedbackTicket != null) {
                    this.feedbackTicket.cancel();
                }
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    void getCycleCounts() {
        for (int i = 0; i < this.numOutputs; ++i) {
            this.cycleCounts[i] = this.isCycleCountLinked(i) && !this.getOutValue(i) ? this.getCycleCount(i) : Integer.MAX_VALUE;
        }
    }

    int getCycleCount(int index) {
        switch (index) {
            case 0: {
                return this.getCycleCountA();
            }
            case 1: {
                return this.getCycleCountB();
            }
            case 2: {
                return this.getCycleCountC();
            }
            case 3: {
                return this.getCycleCountD();
            }
            case 4: {
                return this.getCycleCountE();
            }
            case 5: {
                return this.getCycleCountF();
            }
            case 6: {
                return this.getCycleCountG();
            }
            case 7: {
                return this.getCycleCountH();
            }
            case 8: {
                return this.getCycleCountI();
            }
            case 9: {
                return this.getCycleCountJ();
            }
        }
        return Integer.MAX_VALUE;
    }

    boolean getOutValue(int index) {
        switch (index) {
            case 0: {
                return this.getOutA().getValue();
            }
            case 1: {
                return this.getOutB().getValue();
            }
            case 2: {
                return this.getOutC().getValue();
            }
            case 3: {
                return this.getOutD().getValue();
            }
            case 4: {
                return this.getOutE().getValue();
            }
            case 5: {
                return this.getOutF().getValue();
            }
            case 6: {
                return this.getOutG().getValue();
            }
            case 7: {
                return this.getOutH().getValue();
            }
            case 8: {
                return this.getOutI().getValue();
            }
            case 9: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean isCycleCountLinked(int index) {
        BLink[] links = null;
        switch (index) {
            case 0: {
                links = this.getLinks(this.getSlot("cycleCountA"));
                break;
            }
            case 1: {
                links = this.getLinks(this.getSlot("cycleCountB"));
                break;
            }
            case 2: {
                links = this.getLinks(this.getSlot("cycleCountC"));
                break;
            }
            case 3: {
                links = this.getLinks(this.getSlot("cycleCountD"));
                break;
            }
            case 4: {
                links = this.getLinks(this.getSlot("cycleCountE"));
                break;
            }
            case 5: {
                links = this.getLinks(this.getSlot("cycleCountF"));
                break;
            }
            case 6: {
                links = this.getLinks(this.getSlot("cycleCountG"));
                break;
            }
            case 7: {
                links = this.getLinks(this.getSlot("cycleCountH"));
                break;
            }
            case 8: {
                links = this.getLinks(this.getSlot("cycleCountI"));
                break;
            }
            case 9: {
                links = this.getLinks(this.getSlot("cycleCountJ"));
            }
        }
        if (links == null) {
            return false;
        }
        return links.length != 0;
    }

    void startOutput() {
        int i;
        int minCycleCounts = Integer.MAX_VALUE;
        int index = 0;
        for (i = 0; i < this.numOutputs; ++i) {
            if (this.getStatusOutput(i).getStatus().isAlarm() || this.cycleCounts[i] >= minCycleCounts) continue;
            minCycleCounts = this.cycleCounts[i];
            index = i;
        }
        for (i = 0; i < this.numOutputs; ++i) {
            this.getStatusOutput(i).setValue(index == i);
        }
        this.startRotateTimer();
        this.startFeedbackTimer();
    }

    BStatusBoolean getStatusOutput(int index) {
        switch (index) {
            case 0: {
                return this.getOutA();
            }
            case 1: {
                return this.getOutB();
            }
            case 2: {
                return this.getOutC();
            }
            case 3: {
                return this.getOutD();
            }
            case 4: {
                return this.getOutE();
            }
            case 5: {
                return this.getOutF();
            }
            case 6: {
                return this.getOutG();
            }
            case 7: {
                return this.getOutH();
            }
            case 8: {
                return this.getOutI();
            }
            case 9: {
                return this.getOutJ();
            }
        }
        if (index < 0) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    void setCurrentOutputAlarm(boolean alarm) {
        if (alarm) {
            this.startAlarmClearTimer();
        }
        for (int i = 0; i < this.numOutputs; ++i) {
            BStatusBoolean currentOut = this.getStatusOutput(i);
            if (!currentOut.getValue()) continue;
            currentOut.setStatusInAlarm(alarm);
        }
    }

    void stopOutput() {
        for (int i = 0; i < this.numOutputs; ++i) {
            this.getStatusOutput(i).setValue(false);
        }
    }

    void startAlarmClearTimer() {
        BRelTime clearTime = this.getClearAlarmTime();
        if (clearTime.getMillis() == 0L || this.alarmClearTicket != null) {
            return;
        }
        this.alarmClearTicket = Clock.schedule((BComponent)this, (BRelTime)clearTime, (Action)clearAlarmState, null);
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.rotateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getMaxRuntime(), (Action)rotateTimerExpired, null);
    }

    void startFeedbackTimer() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        this.feedbackTimerActive = true;
        this.feedbackTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpired, null);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }
}

