/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.timer;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.makeNumeric()"), @NiagaraProperty(name="in", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="updateTime", type="BRelTime", defaultValue="BRelTime.make(1000)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0))")}), @NiagaraProperty(name="maxStepSize", type="double", defaultValue="0.5d"), @NiagaraProperty(name="out", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10)})
@NiagaraAction(name="timerExpired", flags=4)
public class BNumericDelay
extends BComponent
implements BIStatus,
BINumeric {
    @Generated
    public static final Property facets = BNumericDelay.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    @Generated
    public static final Property in = BNumericDelay.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property updateTime = BNumericDelay.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    @Generated
    public static final Property maxStepSize = BNumericDelay.newProperty((int)0, (double)0.5, null);
    @Generated
    public static final Property out = BNumericDelay.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Action timerExpired = BNumericDelay.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNumericDelay.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    Clock.Ticket ticket;

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    @Generated
    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public BRelTime getUpdateTime() {
        return (BRelTime)this.get(updateTime);
    }

    @Generated
    public void setUpdateTime(BRelTime v) {
        this.set(updateTime, (BValue)v, null);
    }

    @Generated
    public double getMaxStepSize() {
        return this.getDouble(maxStepSize);
    }

    @Generated
    public void setMaxStepSize(double v) {
        this.setDouble(maxStepSize, v, null);
    }

    @Generated
    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    @Generated
    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    @Generated
    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.startTimer();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == updateTime) {
            this.startTimer();
        } else if (p == in && this.ticket == null) {
            this.calculate();
        }
    }

    public void calculate() {
        if (!this.getIn().getStatus().isValid()) {
            return;
        }
        double input = this.getIn().getValue();
        double output = this.getOut().getValue();
        double delta = input - output;
        if (input != output) {
            if (this.getUpdateTime().getMillis() == 0L) {
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.setOutput(input);
            } else if ((double)((float)Math.abs(delta)) > this.getMaxStepSize()) {
                if (input > output) {
                    this.setOutput(output + this.getMaxStepSize());
                } else {
                    this.setOutput(output - this.getMaxStepSize());
                }
            } else {
                this.setOutput(input);
            }
        }
    }

    private void setOutput(double value) {
        this.getOut().setValue(value);
    }

    public void doTimerExpired() {
        this.calculate();
    }

    void startTimer() {
        BRelTime time;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if ((time = this.getUpdateTime()).getMillis() != 0L) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)time, (Action)timerExpired, null);
        }
    }

    public String toString(Context cx) {
        return this.getOut().toString(cx);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == out) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public double getNumeric() {
        return this.getOut().getValue();
    }

    public final BFacets getNumericFacets() {
        return this.getFacets();
    }

    public BIcon getIcon() {
        return icon;
    }
}

