/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import javax.baja.control.BBooleanPoint;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="period", type="BRelTime", defaultValue="BRelTime.make(1000)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(200))")}), @NiagaraProperty(name="dutyCycle", type="int", defaultValue="50", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100))")})})
public class BMultiVibrator
extends BBooleanPoint {
    @Generated
    public static final Property enabled = BMultiVibrator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property period = BMultiVibrator.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)200L)));
    @Generated
    public static final Property dutyCycle = BMultiVibrator.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    @Generated
    public static final Type TYPE = Sys.loadType(BMultiVibrator.class);
    private static final BIcon icon = BIcon.std((String)"control/util/sine.png");
    private Clock.Ticket ticket = null;
    static final Log log = Log.getLog((String)"kitControl");
    private long start;
    private BRelTime highTime;
    private BRelTime lowTime;
    private boolean high = false;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRelTime getPeriod() {
        return (BRelTime)this.get(period);
    }

    @Generated
    public void setPeriod(BRelTime v) {
        this.set(period, (BValue)v, null);
    }

    @Generated
    public int getDutyCycle() {
        return this.getInt(dutyCycle);
    }

    @Generated
    public void setDutyCycle(int v) {
        this.setInt(dutyCycle, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.initTimer();
    }

    private synchronized void initTimer() {
        int cycle = this.getDutyCycle();
        if (cycle <= 0) {
            cycle = 0;
        } else if (cycle >= 100) {
            cycle = 100;
        }
        this.highTime = BRelTime.make((long)(this.getPeriod().getMillis() * (long)cycle / 100L));
        this.lowTime = BRelTime.make((long)(this.getPeriod().getMillis() * (long)(100 - cycle) / 100L));
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.getEnabled()) {
            this.ticket = Clock.schedule((BComponent)this, (BRelTime)this.lowTime, (Action)execute, null);
        }
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if ((prop == period || prop == dutyCycle || prop == enabled) && this.isRunning()) {
            this.initTimer();
        }
    }

    public synchronized void onExecute(BStatusValue o, Context cx) {
        if (this.getEnabled()) {
            if (this.highTime.getMillis() <= 0L) {
                this.high = false;
            } else if (this.lowTime.getMillis() <= 0L) {
                this.high = true;
            } else if (this.high) {
                this.high = false;
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                if (this.isRunning()) {
                    this.ticket = Clock.schedule((BComponent)this, (BRelTime)this.lowTime, (Action)execute, null);
                }
            } else {
                this.high = true;
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                if (this.isRunning()) {
                    this.ticket = Clock.schedule((BComponent)this, (BRelTime)this.highTime, (Action)execute, null);
                }
            }
            BStatusBoolean out = (BStatusBoolean)o;
            out.setValue(this.high);
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

