/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.pciCards.BPciCard;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.UsbInfoQnx;
import com.tridium.platform.BPlatformService;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="baseBoardType", type="BBaseBoard", defaultValue="new BBaseBoard()", flags=3)
@NiagaraActions(value={@NiagaraAction(name="scan", flags=4), @NiagaraAction(name="simulateQnxCodes", parameterType="BString", defaultValue="BString.make(\"01 FF FF FF FF FF FF FF FF\")", flags=4)})
public class BHardwareScanService
extends BPlatformService {
    @Generated
    public static final Property baseBoardType = BHardwareScanService.newProperty((int)3, (BValue)new BBaseBoard(), null);
    @Generated
    public static final Action scan = BHardwareScanService.newAction((int)4, null);
    @Generated
    public static final Action simulateQnxCodes = BHardwareScanService.newAction((int)4, (BValue)BString.make((String)"01 FF FF FF FF FF FF FF FF"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHardwareScanService.class);
    private final Subscriber lonListener = new Subscriber(){

        public void event(BComponentEvent event) {
            BComponent network;
            BStruct lonCommConfig;
            String deviceName;
            BPort port;
            String slotName = event.getSlotName();
            if (slotName.equals("lonCommConfig")) {
                BComponent network2 = event.getSourceComponent();
                if (((BBoolean)network2.get("enabled")).getBoolean() && !((BStatus)network2.get("status")).isFault()) {
                    BPort[] allPorts;
                    String networkName = network2.getName();
                    BStruct lonCommConfig2 = (BStruct)network2.get("lonCommConfig");
                    String deviceName2 = lonCommConfig2.get("deviceName").toString();
                    for (BPort nextPort : allPorts = BHardwareScanService.this.getAllPorts()) {
                        if (nextPort == null) continue;
                        if (nextPort.getName().equals(deviceName2)) {
                            nextPort.updateOwnerAndStatus(networkName);
                            continue;
                        }
                        if (!nextPort.getOwner().equals(networkName)) continue;
                        nextPort.updateOwnerAndStatus("none");
                    }
                }
            } else if (slotName.equals("enabled") && (port = BHardwareScanService.this.getPort(deviceName = (lonCommConfig = (BStruct)(network = event.getSourceComponent()).get("lonCommConfig")).get("deviceName").toString())) != null) {
                if (((BBoolean)event.getValue()).getBoolean() && !((BStatus)network.get("status")).isFault()) {
                    port.updateOwnerAndStatus(network.getName());
                } else {
                    port.updateOwnerAndStatus("none");
                }
            }
        }
    };
    private final Subscriber lonNameChangeListener = new Subscriber(){

        public void event(BComponentEvent event) {
            BComponent network;
            if (event.getId() == 3 && event.getSlot().asProperty().getType().getTypeSpec().equals((Object)lonTypeSpec) && ((BBoolean)(network = (BComponent)event.getSourceComponent().get(event.getSlotName())).get("enabled")).getBoolean() && !((BStatus)network.get("status")).isFault()) {
                network.lease(2);
                BStruct lonCommConfig = (BStruct)network.get("lonCommConfig");
                BPort port = BHardwareScanService.this.getPort(((BString)lonCommConfig.get("deviceName")).getString());
                if (port != null) {
                    port.updateOwnerAndStatus(network.getName());
                }
            }
        }
    };
    private final Subscriber serialPortServiceListener = new Subscriber(){

        public void event(BComponentEvent event) {
            BPort port;
            if (event.getId() == 1 && event.getSlotName().startsWith("COM")) {
                this.subscribe((BComponent)event.getSourceComponent().get(event.getSlotName()));
            } else if (event.getId() == 0 && event.getSlotName().equals("owner") && (port = BHardwareScanService.this.getPort(event.getSourceComponent().getName())) != null) {
                port.updateOwnerAndStatus(((BString)event.getValue()).getString());
            }
        }
    };
    private final ServiceListener serviceListener = new ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceEvent(BServiceEvent event) {
            if (event.getServiceType().getTypeSpec().equals((Object)lonTypeSpec)) {
                ServiceListener serviceListener = BHardwareScanService.this.serviceListener;
                synchronized (serviceListener) {
                    BComponent lonNetwork = (BComponent)event.getService();
                    if (event.getId() == 0) {
                        BHardwareScanService.this.lonListener.subscribe(lonNetwork);
                        BHardwareScanService.this.lonNameChangeListener.subscribe((BComponent)lonNetwork.getParent());
                    } else if (event.getId() == 1) {
                        BStruct lonCommConfig = (BStruct)lonNetwork.get("lonCommConfig");
                        String deviceName = lonCommConfig.get("deviceName").toString();
                        BPort port = BHardwareScanService.this.getPort(deviceName);
                        if (port != null) {
                            port.updateOwnerAndStatus("none");
                        }
                        BHardwareScanService.this.lonListener.unsubscribe(lonNetwork);
                    }
                }
            }
        }
    };
    private static final BIcon ICON = BIcon.std((String)"glasses.png");
    public static final Lexicon lex = Lexicon.make(BHardwareScanService.class);
    public static final Logger log = Logger.getLogger("platHwScan");
    public static final BTypeSpec lonTypeSpec = BTypeSpec.make((String)"lonworks:LonNetwork");
    public static final BTypeSpec serialPortSvcTypeSpec = BTypeSpec.make((String)"platSerial:SerialPortPlatformService");
    public static final BTypeSpec tcpPlatformSvcTypeSpec = BTypeSpec.make((String)"platform:TcpIpPlatformService");
    private String simulationString;
    private OperatingSystemEnum operatingSystem;

    @Generated
    public BBaseBoard getBaseBoardType() {
        return (BBaseBoard)this.get(baseBoardType);
    }

    @Generated
    public void setBaseBoardType(BBaseBoard v) {
        this.set(baseBoardType, (BValue)v, null);
    }

    @Generated
    public void scan() {
        this.invoke(scan, null, null);
    }

    @Generated
    public void simulateQnxCodes(BString parameter) {
        this.invoke(simulateQnxCodes, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHardwareScanService() {
        this.setPlatformServiceDescription(lex.getText("HardwareScanService.description"));
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.doScan();
        AccessController.doPrivileged(() -> Nre.getServiceManager()).addServiceListener(this.serviceListener);
        try {
            BPlatformService serialService = (BPlatformService)Sys.getService((Type)serialPortSvcTypeSpec.getResolvedType());
            serialService.checkPropertiesLoaded();
            this.serialPortServiceListener.subscribe((BComponent)serialService, 2);
        }
        catch (Exception e) {
            log.severe(lex.getText("HardwareScanService.serialPortPlatformServiceNotFound"));
        }
        try {
            BComponent[] lonNetworks = Sys.getServices((Type)lonTypeSpec.getResolvedType());
            for (int i = 0; i < lonNetworks.length; ++i) {
                this.lonListener.subscribe(lonNetworks[i]);
                this.lonNameChangeListener.subscribe((BComponent)lonNetworks[i].getParent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void doPoll(Context cx) {
        super.doPoll(cx);
        this.init();
    }

    public int getSlotFlags() {
        return 0;
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    public void scanHardware(boolean simulation) {
        this.removeAll();
        if (PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
            this.scanQnxPlatform(simulation);
        } else {
            String operatingSystemString = AccessController.doPrivileged(() -> System.getProperty("os.name"));
            log.warning(lex.getText("HardwareScanService.operatingSystemNotSupported", new Object[]{TextUtil.capitalize((String)operatingSystemString), this.getTypeDisplayName(null)}));
        }
    }

    public void doScan() {
        this.init();
        this.scanHardware(false);
    }

    public void doSimulateQnxCodes(BString codes) {
        if (!PlatformUtil.isTridiumPlatform()) {
            return;
        }
        this.doSimulation(codes, OperatingSystemEnum.qnx);
    }

    private void doSimulation(BString simString, OperatingSystemEnum os) {
        this.simulationString = simString.getString();
        this.operatingSystem = os;
        this.scanHardware(true);
    }

    protected BPort filterPortsByName(BPort[] ports, String mask) {
        BPort port = null;
        for (int i = 0; i < ports.length && (!(port = ports[i]).getName().equalsIgnoreCase(mask) || port.getStatus().equals((Object)BHwScanStatusEnum.unavailable)); ++i) {
        }
        return port;
    }

    public BPort[] getAllPorts() {
        this.lease(5);
        Array ports = new Array(BPort.class);
        BBaseBoard board = this.getBaseBoardType();
        ports.addAll(board.getChildren(BPort.class));
        for (BOptionSlot slot : (BOptionSlot[])board.getChildren(BOptionSlot.class)) {
            if (!(slot.getContents() instanceof BOptionCard)) continue;
            ports.addAll((Object[])((BOptionCard)slot.getContents()).getPorts());
        }
        return (BPort[])ports.trim();
    }

    public BPort getPort(String name) {
        BPort[] ports = this.getAllPorts();
        return this.filterPortsByName(ports, name);
    }

    private String readOptCardCodes(boolean simulation) throws Exception {
        if (simulation) {
            return this.simulationString;
        }
        return AccessController.doPrivileged(() -> {
            try (BufferedReader reader = new BufferedReader(new FileReader(new File("/dev/shmem/optcardcodes")));){
                String throwable3 = reader.readLine();
                return throwable3;
            }
            catch (Exception ioe) {
                try {
                    UsbInfoQnx info = new UsbInfoQnx();
                    return info.toOptCardCodes();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error reading /dev/shmem/optcardcodes: ", e);
                    log.log(Level.SEVERE, "Error reading /dev/shmem/optcardcodes: ", ioe);
                    return null;
                }
            }
        });
    }

    private void scanQnxPlatform(boolean simulation) {
        try {
            StringTokenizer optCardCodes = new StringTokenizer(this.readOptCardCodes(simulation));
            String platformCode = optCardCodes.nextToken();
            BBaseBoard boardTemplate = BBaseBoard.lookup(platformCode);
            if (boardTemplate == null) {
                this.addBasicPlatform(platformCode);
                return;
            }
            try {
                BBaseBoard baseBoard = (BBaseBoard)boardTemplate.newCopy(true);
                this.setBaseBoardType(baseBoard);
                Array codeArray = new Array(String.class);
                while (optCardCodes.hasMoreTokens()) {
                    codeArray.add((Object)optCardCodes.nextToken().trim());
                }
                log.fine(lex.getText("HardwareScanService.optCodeArray", new Object[]{codeArray}));
                baseBoard.autoConfig((Array<String>)codeArray, simulation);
            }
            catch (Exception e) {
                log.fine(e.getMessage());
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    private void addBasicPlatform(String platformCode) {
        Object modelJar;
        if (!this.getBaseBoardType().getType().equals(BBaseBoard.TYPE)) {
            this.setBaseBoardType(new BBaseBoard());
        }
        if ((modelJar = BBaseBoard.lookupModelJar(platformCode)) != null) {
            this.getBaseBoardType().setProductModel(lex.getText("HardwareScanService.jarRequired", new Object[]{(String)modelJar}));
        } else {
            this.getBaseBoardType().setProductModel(lex.getText("HardwareScanService.baseboardNotRecognized", new Object[]{platformCode, this.getName()}));
        }
        log.warning(this.getBaseBoardType().getProductModel());
    }

    private void init() {
        BOptionCard.buildCardCatalog();
        BPciCard.buildCardCatalog();
        this.operatingSystem = OperatingSystemEnum.getOS();
    }

    public BIcon getIcon() {
        return ICON;
    }
}

