/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ports;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platform.BPlatformService;
import java.util.StringTokenizer;
import javax.baja.license.LicenseManager;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="portType", type="BPortTypeEnum", defaultValue="BPortTypeEnum.unknown", flags=1), @NiagaraProperty(name="status", type="BHwScanStatusEnum", defaultValue="BHwScanStatusEnum.available", flags=1), @NiagaraProperty(name="prefix", type="String", defaultValue="HwScanConst.PORT", flags=5), @NiagaraProperty(name="requiredFeatures", type="String", defaultValue="", flags=5), @NiagaraProperty(name="hasConnector", type="boolean", defaultValue="true", flags=5), @NiagaraProperty(name="owner", type="String", defaultValue="none", flags=1)})
public class BPort
extends BComponent {
    @Generated
    public static final Property portType = BPort.newProperty((int)1, (BValue)BPortTypeEnum.unknown, null);
    @Generated
    public static final Property status = BPort.newProperty((int)1, (BValue)BHwScanStatusEnum.available, null);
    @Generated
    public static final Property prefix = BPort.newProperty((int)5, (String)"Port", null);
    @Generated
    public static final Property requiredFeatures = BPort.newProperty((int)5, (String)"", null);
    @Generated
    public static final Property hasConnector = BPort.newProperty((int)5, (boolean)true, null);
    @Generated
    public static final Property owner = BPort.newProperty((int)1, (String)"none", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPort.class);

    @Generated
    public BPortTypeEnum getPortType() {
        return (BPortTypeEnum)this.get(portType);
    }

    @Generated
    public void setPortType(BPortTypeEnum v) {
        this.set(portType, (BValue)v, null);
    }

    @Generated
    public BHwScanStatusEnum getStatus() {
        return (BHwScanStatusEnum)this.get(status);
    }

    @Generated
    public void setStatus(BHwScanStatusEnum v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getPrefix() {
        return this.getString(prefix);
    }

    @Generated
    public void setPrefix(String v) {
        this.setString(prefix, v, null);
    }

    @Generated
    public String getRequiredFeatures() {
        return this.getString(requiredFeatures);
    }

    @Generated
    public void setRequiredFeatures(String v) {
        this.setString(requiredFeatures, v, null);
    }

    @Generated
    public boolean getHasConnector() {
        return this.getBoolean(hasConnector);
    }

    @Generated
    public void setHasConnector(boolean v) {
        this.setBoolean(hasConnector, v, null);
    }

    @Generated
    public String getOwner() {
        return this.getString(owner);
    }

    @Generated
    public void setOwner(String v) {
        this.setString(owner, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPort() {
    }

    public BPort(BPortTypeEnum portType) {
        this.setPortType(portType);
    }

    public BPort(BPortTypeEnum portType, String features) {
        this.setPortType(portType);
        this.setRequiredFeatures(this.verify(features));
    }

    public BPort(BPortTypeEnum portType, String features, String prefix) {
        this.setPortType(portType);
        this.setRequiredFeatures(this.verify(features));
        this.setPrefix(this.verify(prefix));
    }

    public BPort(BPortTypeEnum portType, String features, String prefix, BHwScanStatusEnum status) {
        this.setPortType(portType);
        this.setRequiredFeatures(this.verify(features));
        this.setPrefix(this.verify(prefix));
        this.setStatus(status);
    }

    public void checkLicense() {
        if (!this.isLicensed()) {
            this.setStatus(BHwScanStatusEnum.notLicensed);
        }
    }

    public boolean isAvailable() {
        return this.getStatus().equals((Object)BHwScanStatusEnum.available);
    }

    public boolean isLicensed() {
        StringTokenizer features = new StringTokenizer(this.getRequiredFeatures(), ",");
        if (features.countTokens() == 0) {
            return true;
        }
        LicenseManager licMgr = Sys.getLicenseManager();
        while (features.hasMoreTokens()) {
            StringTokenizer st = new StringTokenizer(features.nextToken(), ":");
            try {
                licMgr.checkFeature(st.nextToken().trim(), st.nextToken().trim());
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public void initOwnerAndStatus() {
        block7: {
            try {
                if (this.getPrefix().startsWith("COM")) {
                    BPlatformService serialPortService = (BPlatformService)Sys.getService((Type)BHardwareScanService.serialPortSvcTypeSpec.getResolvedType());
                    serialPortService.checkPropertiesLoaded();
                    serialPortService.lease();
                    BComponent servicePort = (BComponent)serialPortService.get(this.getName());
                    servicePort.lease();
                    this.updateOwnerAndStatus(((BString)servicePort.get("owner")).toString().trim());
                    break block7;
                }
                if (!this.getPrefix().startsWith("LON")) break block7;
                BComponent[] networks = Sys.getServices((Type)BHardwareScanService.lonTypeSpec.getResolvedType());
                for (int i = 0; i < networks.length; ++i) {
                    BComponent lon = networks[i];
                    lon.lease(2);
                    BStruct lonCommConfig = (BStruct)lon.get("lonCommConfig");
                    String deviceName = ((BString)lonCommConfig.get("deviceName")).toString();
                    if (!deviceName.equals(this.getName()) || !((BStatus)lon.get("status")).isOk()) continue;
                    this.updateOwnerAndStatus(lon.getName());
                    break;
                }
            }
            catch (ModuleNotFoundException mnfe) {
                BHardwareScanService.log.severe(BHardwareScanService.lex.getText("moduleNotFound", new Object[]{mnfe.getMessage(), this.getName()}));
            }
            catch (NullPointerException npe) {
                BHardwareScanService.log.warning(BHardwareScanService.lex.getText("moduleNotFound", new Object[]{npe.getMessage(), this.getName()}));
            }
            catch (ServiceNotFoundException npe) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateOwnerAndStatus(String owner) {
        if (this.getStatus().equals((Object)BHwScanStatusEnum.available) || this.getStatus().equals((Object)BHwScanStatusEnum.unavailable) || this.getStatus().equals((Object)BHwScanStatusEnum.inUse)) {
            this.setOwner(owner);
            if (owner.equals("dbgjmpr")) {
                this.setStatus(BHwScanStatusEnum.serialShell);
            } else if (!owner.equals("none")) {
                this.setStatus(BHwScanStatusEnum.inUse);
            } else {
                this.setStatus(BHwScanStatusEnum.available);
            }
        }
    }

    private String verify(String arg) {
        if (arg == null || arg.equalsIgnoreCase(BHardwareScanService.lex.getText("none"))) {
            return "";
        }
        return arg;
    }
}

