/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ports;

import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.enums.BWifiModeEnum;
import com.tridium.platHwScan.ports.BEthernetPort;
import java.io.File;
import java.security.AccessController;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="Mode", type="BWifiModeEnum", defaultValue="BWifiModeEnum.DEFAULT", flags=1)
public class BWifiPort
extends BEthernetPort {
    @Generated
    public static final Property Mode = BWifiPort.newProperty((int)1, (BValue)BWifiModeEnum.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiPort.class);
    public static final String CLIENT_ID = "tiw_sta0";
    public static final String AP_ID = "tiw_sap0";

    @Generated
    public BWifiModeEnum getMode() {
        return (BWifiModeEnum)this.get(Mode);
    }

    @Generated
    public void setMode(BWifiModeEnum v) {
        this.set(Mode, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiPort() {
        this.setPortType(BPortTypeEnum.wifi);
    }

    public BWifiPort(String id) {
        super(id);
        this.setAdapterId(id);
        this.setPortType(BPortTypeEnum.wifi);
    }

    @Override
    public void initStatus() {
        String status = AccessController.doPrivileged(() -> {
            try {
                return FileUtil.readString((File)new File("/var/run/wilink"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        if (status == null) {
            this.setStatus(BHwScanStatusEnum.unknown);
            this.setMode(BWifiModeEnum.disabled);
            this.setAdapterId("");
        } else if (status.toLowerCase().contains("sta")) {
            this.setStatus(BHwScanStatusEnum.available);
            this.setMode(BWifiModeEnum.client);
            this.setAdapterId(CLIENT_ID);
        } else if (status.toLowerCase().contains("sap")) {
            this.setStatus(BHwScanStatusEnum.available);
            this.setMode(BWifiModeEnum.ap);
            this.setAdapterId(AP_ID);
        } else {
            this.setStatus(BHwScanStatusEnum.disabled);
            this.setMode(BWifiModeEnum.disabled);
            this.setAdapterId("");
        }
    }
}

