/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.util;

import com.tridium.platHwScan.BHardwareScanService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class UsbInfoQnx {
    public static final String SERIAL_PORT_PREFIX = "COM";
    public static final String LON_PORT_PREFIX = "LON";
    public static final int NUM_U_MAP_SPACE_DELIMITED_FIELDS = 10;
    public static final int NUM_U_MAP_PAREN_DELIMITED_FIELDS = 2;
    private ArrayList<ArrayList<HashMap<String, String>>> buses = this.makeBuses();
    private String usbConfigError = "none";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ArrayList<HashMap<String, String>>> makeBuses() {
        HashMap<String, String> currentDevice;
        BufferedReader br = this.accessFile("/tmp/u_map", false);
        if (br == null) {
            return null;
        }
        ArrayList<ArrayList<HashMap<String, String>>> buses = new ArrayList<ArrayList<HashMap<String, String>>>();
        ArrayList bus0_arrayList = new ArrayList();
        ArrayList bus1_arrayList = new ArrayList();
        buses.add(bus0_arrayList);
        buses.add(bus1_arrayList);
        String oldPosition = "-1";
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                int vendorParenStart = line.indexOf(" (");
                String vendorStr = this.extractFromParens(vendorParenStart, line).trim();
                int vendorStrEnd = line.indexOf(vendorStr) + vendorStr.length() + 2;
                String productStr = this.extractFromParens(vendorStrEnd, line).trim();
                String infoLine = line.substring(0, vendorParenStart - 1);
                StringTokenizer st = new StringTokenizer(infoLine);
                if (st.countTokens() != 10) {
                    ArrayList<ArrayList<HashMap<String, String>>> arrayList = null;
                    return arrayList;
                }
                String name = st.nextToken();
                String osName = st.nextToken();
                int busNum = Integer.parseInt(st.nextToken());
                st.nextToken();
                String position = st.nextToken();
                if (position.equals(oldPosition)) continue;
                oldPosition = position;
                String vendorId = st.nextToken();
                String productId = st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                currentDevice = new HashMap();
                currentDevice.put("Vendor", vendorId);
                currentDevice.put("Product", productId);
                currentDevice.put("Position", position);
                currentDevice.put("Name", name);
                currentDevice.put("OsName", osName);
                currentDevice.put("VendorStr", vendorStr);
                currentDevice.put("ProductStr", productStr);
                if (busNum == 0) {
                    bus0_arrayList.add(currentDevice);
                    continue;
                }
                if (busNum != 1) continue;
                bus1_arrayList.add(currentDevice);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (bus1_arrayList.size() == 0) {
            String errorStr;
            BufferedReader errfile = this.accessFile("/tmp/u_map_error", false);
            if (errfile == null) {
                return buses;
            }
            try {
                errorStr = errfile.readLine();
            }
            catch (IOException e) {
                BHardwareScanService.log.severe("Cannot read USB error log");
                errorStr = "unknown error";
            }
            if (br != null) {
                for (int i = 0; i < 4; ++i) {
                    currentDevice = new HashMap<String, String>();
                    currentDevice.put("Vendor", "XX");
                    currentDevice.put("Product", "XX");
                    currentDevice.put("Position", "" + (i + 1));
                    currentDevice.put("Name", "ERROR");
                    currentDevice.put("OsName", "none");
                    currentDevice.put("VendorStr", "none");
                    currentDevice.put("ProductStr", errorStr);
                    bus1_arrayList.add(currentDevice);
                }
            }
        }
        return buses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toOptCardCodes() throws IOException {
        String codes;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File("/sys/info/model")));
            codes = reader.readLine();
            ArrayList<HashMap<String, String>> bus = this.buses.get(1);
            for (HashMap<String, String> device : bus) {
                String vendor = device.get("Vendor");
                String product = device.get("Product");
                vendor = vendor.replace("0x", "").toUpperCase();
                product = product.replace("0x", "").toUpperCase();
                String code = vendor + " " + product;
                codes = codes + " " + vendor + " " + product;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return codes;
    }

    public boolean isOccupied() {
        String deviceStr = this.readUsb0Dev3();
        return !deviceStr.equals("none");
    }

    public String getUsbConfigError() {
        BufferedReader br = this.accessFile("/tmp/u_map_error", false);
        if (br == null) {
            return "none";
        }
        try {
            this.usbConfigError = br.readLine();
        }
        catch (IOException e) {
            this.usbConfigError = "unable to read USB error file";
            BHardwareScanService.log.warning("unable to read USB error file");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.usbConfigError;
    }

    private String readUsb0Dev3() {
        String productStr = "none";
        try {
            Process proc = AccessController.doPrivileged(() -> {
                try {
                    return new ProcessBuilder("/proc/boot/usb", "-b0", "-d3").start();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            });
            ArrayList buses = new ArrayList();
            ArrayList currentBus = new ArrayList();
            HashMap currentDevice = new HashMap();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("Product    ")) continue;
                    String[] strings = line.split(":");
                    productStr = strings[1];
                    break;
                }
            }
        }
        catch (IOException e) {
            BHardwareScanService.log.warning("Could not determine device attached to USB port");
        }
        return productStr;
    }

    private String extractFromParens(int startNdx, String line) {
        StringCharacterIterator characterIterator = new StringCharacterIterator(line, startNdx, line.length(), startNdx);
        char c = characterIterator.first();
        int leftParenCount = 0;
        boolean reading = false;
        StringBuilder sb = new StringBuilder();
        while (c != '\uffff') {
            if (c == '(') {
                if (++leftParenCount == 1) {
                    reading = true;
                    c = characterIterator.next();
                    continue;
                }
            } else if (c == ')' && leftParenCount > 0 && --leftParenCount == 0) break;
            if (reading) {
                sb.append(c);
            }
            c = characterIterator.next();
        }
        return sb.toString();
    }

    private BufferedReader accessFile(String fileName, boolean reportError) {
        BufferedReader br;
        block2: {
            br = null;
            try {
                br = AccessController.doPrivileged(() -> new BufferedReader(new FileReader(fileName)));
            }
            catch (PrivilegedActionException e) {
                if (!reportError) break block2;
                e.printStackTrace();
            }
        }
        return br;
    }
}

