/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.ui;

import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.ui.NMgrLearn;
import com.tridium.ndriver.ui.point.BNPointManager;
import com.tridium.ndriver.ui.point.NPointController;
import com.tridium.ndriver.ui.point.NPointModel;
import com.tridium.opcUaCore.enums.BUaDataType;
import com.tridium.opcUaCore.util.OpcUaCoreUtil;
import com.tridium.opcUaServer.export.BBooleanExport;
import com.tridium.opcUaServer.export.BEnumExport;
import com.tridium.opcUaServer.export.BNumericExport;
import com.tridium.opcUaServer.export.BStringExport;
import com.tridium.opcUaServer.point.BOpcUaServerLearnPointEntry;
import com.tridium.opcUaServer.point.BOpcUaServerPointFolder;
import com.tridium.opcUaServer.point.BOpcUaServerProxyExt;
import com.tridium.opcUaServer.util.OpcUaServerUtil;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"opcUaServer:OpcUaServerPointDeviceExt", "opcUaServer:OpcUaServerPointFolder"})})
public class BOpcUaServerPointManager
extends BNPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaServerPointManager.class);
    static Lexicon lex = Lexicon.make(BOpcUaServerPointManager.class);
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colToString = new MgrColumn.ToString("Out", 0);
    MgrColumn colNodeId = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaServerProxyExt.uaNodeId}, 4);
    MgrColumn colUaDataType = new uaDataTypeColumn();
    MgrColumn colDirection = new DirectionColumn();
    MgrColumn colLocalPoint = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaServerProxyExt.localPoint}, 1);
    MgrColumn colPointSlot = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOpcUaServerProxyExt.localPointSlot}, 1);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 1);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colToString, this.colNodeId, this.colUaDataType, this.colDirection, this.colLocalPoint, this.colPointSlot, this.colEnabled, this.colFacets, this.colTuning, this.colDeviceFacets, this.colConversion, this.colFaultCause, this.colReadValue, this.colWriteValue};
    Type proxyExtType = BOpcUaServerProxyExt.TYPE;
    private static final OpcUaMgrTypeInfo numericType = new OpcUaMgrTypeInfo(BNumericExport.TYPE, BNumericPoint.TYPE);
    private static final OpcUaMgrTypeInfo booleanType = new OpcUaMgrTypeInfo(BBooleanExport.TYPE, BBooleanPoint.TYPE);
    private static final OpcUaMgrTypeInfo enumType = new OpcUaMgrTypeInfo(BEnumExport.TYPE, BEnumPoint.TYPE);
    private static final OpcUaMgrTypeInfo stringType = new OpcUaMgrTypeInfo(BStringExport.TYPE, BStringPoint.TYPE);
    private static final Logger logger = Logger.getLogger("opcUaServer");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn((BAbstractManager)this);
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        Version version = (Version)obj.asComponent().fw(404, (Object)"opcUaServer", (Object)"rt", null, null);
        this.getController().newCommand.setEnabled(BOpcUaServerPointManager.isWritablePointSupported(version));
    }

    private static boolean isWritablePointSupported(Version version) {
        return version.compareTo(OpcUaCoreUtil.WRITABLE_POINT_FIRST_VERSION) >= 0;
    }

    static class DirectionColumn
    extends MgrColumn {
        public DirectionColumn() {
            super(lex.getText("opcUaServer.pointManager.columnTitle.direction"));
        }

        public Object get(Object row) {
            if (row instanceof BControlPoint) {
                BControlPoint point = (BControlPoint)row;
                BAbstractProxyExt ext = point.getProxyExt();
                if (point.isWritablePoint()) {
                    return lex.getText("opcUaServer.pointManager.direction.bidirectional");
                }
                if (ext instanceof BOpcUaServerProxyExt) {
                    return ((BOpcUaServerProxyExt)ext).isExport() ? lex.getText("opcUaServer.pointManager.direction.export") : lex.getText("opcUaServer.pointManager.direction.import");
                }
            }
            return "";
        }
    }

    private static class uaDataTypeColumn
    extends MgrColumn {
        boolean isDefault;
        String uaDataTypeProp = "uaDataType";

        public uaDataTypeColumn() {
            super(lex.getText("opcUaServer.pointManager.columnTitle.uaDataType"), 3);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BOpcUaServerProxyExt) {
                return ((BOpcUaServerProxyExt)ext).getUaDataType().getTag();
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            BAbstractProxyExt ext;
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BOpcUaServerProxyExt) {
                return OpcUaServerUtil.getSupportedUaDataTypes((BControlPoint)((BControlPoint)val));
            }
            this.isDefault = true;
            BEnumRange inRange = BEnumRange.make((String[])new String[]{lex.getText("opcUaServer.pointManager.columnValue.uaDataType.notAvailable")});
            return BDynamicEnum.make((int)0, (BEnumRange)inRange);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BAbstractProxyExt ext;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BOpcUaServerProxyExt) {
                ((BOpcUaServerProxyExt)ext).setUaDataType(BUaDataType.make((String)value.toString()));
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length != 1) {
                return null;
            }
            if (rows[0].getTarget() instanceof BEnumPoint) {
                return null;
            }
            for (MgrEditRow row : rows) {
                BComponent val = row.getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BOpcUaServerProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty(this.uaDataTypeProp)};
            return uaDataTypeColumn.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty(this.uaDataTypeProp)};
            uaDataTypeColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    static class OpcUaMgrTypeInfo
    extends MgrTypeInfo {
        private final TypeInfo exportType;
        private final TypeInfo importType;

        OpcUaMgrTypeInfo(Type exportType, Type importType) {
            this.exportType = exportType.getTypeInfo();
            this.importType = importType.getTypeInfo();
        }

        public TypeInfo getExportType() {
            return this.exportType;
        }

        public TypeInfo getImportType() {
            return this.importType;
        }

        public BImage getIcon() {
            return null;
        }

        public String getDisplayName() {
            return this.exportType.getDisplayName(null);
        }

        public BComponent newInstance() {
            return this.newInstance(true);
        }

        public BComponent newInstance(boolean isExport) {
            BControlPoint pnt = (BControlPoint)(isExport ? this.exportType.getInstance() : this.importType.getInstance());
            BOpcUaServerProxyExt ext = new BOpcUaServerProxyExt();
            pnt.setProxyExt((BAbstractProxyExt)ext);
            return pnt;
        }

        public boolean isMatchable(BComponent db) {
            return false;
        }
    }

    class Learn
    extends NMgrLearn {
        private BNDiscoveryJob discoveryJob;

        public Learn(BAbstractManager manager) {
            super(manager);
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            BOpcUaServerLearnPointEntry disc = (BOpcUaServerLearnPointEntry)discovery;
            BControlPoint instance = (BControlPoint)disc.getPointType().getInstance();
            BStatusValue statusValue = instance.getOutStatusValue();
            if (statusValue instanceof BStatusBoolean) {
                return new OpcUaMgrTypeInfo[]{booleanType};
            }
            if (statusValue instanceof BStatusNumeric) {
                return new OpcUaMgrTypeInfo[]{numericType};
            }
            if (statusValue instanceof BStatusEnum) {
                return new OpcUaMgrTypeInfo[]{enumType};
            }
            if (statusValue instanceof BStatusString) {
                return new OpcUaMgrTypeInfo[]{stringType};
            }
            return new OpcUaMgrTypeInfo[0];
        }

        public boolean hasChildren(Object discovery) {
            return this.getChildren(discovery).length > 0;
        }

        public Object[] getChildren(Object discovery) {
            ArrayList<BOpcUaServerLearnPointEntry> list = new ArrayList<BOpcUaServerLearnPointEntry>();
            BOpcUaServerLearnPointEntry[] children = (BOpcUaServerLearnPointEntry[])((BComponent)discovery).getChildren(BOpcUaServerLearnPointEntry.class);
            if (children == null) {
                return new Object[0];
            }
            for (BOpcUaServerLearnPointEntry child : children) {
                list.add(child);
            }
            return list.toArray();
        }

        public void load(BComponent target) {
            if (target instanceof BOpcUaServerPointFolder) {
                BNDiscoveryJob job = (BNDiscoveryJob)this.getJob();
                if (job != null) {
                    this.updateRoots(job.getRootDiscoveryObjects());
                } else {
                    BValue lj = ((BOpcUaServerPointFolder)target).getDevice().get("lj");
                    if (lj != null && lj instanceof BNDiscoveryJob) {
                        ((BNDiscoveryJob)lj).lease();
                        this.updateRoots(((BNDiscoveryJob)lj).getRootDiscoveryObjects());
                    }
                }
            }
        }

        public void jobComplete(BJob job) {
            if (job instanceof BNDiscoveryJob) {
                this.discoveryJob = (BNDiscoveryJob)job;
                this.updateRoots(this.discoveryJob.getRootDiscoveryObjects());
                BComponent target = this.getManager().getTarget();
                if (target instanceof BIPointFolder) {
                    BDevice device = ((BIPointFolder)target).getDevice();
                    BValue lj = device.get("lj");
                    if (lj != null) {
                        device.remove(lj.asComplex());
                    }
                    device.add("lj", this.discoveryJob.newCopy(), 6);
                }
            }
        }
    }

    static class OpcMgrEditRow
    extends MgrEditRow {
        public OpcMgrEditRow(BComponent target, Object discovery, MgrTypeInfo[] types) {
            super(target, discovery, types);
        }

        public BComponent getTarget(boolean isExport) {
            BControlPoint target = (BControlPoint)super.getTarget();
            try {
                BOpcUaServerProxyExt proxyExt = (BOpcUaServerProxyExt)target.getProxyExt().newCopy();
                MgrTypeInfo availableType = this.getAvailableTypes()[0];
                BControlPoint point = (BControlPoint)(availableType instanceof OpcUaMgrTypeInfo ? ((OpcUaMgrTypeInfo)availableType).newInstance(isExport) : this.getModel().newInstance(MgrTypeInfo.make((Type)target.getType())));
                point.setProxyExt((BAbstractProxyExt)proxyExt);
                return point;
            }
            catch (Exception e) {
                logger.severe("Exception while getting targert: " + e);
                return target;
            }
        }
    }

    class OpcMgrEdit
    extends MgrEdit {
        public OpcMgrEdit(BAbstractManager manager, String title) {
            super(manager, title);
        }

        protected MgrEditRow makeRow(BComponent target, Object discovery, MgrTypeInfo[] types) throws Exception {
            return new OpcMgrEditRow(target, discovery, types);
        }
    }

    class Controller
    extends NPointController {
        Controller(BNPointManager mgr) {
            super(mgr);
        }

        public MgrEdit makeEdit(String label) {
            return new OpcMgrEdit(this.getManager(), label);
        }

        public void updateCommands() {
            super.updateCommands();
            MgrLearn learn = BOpcUaServerPointManager.this.getLearn();
            BLearnTable table = learn.getTable();
            if (table == null) {
                return;
            }
            Object[] selectedObjects = table.getSelectedObjects();
            if (selectedObjects.length == 0) {
                return;
            }
            boolean enable = true;
            this.add.setEnabled(selectedObjects.length > 0 && enable);
        }
    }

    class Model
    extends NPointModel {
        private static final int LOCAL_POINT_SLOT_CELL_INDEX = 3;

        Model(BNPointManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BOpcUaServerPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            if (pt instanceof BNumericWritable) {
                BNumericWritable numericWritable = (BNumericWritable)pt;
                numericWritable.setFallback((BStatusNumeric)BStatusNumeric.make((BObject)BDouble.DEFAULT));
            } else if (pt instanceof BEnumWritable) {
                BEnumWritable enumWritable = (BEnumWritable)pt;
                enumWritable.setFallback((BStatusEnum)BStatusEnum.make((BObject)BDynamicEnum.DEFAULT));
            } else if (pt instanceof BStringWritable) {
                BStringWritable stringWritable = (BStringWritable)pt;
                stringWritable.setFallback((BStatusString)BStatusString.make((BObject)BString.DEFAULT));
            } else if (pt instanceof BBooleanWritable) {
                BBooleanWritable booleanWritable = (BBooleanWritable)pt;
                booleanWritable.setFallback((BStatusBoolean)BStatusBoolean.make((BObject)BBoolean.DEFAULT));
            }
            BAbstractProxyExt ext = (BAbstractProxyExt)BOpcUaServerPointManager.this.proxyExtType.getInstance();
            pt.setProxyExt(ext);
            return pt;
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{BOOLEAN_WRITABLE, NUMERIC_WRITABLE, ENUM_WRITABLE, STRING_WRITABLE};
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            String[] names = new String[rows.length];
            BComponent[] values = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                BValue pointSlot = rows[i].getCell(3);
                boolean isExport = pointSlot.toString().equals("out");
                names[i] = rows[i].getName();
                values[i] = ((OpcMgrEditRow)rows[i]).getTarget(isExport);
            }
            Mark mark = new Mark((BObject[])values, names);
            BComponent container = rows[0].getEdit().getAddContainer();
            mark.moveTo((BObject)container, null);
            return null;
        }
    }
}

