/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde;

import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.bacnetEde.BEdeRecord;
import com.tridium.bacnetEde.EdeCursor;
import com.tridium.bacnetEde.util.CSVReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BEdeReader
extends BObject
implements BITable<BEdeRecord> {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdeReader.class);
    public static final String COMMENT_LINE = "#";
    private BIFile edeCsv;
    private BIFile stateTextsCsv;
    private char delimiter = (char)44;
    private Hashtable<String, BEnumRange> stateTextTable = new Hashtable();
    private BAbsTime timeLastUsed = BAbsTime.now();
    private CSVReader reader;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEdeReader(BEdeConfig config) {
        BOrd edePath = config.getEdePath();
        BOrd stateTextsPath = config.getStateTextsPath();
        String delimiter = config.getDelimiter();
        if (null == edePath || edePath == BOrd.DEFAULT) {
            throw new BajaRuntimeException("Invalid File Path. File Path needed for target EDE file.");
        }
        this.edeCsv = (BIFile)edePath.get();
        if (null != stateTextsPath && stateTextsPath != BOrd.DEFAULT) {
            this.stateTextsCsv = (BIFile)stateTextsPath.get();
        }
        if (null != delimiter) {
            this.delimiter = delimiter.charAt(0);
        }
        this.parseEDE();
    }

    public BAbsTime getTimeLastUsed() {
        return this.timeLastUsed;
    }

    public void close() {
        try {
            if (null != this.reader) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException((Throwable)ioe);
        }
    }

    public TableCursor<BEdeRecord> cursor() {
        this.timeLastUsed = BAbsTime.now();
        this.close();
        this.reader = new CSVReader(this.edeCsv, this.delimiter);
        return new EdeCursor(this, this.reader, this.stateTextTable);
    }

    public ColumnList getColumns() {
        return null;
    }

    public BFacets getTableFacets() {
        return null;
    }

    private void parseEDE() {
        this.buildStateTextMap();
    }

    private void buildStateTextMap() {
        if (null == this.stateTextsCsv) {
            return;
        }
        try (CSVReader reader = new CSVReader(this.stateTextsCsv, this.delimiter);){
            String[] readLine = null;
            while (null != (readLine = reader.readLine()) && readLine.length > 0) {
                String textId = readLine[0];
                if ((textId = textId.trim()).isEmpty() || textId.startsWith(COMMENT_LINE)) continue;
                LinkedList<String> stateTextVals = new LinkedList<String>();
                for (int col = 1; col < readLine.length; ++col) {
                    String val = readLine[col];
                    if ((val = SlotPath.escape((String)val)).equals("")) continue;
                    stateTextVals.add(val);
                }
                String[] tags = stateTextVals.toArray(new String[0]);
                int[] ordinals = new int[tags.length];
                for (int i = 0; i < ordinals.length; ++i) {
                    ordinals[i] = i + 1;
                }
                BEnumRange range = BEnumRange.make((int[])ordinals, (String[])tags);
                this.stateTextTable.put(textId, range);
            }
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException((Throwable)ioe);
        }
    }
}

