/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.baja.file.BIFile;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;

public class CSVReader
implements AutoCloseable {
    private static final char QUOTE_CHAR = '\"';
    private static final char COMMA_DELIMITER = ',';
    private BIFile file;
    private char delimiter = (char)44;
    private BufferedReader reader;
    private String currentLine;
    private boolean hasNext = true;

    public CSVReader(BIFile file) {
        this(file, ',');
    }

    public CSVReader(BIFile file, char delimiter) {
        this.file = file;
        this.delimiter = delimiter;
        try {
            InputStream is = file.getInputStream();
            InputStreamReader in = new InputStreamReader(is);
            this.reader = new BufferedReader(in);
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (null != this.reader) {
            this.reader.close();
        }
    }

    public BIFile getFile() {
        return this.file;
    }

    public String[] readLine() throws IOException {
        String nextLine;
        this.currentLine = nextLine = this.getNextLine();
        return this.hasNext ? this.parseLine(nextLine) : null;
    }

    public String getCurrentLine() {
        return this.currentLine;
    }

    private String getNextLine() throws IOException {
        String nextLine = this.reader.readLine();
        if (nextLine == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    private String[] parseLine(String nextLine) throws IOException {
        if (nextLine == null) {
            return null;
        }
        Array parsedContents = new Array(String.class);
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        do {
            if (inQuotes) {
                sb.append("\n");
                nextLine = this.getNextLine();
                if (nextLine == null) break;
            }
            for (int i = 0; i < nextLine.length(); ++i) {
                char c = nextLine.charAt(i);
                if (c == '\"') {
                    if (inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == '\"') {
                        sb.append(nextLine.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    inQuotes = !inQuotes;
                    continue;
                }
                if (c == this.delimiter && !inQuotes) {
                    parsedContents.add((Object)sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(c);
            }
        } while (inQuotes);
        parsedContents.add((Object)sb.toString());
        return (String[])parsedContents.trim();
    }
}

