/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.wb;

import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.workbench.fieldeditors.BOrdFE;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bacnetEDE:EdeConfig"})})
public class BEdeConfigFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdeConfigFE.class);
    private static final Lexicon lex = Lexicon.make(BEdeConfigFE.class);
    private static final BFacets TARGET_FACETS = BFacets.make((String)"targetType", (String)"file:CsvFile");
    private static final String LBL_NAME = lex.getText("edeconfig.labels.configname");
    private static final String LBL_STATETXT = lex.getText("edeconfig.labels.statetxt");
    private static final String LBL_EDE = lex.getText("edeconfig.labels.ede");
    private static final String LBL_DELIMITER = lex.getText("edeconfig.labels.delimiter");
    private static final String DEF_CONFIG_NAME = "EDEConfig";
    private static final String FILE_ORD = "file:^";
    private BOrdFE stateTextsFileOrdFE = new BOrdFE();
    private BOrdFE edeFileOrdFE = new BOrdFE();
    private BTextField delimiterFE = new BTextField(",", 1);
    private BTextField configNameFE = new BTextField("", 30);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEdeConfigFE() {
        this.buildUI();
    }

    private void buildUI() {
        BGridPane main = new BGridPane(2);
        main.setColorRows(true);
        main.setColumnGap(10.0);
        main.setRowGap(10.0);
        this.stateTextsFileOrdFE.loadValue((BObject)BOrd.make((String)FILE_ORD), (Context)TARGET_FACETS);
        this.edeFileOrdFE.loadValue((BObject)BOrd.make((String)FILE_ORD), (Context)TARGET_FACETS);
        main.add(null, (BValue)new BLabel(lex.getText("key")));
        main.add(null, (BValue)this.configNameFE);
        main.add(null, (BValue)new BLabel(LBL_EDE));
        main.add(null, (BValue)this.edeFileOrdFE);
        main.add(null, (BValue)new BLabel(LBL_STATETXT));
        main.add(null, (BValue)this.stateTextsFileOrdFE);
        main.add(null, (BValue)new BLabel(LBL_DELIMITER));
        main.add(null, (BValue)this.delimiterFE);
        this.linkTo((BComponent)this.edeFileOrdFE, (Slot)BOrdFE.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.stateTextsFileOrdFE, (Slot)BOrdFE.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.delimiterFE, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.configNameFE, (Slot)BTextField.textModified, (Slot)setModified);
        this.setContent((BWidget)main);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BEdeConfig config = (BEdeConfig)value;
        BOrd stateTextsPath = config.getStateTextsPath();
        BOrd edePath = config.getEdePath();
        String delimiter = config.getDelimiter();
        String configName = config.getConfigName();
        this.stateTextsFileOrdFE.loadValue((BObject)stateTextsPath, (Context)TARGET_FACETS);
        this.edeFileOrdFE.loadValue((BObject)edePath, (Context)TARGET_FACETS);
        this.delimiterFE.setText(delimiter);
        this.configNameFE.setText(configName);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        BEdeConfig config = (BEdeConfig)value;
        BOrd stateTextsOrd = (BOrd)this.stateTextsFileOrdFE.saveValue();
        BOrd edeOrd = (BOrd)this.edeFileOrdFE.saveValue();
        String delimiter = this.delimiterFE.getText();
        String configName = this.configNameFE.getText();
        if (configName.equals("") || configName == null) {
            configName = this.makeDefaultName(edeOrd);
        }
        config.setStateTextsPath(stateTextsOrd);
        config.setEdePath(edeOrd);
        config.setDelimiter(delimiter);
        config.setConfigName(configName);
        return config;
    }

    protected void doSetReadonly(boolean readonly) {
        this.configNameFE.setEnabled(!readonly);
        this.stateTextsFileOrdFE.setEnabled(!readonly);
        this.edeFileOrdFE.setEnabled(!readonly);
        this.delimiterFE.setEnabled(!readonly);
    }

    private String makeDefaultName(BOrd edeOrd) {
        if (null == edeOrd || edeOrd == BOrd.DEFAULT) {
            return DEF_CONFIG_NAME;
        }
        try {
            BIFile file = (BIFile)edeOrd.get();
            String fileName = file.getFileName();
            return fileName;
        }
        catch (Exception e) {
            return DEF_CONFIG_NAME;
        }
    }
}

