/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.wb;

import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.bacnetEde.BEdeReader;
import com.tridium.bacnetEde.jobs.BDeviceDiscoveryJob;
import com.tridium.bacnetEde.jobs.BHistoryImportDiscoveryJob;
import com.tridium.bacnetEde.jobs.BPointDiscoveryJob;
import com.tridium.workbench.util.BWbJobService;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.tool.BWbService;

@NiagaraType
@NiagaraProperty(name="storeTime", type="BRelTime", defaultValue="BRelTime.makeMinutes(30)")
@NiagaraActions(value={@NiagaraAction(name="cleanup"), @NiagaraAction(name="forceClear")})
public class BWbEdeService
extends BWbService {
    @Generated
    public static final Property storeTime = BWbEdeService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    @Generated
    public static final Action cleanup = BWbEdeService.newAction((int)0, null);
    @Generated
    public static final Action forceClear = BWbEdeService.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWbEdeService.class);
    private static final BIcon icon = BIcon.make((String)"module://bacnetEDE/res/EDE.png");
    private Hashtable<BOrd, BEdeReader> store = new Hashtable();

    @Generated
    public BRelTime getStoreTime() {
        return (BRelTime)this.get(storeTime);
    }

    @Generated
    public void setStoreTime(BRelTime v) {
        this.set(storeTime, (BValue)v, null);
    }

    @Generated
    public void cleanup() {
        this.invoke(cleanup, null, null);
    }

    @Generated
    public void forceClear() {
        this.invoke(forceClear, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        Clock.schedule((BComponent)this, (BRelTime)this.getStoreTime(), (Action)cleanup, null);
    }

    public void stopped() throws Exception {
        this.store.clear();
    }

    public BEdeReader getReader(BEdeConfig readerId) {
        BOrd edePath = readerId.getEdePath();
        BEdeReader reader = this.store.get(edePath);
        if (null == reader) {
            reader = new BEdeReader(readerId);
            this.store.put(edePath, reader);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanup() {
        try {
            BRelTime expirationTime = this.getStoreTime();
            LinkedList<BOrd> toRemove = new LinkedList<BOrd>();
            BAbsTime now = BAbsTime.now();
            for (BOrd keyPath : this.store.keySet()) {
                BEdeReader reader = this.store.get(keyPath);
                BAbsTime timeLastUsed = reader.getTimeLastUsed();
                BRelTime lapsedTime = now.delta(timeLastUsed);
                if (lapsedTime.getMillis() <= expirationTime.getMillis()) continue;
                reader.close();
                toRemove.add(keyPath);
            }
            for (BOrd keyPath : toRemove) {
                this.store.remove(keyPath);
            }
        }
        finally {
            Clock.schedule((BComponent)this, (BRelTime)this.getStoreTime(), (Action)cleanup, null);
        }
    }

    public void doForceClear() {
        for (BEdeReader reader : this.store.values()) {
            reader.close();
        }
        this.store.clear();
    }

    public BOrd submitDeviceDiscovery(BEdeConfig config, BBacnetNetwork network, Context cx) {
        BWbJobService service = BWbEdeService.getJobService();
        BDeviceDiscoveryJob job = new BDeviceDiscoveryJob(network, config);
        BOrd jobOrd = service.submit((BJob)job, cx);
        return jobOrd;
    }

    public BOrd submitPointDiscovery(BEdeConfig config, BBacnetDevice device, Context cx) {
        BWbJobService service = BWbEdeService.getJobService();
        device.lease();
        BBacnetConfigDeviceExt deviceConfig = device.getConfig();
        deviceConfig.lease();
        BBacnetDeviceObject deviceObject = deviceConfig.getDeviceObject();
        deviceObject.lease();
        int instance = deviceObject.getObjectId().getInstanceNumber();
        if (instance == config.getDeviceObjInstance()) {
            BPointDiscoveryJob job = new BPointDiscoveryJob(config, device);
            BOrd jobOrd = service.submit((BJob)job, cx);
            return jobOrd;
        }
        throw new BajaRuntimeException("No device found with instance ID: " + config.getDeviceObjInstance());
    }

    public BOrd submitHistoryImportDiscovery(BEdeConfig config, BBacnetDevice device, Context cx) {
        BWbJobService jobService = BWbEdeService.getJobService();
        device.lease();
        BBacnetConfigDeviceExt deviceConfig = device.getConfig();
        deviceConfig.lease();
        BBacnetDeviceObject deviceObject = deviceConfig.getDeviceObject();
        deviceObject.lease();
        int instance = deviceObject.getObjectId().getInstanceNumber();
        if (instance == config.getDeviceObjInstance()) {
            BHistoryImportDiscoveryJob job = new BHistoryImportDiscoveryJob(config, instance);
            BOrd jobOrd = jobService.submit((BJob)job, cx);
            return jobOrd;
        }
        throw new BajaRuntimeException("No device found with instance ID: " + config.getDeviceObjInstance());
    }

    public static BWbEdeService getService() {
        return (BWbEdeService)BOrd.make((String)"tool:bacnetEDE:WbEdeService|slot:/").get();
    }

    private static BWbJobService getJobService() {
        BWbJobService service = (BWbJobService)BOrd.make((String)"tool:workbench:WbJobService|slot:/").get();
        return service;
    }

    public void changed(Property prop, Context cx) {
        BEdeConfig readerId;
        BOrd edePath;
        BEdeReader reader;
        BValue bValue = this.get(prop);
        if (bValue.getType().is(BEdeConfig.TYPE) && null != (reader = this.store.get(edePath = (readerId = (BEdeConfig)bValue).getEdePath())) && null != edePath && edePath != BOrd.NULL) {
            this.store.remove((Object)reader);
            reader = new BEdeReader(readerId);
            this.store.put(edePath, reader);
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

