/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import javax.baja.gx.BColor;

public class ColorUtil {
    public static double[] toHsb(BColor c) {
        double r = (float)c.getRed() / 255.0f;
        double g = (float)c.getGreen() / 255.0f;
        double b = (float)c.getBlue() / 255.0f;
        double max = Math.max(r, Math.max(g, b));
        double min = Math.min(r, Math.min(g, b));
        double h = 0.0;
        double s = 0.0;
        double v = max;
        s = max != 0.0 ? (max - min) / max : 0.0;
        if (s == 0.0) {
            h = 0.0;
        } else {
            double delta = max - min;
            if (r == max) {
                h = (g - b) / delta;
            } else if (g == max) {
                h = 2.0 + (b - r) / delta;
            } else if (b == max) {
                h = 4.0 + (r - g) / delta;
            }
            h *= 60.0;
            if (h < 0.0) {
                h += 360.0;
            }
        }
        return new double[]{h, s, v};
    }

    public static BColor toRgb(double[] hsb) {
        double h = hsb[0];
        double s = hsb[1];
        double v = hsb[2];
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (s == 0.0) {
            r = v;
            g = v;
            b = v;
        } else {
            if (h == 360.0) {
                h = 0.0;
            }
            int i = (int)Math.floor(h /= 60.0);
            double f = h - (double)i;
            double p = v * (1.0 - s);
            double q = v * (1.0 - s * f);
            double t = v * (1.0 - s * (1.0 - f));
            switch (i) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                case 5: {
                    r = v;
                    g = p;
                    b = q;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid value: " + i);
                }
            }
        }
        int ir = (int)(r * 255.0);
        int ig = (int)(g * 255.0);
        int ib = (int)(b * 255.0);
        return BColor.make(ir, ig, ib);
    }
}

