/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;

public class PointMap {
    private int searchRadius;
    private Map<PointKey, Map<PointKey, Object>> xTree;

    public PointMap(int searchRadius) {
        this.searchRadius = searchRadius;
        this.xTree = new TreeMap<PointKey, Map<PointKey, Object>>();
    }

    public Object put(double x, double y, Object value) {
        PointKey xKey = new PointKey((int)x, this.searchRadius);
        PointKey yKey = new PointKey((int)y, this.searchRadius);
        Map<PointKey, Object> yTree = this.xTree.get(xKey);
        if (yTree == null) {
            yTree = new TreeMap<PointKey, Object>();
            this.xTree.put(xKey, yTree);
        }
        return yTree.put(yKey, value);
    }

    public Object get(double x, double y) {
        PointKey xKey = new PointKey((int)x, this.searchRadius);
        PointKey yKey = new PointKey((int)y, this.searchRadius);
        Map<PointKey, Object> yTree = this.xTree.get(xKey);
        if (yTree == null) {
            return null;
        }
        return yTree.get(yKey);
    }

    public IPoint[] getKeys() {
        ArrayList<Point> keys = new ArrayList<Point>();
        for (PointKey xKey : this.xTree.keySet()) {
            Map<PointKey, Object> yTree = this.xTree.get(xKey);
            for (PointKey yKey : yTree.keySet()) {
                keys.add(new Point(xKey.val, yKey.val));
            }
        }
        return keys.toArray(new Point[0]);
    }

    public Object[] getValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (PointKey xKey : this.xTree.keySet()) {
            Map<PointKey, Object> yTree = this.xTree.get(xKey);
            for (PointKey yKey : yTree.keySet()) {
                values.add(yTree.get(yKey));
            }
        }
        return values.toArray(new Object[0]);
    }

    private class PointKey
    implements Comparable<PointKey> {
        int val;
        int fudgeFactor;

        private PointKey(int val, int fudgeFactor) {
            this.val = val;
            this.fudgeFactor = fudgeFactor;
        }

        @Override
        public int compareTo(PointKey o) {
            PointKey treeKey = o;
            if (Math.abs(this.val - treeKey.val) <= this.fudgeFactor) {
                return 0;
            }
            return this.val - treeKey.val;
        }

        public boolean equals(Object obj) {
            return this.compareTo((PointKey)obj) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.val, this.fudgeFactor);
        }
    }
}

