/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import com.tridium.gx.util.ImageUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BImage
extends BSimple {
    public static final BImage NULL;
    public static final BImage DEFAULT;
    public static final Type TYPE;
    private BOrdList ordList;
    private boolean loadLocal;
    private BOrdList absOrdList;
    private ImagePeer peer;
    private Object awtSupport;
    private BImage disabled;
    private BImage highlighted;

    public static BImage make(BIcon icon) {
        if (icon == null) {
            return NULL;
        }
        BImage image = (BImage)((Object)icon.fw(203));
        if (image == null) {
            image = BImage.make(icon.getOrdList());
            icon.fw(204, (Object)image, null, null, null);
        }
        return image;
    }

    public static BImage make(BOrdList ordList) {
        return new BImage(ordList);
    }

    public static BImage make(BOrd ord) {
        return BImage.make(BOrdList.make((BOrd)ord));
    }

    public static BImage make(String ordList) {
        if (ordList.equals("null")) {
            return NULL;
        }
        if (ordList.equals("new")) {
            return new BImage(BOrdList.NULL);
        }
        return BImage.make(BOrdList.make((String)ordList));
    }

    public static BImage make(byte[] buf) {
        return GxEnv.get().makeImage(buf);
    }

    public static BImage make(double width, double height) {
        return GxEnv.get().makeImage(width, height);
    }

    private BImage(BOrdList ordList) {
        this.ordList = ordList;
        this.absOrdList = ordList;
        this.loadLocal = ordList.toString().startsWith("module:");
    }

    public BOrdList getOrdList() {
        return this.ordList;
    }

    public BOrdList getAbsoluteOrdList() {
        return this.absOrdList;
    }

    public void setBaseOrd(BOrd baseOrd) {
        if (baseOrd == null || this.loadLocal) {
            this.absOrdList = this.ordList;
        } else {
            BOrd[] ords = ImageUtil.fixupImageOrds(baseOrd, this.ordList, this.absOrdList);
            for (int i = 0; i < ords.length; ++i) {
                if (ords[i].isNull()) continue;
                ords[i] = BOrd.make((BOrd)baseOrd, (BOrd)ords[i]).normalize();
            }
            this.absOrdList = BOrdList.make((BOrd[])ords);
        }
        this.awtSupport = null;
        this.peer = null;
    }

    public boolean isLoaded() {
        return this.peer().isLoaded();
    }

    public boolean isDimensionsLoaded() {
        return this.peer().isDimensionsLoaded();
    }

    public BImage syncDimensions() {
        this.peer().syncDimensions();
        return this;
    }

    public BImage sync() {
        this.peer().sync();
        return this;
    }

    public boolean animate() {
        return this.peer().animate();
    }

    public Graphics getGraphics() {
        return this.peer().getGraphics();
    }

    public double getWidth() {
        return this.peer().getWidth();
    }

    public double getHeight() {
        return this.peer().getHeight();
    }

    public int[] getPixels() {
        return this.peer().getPixels();
    }

    public void setPixels(int[] pixels) {
        this.peer().setPixels(pixels);
    }

    public void dispose() {
        if (this.awtSupport instanceof ImagePeer) {
            ((ImagePeer)this.awtSupport).dispose();
        }
        if (this.peer != null) {
            this.peer.dispose();
        }
        this.awtSupport = null;
        this.peer = null;
    }

    public BImage getDisabledImage() {
        if (this.disabled == null) {
            this.disabled = GxEnv.get().makeDisabled(this);
        }
        return this.disabled;
    }

    public BImage getHighlightedImage() {
        if (this.highlighted == null) {
            this.highlighted = GxEnv.get().makeHighlighted(this);
        }
        return this.highlighted;
    }

    public BImage transform(BTransform transform) {
        double th;
        double w = this.getWidth();
        double h = this.getHeight();
        Point c0 = transform.transform(new Point(0.0, 0.0), null);
        Point c1 = transform.transform(new Point(w, 0.0), null);
        Point c2 = transform.transform(new Point(w, h), null);
        Point c3 = transform.transform(new Point(0.0, h), null);
        double minw = Math.min(c0.x, Math.min(c1.x, Math.min(c2.x, c3.x)));
        double minh = Math.min(c0.y, Math.min(c1.y, Math.min(c2.y, c3.y)));
        double maxw = Math.max(c0.x, Math.max(c1.x, Math.max(c2.x, c3.x)));
        double maxh = Math.max(c0.y, Math.max(c1.y, Math.max(c2.y, c3.y)));
        double tx = -minw;
        double ty = -minh;
        double tw = maxw - minw;
        if (tw < 1.0) {
            tw = 1.0;
        }
        if ((th = maxh - minh) < 1.0) {
            th = 1.0;
        }
        BImage buf = BImage.make(tw, th);
        Graphics g = buf.getGraphics();
        g.translate(tx, ty);
        g.transform(transform);
        g.drawImage(this, 0.0, 0.0);
        return buf;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        return this.ordList.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BImage) {
            BImage x = (BImage)((Object)obj);
            if (this.ordList.isNull() || x.ordList.isNull()) {
                return false;
            }
            return this.ordList.equals((Object)x.ordList);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() {
        if (this.isNull()) {
            return "null";
        }
        return this.ordList.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return BImage.make(s);
    }

    public Type getType() {
        return TYPE;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
            case 205: {
                this.setBaseOrd((BOrd)a);
                return null;
            }
            case 206: {
                return this.peer();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private ImagePeer peer() {
        if (this.peer == null) {
            this.peer = GxEnv.get().makeImagePeer(this);
        }
        return this.peer;
    }

    static {
        DEFAULT = NULL = BImage.make(BOrdList.NULL);
        TYPE = Sys.loadType(BImage.class);
    }
}

