/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.IOException;
import javax.baja.gx.BGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.PathGeom;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BPathGeom
extends BGeom
implements IPathGeom {
    public static final BPathGeom DEFAULT;
    public static final BPathGeom NULL;
    public static final Type TYPE;
    IPathGeom.Segment[] segments;
    String string;

    public static BPathGeom make(IPathGeom.Segment[] segments) {
        return new BPathGeom((IPathGeom.Segment[])segments.clone());
    }

    public static BPathGeom make(IPathGeom g) {
        if (g instanceof BPathGeom) {
            return (BPathGeom)g;
        }
        return BPathGeom.make(g.segments());
    }

    public static BPathGeom make(String s) {
        Parser parser = new Parser(s, true);
        BPathGeom x = parser.parsePath();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BPathGeom(IPathGeom.Segment[] segments) {
        this.segments = segments;
    }

    @Override
    public int getGeomCase() {
        return 5;
    }

    @Override
    public IPathGeom.Segment[] segments() {
        return (IPathGeom.Segment[])this.segments.clone();
    }

    @Override
    public IPathGeom.Segment segment(int index) {
        return this.segments[index];
    }

    @Override
    public int size() {
        return this.segments.length;
    }

    public boolean isNull() {
        return this.segments.length == 0;
    }

    public int hashCode() {
        int len = this.segments != null ? this.segments.length : 0;
        int hash = 23 + len;
        for (int i = 0; i < len; ++i) {
            String segStr = this.segments[i] != null ? this.segments[i].toString() : null;
            hash = hash * 37 + (segStr != null ? segStr.hashCode() : 0);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BPathGeom) {
            BPathGeom o = (BPathGeom)obj;
            if (this.segments.length != o.segments.length) {
                return false;
            }
            return PathGeom.equals(this.segments, o.segments, this.segments.length);
        }
        return false;
    }

    public String encodeToString() throws IOException {
        if (this.string == null) {
            this.string = PathGeom.toString(this.segments, this.segments.length);
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        return BPathGeom.make(s);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        NULL = DEFAULT = new BPathGeom(new IPathGeom.Segment[0]);
        TYPE = Sys.loadType(BPathGeom.class);
    }
}

