/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import javax.baja.gx.IGeom;
import javax.baja.sys.BDouble;

public interface IPathGeom
extends IGeom {
    public Segment[] segments();

    public Segment segment(int var1);

    public int size();

    public static class ArcTo
    extends Segment {
        double rx;
        double ry;
        double xAxisRotation;
        double x;
        double y;
        boolean largeArcFlag;
        boolean sweepFlag;

        public ArcTo(boolean absolute, double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
            super(absolute);
            this.rx = rx;
            this.ry = ry;
            this.xAxisRotation = xAxisRotation;
            this.largeArcFlag = largeArcFlag;
            this.sweepFlag = sweepFlag;
            this.x = x;
            this.y = y;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'A' : 'a';
        }

        public double getRadiusX() {
            return this.rx;
        }

        public double getRadiusY() {
            return this.ry;
        }

        public double getXAxisRotation() {
            return this.xAxisRotation;
        }

        public boolean getLargeArcFlag() {
            return this.largeArcFlag;
        }

        public boolean getSweepFlag() {
            return this.sweepFlag;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        boolean doEquals(Segment seg) {
            ArcTo s = (ArcTo)seg;
            return this.rx == s.rx && this.ry == s.ry && this.xAxisRotation == s.xAxisRotation && this.largeArcFlag == s.largeArcFlag && this.sweepFlag == s.sweepFlag && this.x == s.x && this.y == s.y;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.rx)).append(',').append(BDouble.encode((double)this.ry)).append(' ').append(BDouble.encode((double)this.xAxisRotation)).append(' ').append(this.largeArcFlag ? (char)'1' : '0').append(',').append(this.sweepFlag ? (char)'1' : '0').append(' ').append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }
    }

    public static class SmoothQuadTo
    extends Segment {
        double x;
        double y;

        public SmoothQuadTo(boolean absolute, double x, double y) {
            super(absolute);
            this.x = x;
            this.y = y;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'T' : 't';
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        boolean doEquals(Segment seg) {
            SmoothQuadTo s = (SmoothQuadTo)seg;
            return this.x == s.x && this.y == s.y;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }
    }

    public static class QuadTo
    extends Segment {
        double x1;
        double y1;
        double x;
        double y;

        public QuadTo(boolean absolute, double x1, double y1, double x, double y) {
            super(absolute);
            this.x1 = x1;
            this.y1 = y1;
            this.x = x;
            this.y = y;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'Q' : 'q';
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        boolean doEquals(Segment seg) {
            QuadTo s = (QuadTo)seg;
            return this.x1 == s.x1 && this.y1 == s.y1 && this.x == s.x && this.y == s.y;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.x1)).append(',').append(BDouble.encode((double)this.y1)).append(' ').append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }
    }

    public static class SmoothCurveTo
    extends Segment {
        double x2;
        double y2;
        double x;
        double y;

        public SmoothCurveTo(boolean absolute, double x2, double y2, double x, double y) {
            super(absolute);
            this.x2 = x2;
            this.y2 = y2;
            this.x = x;
            this.y = y;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'S' : 's';
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        boolean doEquals(Segment seg) {
            SmoothCurveTo s = (SmoothCurveTo)seg;
            return this.x2 == s.x2 && this.y2 == s.y2 && this.x == s.x && this.y == s.y;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.x2)).append(',').append(BDouble.encode((double)this.y2)).append(' ').append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }
    }

    public static class CurveTo
    extends Segment {
        double x1;
        double y1;
        double x2;
        double y2;
        double x;
        double y;

        public CurveTo(boolean absolute, double x1, double y1, double x2, double y2, double x, double y) {
            super(absolute);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.x = x;
            this.y = y;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'C' : 'c';
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        boolean doEquals(Segment seg) {
            CurveTo s = (CurveTo)seg;
            return this.x1 == s.x1 && this.y1 == s.y1 && this.x2 == s.x2 && this.y2 == s.y2 && this.x == s.x && this.y == s.y;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.x1)).append(',').append(BDouble.encode((double)this.y1)).append(' ').append(BDouble.encode((double)this.x2)).append(',').append(BDouble.encode((double)this.y2)).append(' ').append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }
    }

    public static class VLineTo
    extends Segment {
        double y;

        public VLineTo(boolean absolute, double y) {
            super(absolute);
            this.y = y;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'V' : 'v';
        }

        public double getY() {
            return this.y;
        }

        @Override
        boolean doEquals(Segment seg) {
            VLineTo s = (VLineTo)seg;
            return this.y == s.y;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.y));
        }
    }

    public static class HLineTo
    extends Segment {
        double x;

        public HLineTo(boolean absolute, double x) {
            super(absolute);
            this.x = x;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'H' : 'h';
        }

        public double getX() {
            return this.x;
        }

        @Override
        boolean doEquals(Segment seg) {
            HLineTo s = (HLineTo)seg;
            return this.x == s.x;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.x));
        }
    }

    public static class LineTo
    extends Segment {
        double x;
        double y;

        public LineTo(boolean absolute, double x, double y) {
            super(absolute);
            this.x = x;
            this.y = y;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'L' : 'l';
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        boolean doEquals(Segment seg) {
            LineTo s = (LineTo)seg;
            return this.x == s.x && this.y == s.y;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y));
        }
    }

    public static class MoveTo
    extends Segment {
        double x;
        double y;

        public MoveTo(boolean absolute, double x, double y) {
            super(absolute);
            this.x = x;
            this.y = y;
        }

        @Override
        public char getCommand() {
            return this.absolute ? (char)'M' : 'm';
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        boolean doEquals(Segment seg) {
            MoveTo s = (MoveTo)seg;
            return this.x == s.x && this.y == s.y;
        }

        @Override
        void toString(StringBuffer s) {
            s.append(BDouble.encode((double)this.x));
            s.append(',');
            s.append(BDouble.encode((double)this.y));
        }
    }

    public static class ClosePath
    extends Segment {
        public ClosePath() {
            super(false);
        }

        @Override
        public char getCommand() {
            return 'Z';
        }

        @Override
        boolean doEquals(Segment seg) {
            return true;
        }

        @Override
        void toString(StringBuffer s) {
        }
    }

    public static abstract class Segment {
        boolean absolute;

        Segment(boolean absolute) {
            this.absolute = absolute;
        }

        public abstract char getCommand();

        public final boolean isAbsolute() {
            return this.absolute;
        }

        public final boolean isRelative() {
            return !this.absolute;
        }

        public final boolean equals(Object obj) {
            if (this.getClass() == obj.getClass()) {
                Segment seg = (Segment)obj;
                if (this.absolute != seg.absolute) {
                    return false;
                }
                return this.doEquals(seg);
            }
            return false;
        }

        public final String toString() {
            StringBuffer s = new StringBuffer();
            s.append(this.getCommand());
            this.toString(s);
            return s.toString();
        }

        abstract boolean doEquals(Segment var1);

        abstract void toString(StringBuffer var1);
    }
}

