/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.PartSpec;
import com.tridium.install.part.BPart;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DependencyMap {
    private Map<PartSpec, Map<PartSpec, BDependency>> map = new HashMap<PartSpec, Map<PartSpec, BDependency>>();

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public void merge(DependencyMap toMerge) {
        if (toMerge == null) {
            return;
        }
        for (Map<PartSpec, BDependency> items : toMerge.map.values()) {
            for (PartSpec key : items.keySet()) {
                this.addDependency(key, items.get(key));
            }
        }
    }

    public boolean removeDependency(PartSpec depOwner, BDependency dep) {
        Map<PartSpec, BDependency> depMap = this.map.get(dep.getPartSpec());
        if (depMap != null) {
            BDependency removed = depMap.remove(depOwner);
            if (depMap.size() == 0) {
                this.map.remove(dep.getPartSpec());
            }
            return removed != null;
        }
        return false;
    }

    public BDependency getStrictestDependencyOn(BPart part) {
        return this.getStrictestDependencyOn(part.getPartSpec());
    }

    public BDependency getStrictestDependencyOn(PartSpec partSpec) {
        BDependency result = null;
        Map<PartSpec, BDependency> deps = this.getDependenciesOn(partSpec);
        for (BDependency dep : deps.values()) {
            if (result != null && !dep.supersedes(result)) continue;
            result = dep;
        }
        return result;
    }

    public Set<PartSpec> getPartSpecs() {
        return this.map.keySet();
    }

    public Map<PartSpec, BDependency> getDependenciesOn(BPart part) {
        return this.getDependenciesOn(part.getPartSpec());
    }

    public Map<PartSpec, BDependency> getDependenciesOn(PartSpec spec) {
        return this.map.get(spec);
    }

    public boolean addDependencies(Map<PartSpec, BDependency> depMap) {
        if (depMap == null) {
            return false;
        }
        boolean anyUpdates = false;
        for (PartSpec key : depMap.keySet()) {
            anyUpdates = this.addDependency(key, depMap.get(key)) || anyUpdates;
        }
        return anyUpdates;
    }

    public boolean addDependency(PartSpec ownerSpec, BDependency dep) {
        Map<PartSpec, BDependency> depMap = this.map.get(dep.getPartSpec());
        if (depMap == null) {
            depMap = new HashMap<PartSpec, BDependency>();
            depMap.put(ownerSpec, dep);
            this.map.put(dep.getPartSpec(), depMap);
            return true;
        }
        BDependency existingDep = depMap.get(ownerSpec);
        if (existingDep == null) {
            return depMap.put(ownerSpec, dep) == null;
        }
        if (dep.supersedes(existingDep)) {
            return depMap.put(ownerSpec, dep) == null;
        }
        return false;
    }
}

