/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.install.InstallableFilter;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityConstants;
import com.tridium.nre.security.SecurityInitializer;
import java.security.AccessController;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

public class SignedDistFilter
implements InstallableFilter {
    private static Logger log = Logger.getLogger("platform.install");
    private static final HashMap<String, Boolean> verificationCache = new HashMap();

    @Override
    public boolean acceptInstallable(BInstallable inst) {
        BIFile file;
        boolean distVerified;
        long millisStart;
        block26: {
            if (!SecurityConstants.canCheckTpk()) {
                return true;
            }
            if (!(inst instanceof BDistribution)) {
                return true;
            }
            boolean checkSignature = false;
            SlotCursor p = inst.getParts().getProperties();
            while (p.next()) {
                BPart part = (BPart)p.get();
                Type type = part.getType();
                if (!type.is(BOsPart.TYPE) && !type.is(BNrePart.TYPE) && !type.is(BVmPart.TYPE)) continue;
                checkSignature = true;
                break;
            }
            if (!checkSignature) {
                return true;
            }
            millisStart = System.currentTimeMillis();
            distVerified = false;
            file = AccessController.doPrivileged(() -> (BIFile)inst.getInstallableFileOrd().get());
            Boolean cacheResult = verificationCache.get(file.getFilePath().toString());
            if (cacheResult != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.fine("Returning cached verification result '" + cacheResult + "' for installable '" + inst.getInstallableName() + "'");
                }
                return cacheResult;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Verifying signature of installable '" + inst.getInstallableName() + "'...");
            }
            try {
                CoreCryptoManager mgr = AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
                byte[] buffer = new byte[32768];
                try (JarInputStream in = new JarInputStream(AccessController.doPrivileged(() -> ((BIFile)file).getInputStream()));){
                    JarEntry entry;
                    while ((entry = in.getNextJarEntry()) != null) {
                        while (in.read(buffer) > 0) {
                        }
                        if (entry.isDirectory() || entry.getName().startsWith("META-INF")) continue;
                        mgr.validateCertChain(entry, true);
                    }
                }
                distVerified = true;
            }
            catch (Exception e) {
                log.severe("Failed to verify dist signature for '" + inst.getInstallableName() + "': " + e);
                if (!log.isLoggable(Level.FINE)) break block26;
                e.printStackTrace();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Signature verification complete (distVerified = " + distVerified + "), operation took " + (System.currentTimeMillis() - millisStart) + "ms");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Caching verification result '" + distVerified + "' with path '" + file.getFilePath().toString() + "'");
        }
        verificationCache.put(file.getFilePath().toString(), distVerified);
        return distVerified;
    }

    public static void resetVerificationCache() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Clearing distribution file verification cache...");
        }
        verificationCache.clear();
    }
}

