/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.InstallableFilter;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.util.LicenseMode;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.util.Version;

public class SubscriptionVersionDistFilter
implements InstallableFilter {
    private LicenseMode licenseMode = LicenseMode.PERPETUAL;
    private final Version reqSubscriptionVersion;

    public SubscriptionVersionDistFilter(Version reqSubscriptionVersion) {
        this.reqSubscriptionVersion = reqSubscriptionVersion;
    }

    public void setFilterLicenseMode(LicenseMode mode) {
        this.licenseMode = mode;
    }

    @Override
    public boolean acceptInstallable(BInstallable inst) {
        if (this.licenseMode == LicenseMode.SUBSCRIPTION && inst instanceof BDistribution && this.shouldCheckDist((BDistribution)inst)) {
            return inst.getVersion().getVendorVersion().compareTo(this.reqSubscriptionVersion) >= 0;
        }
        return true;
    }

    private boolean shouldCheckDist(BDistribution dist) {
        SlotCursor p = dist.getParts().getProperties();
        while (p.next()) {
            BPart part = (BPart)p.get();
            Type type = part.getType();
            if (!type.is(BNrePart.TYPE) || !part.getPartName().startsWith("nre-core")) continue;
            return true;
        }
        return false;
    }
}

