/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import java.util.Collection;
import java.util.Iterator;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;

public class CursorUtil {
    public static <E> IterableCursor<E> cursor(Collection<E> c) {
        return CursorUtil.cursor(c, null);
    }

    public static <E> IterableCursor<E> cursor(Collection<E> c, Context cx) {
        return CursorUtil.cursor(c.iterator(), cx);
    }

    public static <E> IterableCursor<E> cursor(Iterator<E> i) {
        return CursorUtil.cursor(i, null);
    }

    public static <E> IterableCursor<E> cursor(Iterator<E> i, Context cx) {
        return new IteratorCursor<E>(i, cx);
    }

    public static <E> IterableCursor<E> cursor(E[] array) {
        return CursorUtil.cursor(array, null);
    }

    public static <E> IterableCursor<E> cursor(E[] array, Context cx) {
        return CursorUtil.cursor(new Array((Object[])array), cx);
    }

    public static <E> IterableCursor<E> cursor(Array<E> array) {
        return CursorUtil.cursor(array, null);
    }

    public static <E> IterableCursor<E> cursor(Array<E> array, Context cx) {
        return new ArrayCursor<E>(array, cx);
    }

    public static class IteratorCursor<E>
    implements IterableCursor<E> {
        private Iterator<E> i;
        private E current = null;
        private Context cx;

        public IteratorCursor(Iterator<E> i, Context cx) {
            this.i = i;
            this.cx = cx;
        }

        public Context getContext() {
            return this.cx;
        }

        public boolean next() {
            if (this.i.hasNext()) {
                this.current = this.i.next();
                return true;
            }
            return false;
        }

        public boolean nextComponent() {
            return this.next(BComponent.class);
        }

        public boolean next(Class<?> cls) {
            while (this.next()) {
                if (!cls.isAssignableFrom(this.current.getClass())) continue;
                return true;
            }
            return false;
        }

        public E get() {
            return this.current;
        }

        public void close() {
            this.i = null;
            this.current = null;
        }
    }

    public static class ArrayCursor<E>
    implements IterableCursor<E> {
        private int index = -1;
        private Array<E> a;
        private Context cx;

        public ArrayCursor(Array<E> a, Context cx) {
            this.a = a;
            this.cx = cx;
        }

        public Context getContext() {
            return this.cx;
        }

        public boolean next() {
            if (this.index >= this.a.size() - 1) {
                return false;
            }
            ++this.index;
            return true;
        }

        public boolean nextComponent() {
            return this.next(BComponent.class);
        }

        public boolean next(Class<?> cls) {
            while (this.next()) {
                if (!cls.isAssignableFrom(this.get().getClass())) continue;
                return true;
            }
            return false;
        }

        public E get() {
            if (this.index < 0 || this.index >= this.a.size()) {
                return null;
            }
            return (E)this.a.get(this.index);
        }

        public void close() {
            this.index = this.a.size();
        }
    }
}

