/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BPart;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
public class BBrandPart
extends BPart {
    @Generated
    public static final Type TYPE = Sys.loadType(BBrandPart.class);
    private static final BIcon icon = BPart.getPartTypeIcon(TYPE);
    public static final String NO_BRAND = "noBrand";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBrandPart() {
    }

    public BBrandPart(String pName, BInstallable pInstallable) {
        this.setPartName(pName);
        this.setInstallable(pInstallable);
    }

    @Override
    public boolean meets(BDependency depend) {
        return depend.getPartType().is(TYPE) && (this.isNull() || this.matchesName(depend.getPartName()));
    }

    public static BPart make(XElem elem) {
        return BBrandPart.make(elem, null);
    }

    public static BPart make(XElem elem, BInstallable installable) {
        if (elem == null) {
            return null;
        }
        if (elem.name().equals("brand")) {
            String brandId = elem.get("name", NO_BRAND);
            if (brandId.trim().length() == 0) {
                brandId = NO_BRAND;
            }
            return new BBrandPart(brandId, installable);
        }
        return null;
    }

    @Override
    public XElem getXml() {
        XElem result = new XElem("brand");
        result.setAttr("name", this.getPartName());
        return result;
    }

    public String toString(Context context) {
        return "Brand Part: " + this.getPartName();
    }

    public boolean isNull() {
        return this.getPartName().equals(NO_BRAND) || this.getPartName().equals("disabled") || this.getPartName().equals("nullos");
    }

    public static BBrandPart makeNull() {
        return new BBrandPart(NO_BRAND, null);
    }

    public BIcon getIcon() {
        return icon;
    }
}

