/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.ClassCondenser;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BCodeSigner;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.ModuleManifest;
import com.tridium.install.part.BModuleStatus;
import com.tridium.install.part.BPart;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.registry.NModuleInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.FileUtil;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="moduleName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="status", type="BModuleStatus", defaultValue="BModuleStatus.ok", flags=1), @NiagaraProperty(name="buildDate", type="String", defaultValue="", flags=1), @NiagaraProperty(name="buildAbsTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="buildHost", type="String", defaultValue="", flags=1), @NiagaraProperty(name="archiveDate", type="String", defaultValue="", flags=1), @NiagaraProperty(name="archiveHost", type="String", defaultValue="", flags=1), @NiagaraProperty(name="archiveContent", type="BModuleContent", defaultValue="BModuleContent.doc", flags=1), @NiagaraProperty(name="runtimeProfileString", type="String", defaultValue="", flags=1), @NiagaraProperty(name="manifestSchemaVersion", type="int", defaultValue="3", flags=1), @NiagaraProperty(name="preferredSymbol", type="String", defaultValue="", flags=1), @NiagaraProperty(name="fileSize", type="long", defaultValue="-1", flags=1), @NiagaraProperty(name="synthetic", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="exclusions", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="isNre", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="isInstallable", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="relatedModulePartNames", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="releaseDateString", type="String", defaultValue="", flags=1), @NiagaraProperty(name="codeSigners", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="signatureFailureCause", type="String", defaultValue="", flags=1), @NiagaraProperty(name="signersInitialized", type="boolean", defaultValue="false", flags=1)})
public class BModulePart
extends BPart {
    @Generated
    public static final Property moduleName = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property status = BModulePart.newProperty((int)1, (BValue)BModuleStatus.ok, null);
    @Generated
    public static final Property buildDate = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property buildAbsTime = BModulePart.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property buildHost = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property archiveDate = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property archiveHost = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property archiveContent = BModulePart.newProperty((int)1, (BValue)BModuleContent.doc, null);
    @Generated
    public static final Property runtimeProfileString = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property manifestSchemaVersion = BModulePart.newProperty((int)1, (int)3, null);
    @Generated
    public static final Property preferredSymbol = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property fileSize = BModulePart.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property synthetic = BModulePart.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property exclusions = BModulePart.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Property isNre = BModulePart.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property isInstallable = BModulePart.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property relatedModulePartNames = BModulePart.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Property releaseDateString = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property codeSigners = BModulePart.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Property signatureFailureCause = BModulePart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property signersInitialized = BModulePart.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModulePart.class);
    private BIFile file = null;
    private boolean localInstance = false;
    private boolean summaryInitialized = false;
    private boolean dependsInitialized = false;
    private ModuleManifest manifest = null;
    private static final BIcon icon = BPart.getPartTypeIcon(TYPE);

    @Generated
    public String getModuleName() {
        return this.getString(moduleName);
    }

    @Generated
    public void setModuleName(String v) {
        this.setString(moduleName, v, null);
    }

    @Generated
    public BModuleStatus getStatus() {
        return (BModuleStatus)this.get(status);
    }

    @Generated
    public void setStatus(BModuleStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getBuildDate() {
        return this.getString(buildDate);
    }

    @Generated
    public void setBuildDate(String v) {
        this.setString(buildDate, v, null);
    }

    @Generated
    public BAbsTime getBuildAbsTime() {
        return (BAbsTime)this.get(buildAbsTime);
    }

    @Generated
    public void setBuildAbsTime(BAbsTime v) {
        this.set(buildAbsTime, (BValue)v, null);
    }

    @Generated
    public String getBuildHost() {
        return this.getString(buildHost);
    }

    @Generated
    public void setBuildHost(String v) {
        this.setString(buildHost, v, null);
    }

    @Generated
    public String getArchiveDate() {
        return this.getString(archiveDate);
    }

    @Generated
    public void setArchiveDate(String v) {
        this.setString(archiveDate, v, null);
    }

    @Generated
    public String getArchiveHost() {
        return this.getString(archiveHost);
    }

    @Generated
    public void setArchiveHost(String v) {
        this.setString(archiveHost, v, null);
    }

    @Generated
    public BModuleContent getArchiveContent() {
        return (BModuleContent)this.get(archiveContent);
    }

    @Generated
    public void setArchiveContent(BModuleContent v) {
        this.set(archiveContent, (BValue)v, null);
    }

    @Generated
    public String getRuntimeProfileString() {
        return this.getString(runtimeProfileString);
    }

    @Generated
    public void setRuntimeProfileString(String v) {
        this.setString(runtimeProfileString, v, null);
    }

    @Generated
    public int getManifestSchemaVersion() {
        return this.getInt(manifestSchemaVersion);
    }

    @Generated
    public void setManifestSchemaVersion(int v) {
        this.setInt(manifestSchemaVersion, v, null);
    }

    @Generated
    public String getPreferredSymbol() {
        return this.getString(preferredSymbol);
    }

    @Generated
    public void setPreferredSymbol(String v) {
        this.setString(preferredSymbol, v, null);
    }

    @Generated
    public long getFileSize() {
        return this.getLong(fileSize);
    }

    @Generated
    public void setFileSize(long v) {
        this.setLong(fileSize, v, null);
    }

    @Generated
    public boolean getSynthetic() {
        return this.getBoolean(synthetic);
    }

    @Generated
    public void setSynthetic(boolean v) {
        this.setBoolean(synthetic, v, null);
    }

    @Generated
    public BVector getExclusions() {
        return (BVector)this.get(exclusions);
    }

    @Generated
    public void setExclusions(BVector v) {
        this.set(exclusions, (BValue)v, null);
    }

    @Generated
    public boolean getIsNre() {
        return this.getBoolean(isNre);
    }

    @Generated
    public void setIsNre(boolean v) {
        this.setBoolean(isNre, v, null);
    }

    @Generated
    public boolean getIsInstallable() {
        return this.getBoolean(isInstallable);
    }

    @Generated
    public void setIsInstallable(boolean v) {
        this.setBoolean(isInstallable, v, null);
    }

    @Generated
    public BVector getRelatedModulePartNames() {
        return (BVector)this.get(relatedModulePartNames);
    }

    @Generated
    public void setRelatedModulePartNames(BVector v) {
        this.set(relatedModulePartNames, (BValue)v, null);
    }

    @Generated
    public String getReleaseDateString() {
        return this.getString(releaseDateString);
    }

    @Generated
    public void setReleaseDateString(String v) {
        this.setString(releaseDateString, v, null);
    }

    @Generated
    public BVector getCodeSigners() {
        return (BVector)this.get(codeSigners);
    }

    @Generated
    public void setCodeSigners(BVector v) {
        this.set(codeSigners, (BValue)v, null);
    }

    @Generated
    public String getSignatureFailureCause() {
        return this.getString(signatureFailureCause);
    }

    @Generated
    public void setSignatureFailureCause(String v) {
        this.setString(signatureFailureCause, v, null);
    }

    @Generated
    public boolean getSignersInitialized() {
        return this.getBoolean(signersInitialized);
    }

    @Generated
    public void setSignersInitialized(boolean v) {
        this.setBoolean(signersInitialized, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BModulePart() {
    }

    public BModulePart(BIFile pFile, NModuleInfo pModuleInfo, BInstallable pInstallable) {
        this.file = pFile;
        this.localInstance = true;
        this.setInstallable(pInstallable);
        this.setStatus(BModuleStatus.ok);
        this.setFileSize(pFile.getSize());
        this.setPartName(pModuleInfo.getModulePartName());
        this.setBuildAbsTime(BAbsTime.make((long)pModuleInfo.getBuildTime()));
        this.getVersion().setVendor(pModuleInfo.getVendor());
        this.getVersion().setVendorVersion(pModuleInfo.getVendorVersion());
        this.setDescription(pModuleInfo.getDescription());
        this.setRuntimeProfile(pModuleInfo.getRuntimeProfile());
        this.setManifestSchemaVersion(4);
        this.setSynthetic(pFile.getExtension().equals("sjar"));
        this.summaryInitialized = true;
    }

    public BModulePart(BIFile pFile, InputStream pManifestStream, BInstallable pInstallable) {
        this(pFile, pManifestStream, pInstallable, true);
    }

    public BModulePart(BIFile pFile, InputStream pManifestStream, BInstallable pInstallable, boolean pCloseStream) {
        this.file = pFile;
        this.localInstance = true;
        this.setInstallable(pInstallable);
        if (pManifestStream == null) {
            this.setStatus(BModuleStatus.nomanifest);
            if (pInstallable != null) {
                pInstallable.setIsValid(false);
            }
        } else {
            this.setStatus(BModuleStatus.ok);
        }
        this.setFileSize(pFile.getSize());
        if (pFile.getExtension().equals("jar")) {
            this.setPartName(pFile.getFileName().substring(0, pFile.getFileName().length() - 4));
        } else if (pFile.getExtension().equals("sjar")) {
            this.setPartName(pFile.getFileName().substring(0, pFile.getFileName().length() - 5));
            this.setSynthetic(true);
        }
        if (pManifestStream != null) {
            this.loadManifest(pManifestStream, pCloseStream);
        }
    }

    public static BModulePart make(BIFile file) {
        BModuleInstallable installable = BModuleInstallable.make(file, true);
        return installable == null ? null : installable.getModulePart();
    }

    public static BModulePart make(BIFile file, boolean flagMissingManifest) {
        BModuleInstallable installable = BModuleInstallable.make(file, flagMissingManifest);
        return installable == null ? null : installable.getModulePart();
    }

    public static BModulePart make(String partName, XElem manifestDom) {
        if (partName == null) {
            return null;
        }
        BModulePart result = new BModulePart();
        result.setPartName(partName);
        if (manifestDom == null) {
            result.setStatus(BModuleStatus.nomanifest);
        } else {
            result.loadManifest(manifestDom);
        }
        return result;
    }

    public static BModulePart make(BIFile file, BInstallable installable) {
        try {
            InputStream manifestStream = DaemonFileUtil.getZipStream(file, new FilePath("META-INF/module.xml"));
            if (manifestStream == null) {
                manifestStream = DaemonFileUtil.getZipStream(file, new FilePath("meta-inf/module.xml"));
            }
            if (manifestStream == null) {
                manifestStream = DaemonFileUtil.getZipStream(file, new FilePath("META-INF/module.xml"));
            }
            if (manifestStream == null) {
                return null;
            }
            return new BModulePart(file, manifestStream, installable);
        }
        catch (IOException ioe) {
            throw new LocalizableRuntimeException("platform", "ModulePart.exception.manifestRead", new Object[]{file.getFilePath()}, (Throwable)ioe);
        }
    }

    @Override
    public boolean meets(BDependency depend) {
        this.initSummary();
        return depend.getPartType().is(TYPE) && this.getVersion().meets(depend) && this.matchesName(depend.getPartName());
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public Optional<Long> getReleaseDate() {
        if (!this.dependsInitialized) {
            this.init();
        }
        if (this.getReleaseDateString().equals("")) {
            return Optional.empty();
        }
        return Optional.of(LicenseUtil.parseDate((String)this.getReleaseDateString(), (boolean)true));
    }

    private void setReleaseDate(Optional<Long> value) {
        if (value.isPresent()) {
            this.setReleaseDateString(LicenseUtil.formatDate((long)value.get()));
        } else {
            this.setReleaseDateString("");
        }
    }

    public RuntimeProfile getRuntimeProfile() {
        return RuntimeProfile.valueOf((String)this.getRuntimeProfileString(), null);
    }

    public void setRuntimeProfile(RuntimeProfile runtimeProfile) {
        this.setRuntimeProfileString(runtimeProfile == null ? "" : runtimeProfile.name());
    }

    @Override
    public BVector getDependencies() {
        if (!this.dependsInitialized) {
            this.init();
        }
        return super.getDependencies();
    }

    public void initCodeSigners(JarSignatureRegistry registry) {
        BIFileStore store;
        if (!this.getSignersInitialized() && this.localInstance && (store = ((BIFile)this.getInstallable().getInstallableFileOrd().get()).getStore()) instanceof BLocalFileStore) {
            this.setSignersInitialized(true);
            BVector signers = this.getCodeSigners();
            signers.removeAll();
            try {
                List codeSigners = registry.getCodeSigners(((BLocalFileStore)store).getLocalFile());
                if (codeSigners != null) {
                    for (CodeSigner signer : codeSigners) {
                        signers.add(null, (BValue)new BCodeSigner(signer));
                    }
                }
                this.setSignatureFailureCause(registry.getSignatureFailureCause(((BLocalFileStore)store).getLocalFile()));
            }
            catch (Exception e) {
                this.setSignatureFailureCause(e.getMessage());
            }
        }
    }

    public List<ModuleSignatureStatusEnum> getSignatureStatus(CertificateChainValidator validator) {
        ArrayList<CodeSigner> codeSigners = null;
        if (this.getSignersInitialized()) {
            codeSigners = new ArrayList<CodeSigner>();
            BVector signers = this.getCodeSigners();
            SlotCursor c = signers.getProperties();
            while (c.next()) {
                codeSigners.add(((BCodeSigner)c.get()).getCodeSigner());
            }
        }
        return ModuleSignatureStatusEnum.getSignatureStatus(codeSigners, this.getSignatureFailureCause(), validator);
    }

    public void initSummary() {
        if (!this.summaryInitialized) {
            this.init();
        }
    }

    public void init() {
        if (this.manifest != null || !this.localInstance || !this.getInstallable().getIsValid()) {
            return;
        }
        if (this.file != null) {
            try {
                AccessController.doPrivileged(() -> {
                    InputStream manifestStream = DaemonFileUtil.getZipStream(this.file, new FilePath("META-INF/module.xml"));
                    if (manifestStream == null) {
                        manifestStream = DaemonFileUtil.getZipStream(this.file, new FilePath("meta-inf/module.xml"));
                    }
                    if (manifestStream == null) {
                        manifestStream = DaemonFileUtil.getZipStream(this.file, new FilePath("META-INF/module.xml"));
                    }
                    this.loadManifest(manifestStream);
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof RuntimeException) {
                    throw (RuntimeException)pae.getException();
                }
                throw new BajaRuntimeException((Throwable)pae.getException());
            }
        }
    }

    public BDependency getDependency(String dependentModuleName) {
        return (BDependency)this.getDependencies().get(SlotPath.escape((String)dependentModuleName));
    }

    public FilePath getDestinationPath(boolean isNiagaraHomeReadonly) {
        if (!this.getSynthetic()) {
            return SystemFilePaths.getModulesPath(isNiagaraHomeReadonly).merge(this.getPartName() + ".jar");
        }
        return SystemFilePaths.getModulesPath(isNiagaraHomeReadonly).merge(this.getPartName() + ".sjar");
    }

    public BIcon getIcon() {
        return icon;
    }

    public InputStream getInputStream() {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModulePart");
        }
        try {
            return AccessController.doPrivileged(() -> ((BIFile)this.file).getInputStream());
        }
        catch (PrivilegedActionException pae) {
            throw new LocalizableRuntimeException("platform", "LocalModulePart.exception.notFound", new Object[]{this.file.getFilePath()}, (Throwable)pae.getException());
        }
    }

    public ModuleManifest getManifest() {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModulePart");
        }
        this.init();
        return this.manifest;
    }

    public BVersion getVersionRequired(String moduleName) {
        BDependency result = this.getDependency(moduleName);
        return result == null ? BVersion.ZERO : result.getVersion();
    }

    public Set<String> getRequiredModuleNames() {
        HashSet<String> result = new HashSet<String>();
        for (Property p : this.getDependencies().getPropertiesArray()) {
            result.add(p.getName());
        }
        return result;
    }

    public Set<BDependency> dependenciesForRelatedParts(Set<RuntimeProfile> enabledRuntimeProfiles) {
        HashSet<BDependency> result = new HashSet<BDependency>();
        SlotCursor c = this.getRelatedModulePartNames().getProperties();
        while (c.next()) {
            if (!enabledRuntimeProfiles.contains(RuntimeProfile.valueOf((String)c.property().getName()))) continue;
            result.add(BDependency.forModule(c.get().toString()));
        }
        return result;
    }

    public boolean isUpgradeFor(BModulePart part) {
        this.initSummary();
        if (part.getVersion().meetsVersionRequirement(this.getVersion(), BVersionRelation.minimum)) {
            return part.getBuildAbsTime() != null && this.getBuildAbsTime() != null && this.getBuildAbsTime().compareTo((Object)part.getBuildAbsTime()) > 0;
        }
        return true;
    }

    public boolean isUpdateFor(BModulePart part) {
        return this.isUpdateFor(part, null);
    }

    public boolean isUpdateFor(BModulePart part, BDaemonPlatform target) {
        this.initSummary();
        if (target != null && target.getModuleContent() != part.getArchiveContent()) {
            return true;
        }
        if (part.getVersion().equivalent((Object)this.getVersion())) {
            return part.getBuildAbsTime() == null || this.getBuildAbsTime() == null || !this.getBuildAbsTime().equals((Object)part.getBuildAbsTime());
        }
        return true;
    }

    public String toString(Context context) {
        return "Module: " + this.getPartName() + " " + (Object)((Object)this.getVersion());
    }

    public void writePackageArchive(BDaemonPlatform targetPlatform, ZipOutputStream zOut) throws Exception {
        this.writePackageArchive(targetPlatform.getModuleContent(), targetPlatform.getStripLineNumbers(), zOut);
    }

    public void writePackageArchive(BModuleContent moduleContent, boolean stripLineNumbers, ZipOutputStream zOut) throws Exception {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModulePart");
        }
        this.init();
        try {
            ZipEntry entry;
            ZipInputStream in = new ZipInputStream(this.getInputStream());
            ClassCondenser condenser = new ClassCondenser();
            while ((entry = in.getNextEntry()) != null) {
                if (entry.getName().equalsIgnoreCase("meta-inf/module.xml")) {
                    ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                    this.getManifest().write(moduleContent, bOut);
                    ZipEntry xmlEntry = new ZipEntry(entry.getName());
                    xmlEntry.setSize(bOut.size());
                    xmlEntry.setTime(System.currentTimeMillis());
                    zOut.putNextEntry(xmlEntry);
                    zOut.write(bOut.toByteArray(), 0, bOut.size());
                    zOut.closeEntry();
                    continue;
                }
                if (!this.getManifest().includePath(this.getDirectoryName(entry), moduleContent)) continue;
                if (stripLineNumbers && entry.getName().endsWith(".class")) {
                    zOut.putNextEntry(new ZipEntry(entry.getName()));
                    condenser.condense(in, zOut, false);
                } else {
                    zOut.putNextEntry(new ZipEntry(entry));
                    byte[] b = new byte[65000];
                    int bytesRead = in.read(b);
                    while (bytesRead >= 0) {
                        zOut.write(b, 0, bytesRead);
                        bytesRead = in.read(b);
                    }
                }
                zOut.closeEntry();
            }
            in.close();
        }
        catch (IOException ioe) {
            throw new LocalizableRuntimeException("platform", "ModulePart.exception.writePackageArchive", new Object[]{this.getPartName()}, (Throwable)ioe);
        }
    }

    private void loadManifest(XElem manifestDom) {
        this.loadManifest(ModuleManifest.make(manifestDom));
    }

    private void loadManifest(InputStream manifestStream) {
        this.loadManifest(manifestStream, true);
    }

    private void loadManifest(InputStream manifestStream, boolean closeStream) {
        this.loadManifest(ModuleManifest.make(manifestStream, closeStream));
    }

    private void loadManifest(ModuleManifest manifest) {
        this.manifest = manifest;
        this.setStatus(manifest.getStatus());
        if (!this.summaryInitialized) {
            this.setPartName(manifest.getModulePartName());
            this.setModuleName(manifest.getModuleName());
            this.setBuildAbsTime(manifest.getBuildAbsTime());
            this.setVersion((BVersion)manifest.getVersion().newCopy());
            this.setDescription(manifest.getDescription());
            this.setArchiveContent(manifest.getModuleContent());
            this.setManifestSchemaVersion(manifest.getManifestSchemaVersion());
            this.setRuntimeProfile(manifest.getRuntimeProfile());
            this.summaryInitialized = true;
        }
        if (!this.dependsInitialized) {
            BVector v = (BVector)this.get(dependencies);
            v.removeAll();
            for (BDependency dep : manifest.getDependencies()) {
                v.add(SlotPath.escape((String)dep.getPartName()), dep.newCopy());
            }
            v = (BVector)this.get(exclusions);
            v.removeAll();
            for (BDependency excl : manifest.getExclusions()) {
                v.add("excl?", (BValue)excl);
            }
            v = (BVector)this.get(relatedModulePartNames);
            v.removeAll();
            for (Map.Entry entry : manifest.getRelatedModulePartNames().entrySet()) {
                v.add(((RuntimeProfile)entry.getKey()).name(), (BValue)BString.make((String)((String)entry.getValue())));
            }
            this.dependsInitialized = true;
        }
        this.setBuildDate(manifest.getBuildDate());
        this.setBuildHost(manifest.getBuildHost());
        this.setArchiveDate(manifest.getArchiveDate());
        this.setArchiveHost(manifest.getArchiveHost());
        this.setPreferredSymbol(manifest.getPreferredSymbol());
        this.setIsNre(manifest.isNreModule());
        this.setIsInstallable(manifest.isInstallable());
        this.setReleaseDate(manifest.getReleaseDate());
    }

    private String getDirectoryName(ZipEntry entry) {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModulePart");
        }
        if (entry.isDirectory()) {
            return entry.getName();
        }
        int lastSlash = entry.getName().lastIndexOf(47);
        if (lastSlash < 0) {
            return "";
        }
        return entry.getName().substring(0, lastSlash);
    }

    public long getFilteredFileSize(BDaemonPlatform targetPlatform) {
        return this.getFilteredFileSize(targetPlatform.getModuleContent(), targetPlatform.getStripLineNumbers());
    }

    public long getFilteredFileSize(BModuleContent moduleContent, boolean stripLineNumbers) {
        if (this.localInstance && moduleContent != BModuleContent.doc) {
            try {
                ByteCounter byteCounter = new ByteCounter();
                ZipOutputStream zipOut = new ZipOutputStream(byteCounter);
                this.writePackageArchive(moduleContent, stripLineNumbers, zipOut);
                zipOut.closeEntry();
                zipOut.flush();
                zipOut.close();
                byteCounter.flush();
                byteCounter.close();
                return byteCounter.size();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.getInstallable().getInstallableFileSize();
    }

    public boolean canMakeTransferElements() {
        return this.localInstance;
    }

    public FileTransferMessageElement makeTransferElement(BDaemonPlatform target) {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModuleInstallable");
        }
        return new ModuleFileTransferElement(this, target.getDaemonSession());
    }

    private class ByteCounter
    extends OutputStream {
        private long size = 0L;

        private ByteCounter() {
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.size += (long)len;
        }

        @Override
        public void write(int b) {
            ++this.size;
        }

        public long size() {
            return this.size;
        }
    }

    private static class ModuleFileTransferElement
    extends FileTransferMessageElement {
        private static final BIcon icon = BIcon.std((String)"module.png");
        private final BModulePart sourceModule;
        private final BDaemonSession session;
        private byte[] buf = null;

        public ModuleFileTransferElement(BModulePart sourceModule, BDaemonSession session) {
            super(sourceModule.getDestinationPath(session.getHostProperties().getIsNiagaraHomeReadonly()), session.getFileSpace());
            this.sourceModule = sourceModule;
            this.session = session;
        }

        @Override
        public InputStream getStream() throws IOException {
            try {
                if (this.modifyContents()) {
                    byte[] buf = this.getModifiedBuf();
                    if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.install.copyProcessedModule")).booleanValue()) {
                        BIFile copy = BFileSystem.INSTANCE.makeFile(SystemFilePaths.getModuleCopiesPath(this.session.getHostProperties().getIsNiagaraHomeReadonly()).merge(this.sourceModule.getDestinationPath(this.session.getHostProperties().getIsNiagaraHomeReadonly()).getName()));
                        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
                             OutputStream outputStream = copy.getOutputStream();){
                            FileUtil.pipe((InputStream)inputStream, (OutputStream)outputStream);
                        }
                    }
                    return new ByteArrayInputStream(buf);
                }
                return this.sourceModule.getInputStream();
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("platform", "ModuleFileTransferElement.exception.read", (Throwable)e);
            }
        }

        @Override
        public long getSize() {
            if (this.modifyContents()) {
                return this.getModifiedBuf().length;
            }
            return this.sourceModule.getFileSize();
        }

        private BDaemonPlatform getDaemonPlatform() {
            try {
                return BRemoteDaemonPlatform.make(this.session, null);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        private boolean modifyContents() {
            return this.sourceModule.getManifestSchemaVersion() <= 3 && this.getDaemonPlatform().getModuleContent() != BModuleContent.doc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getModifiedBuf() {
            if (this.buf == null) {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ZipOutputStream zipOut = new ZipOutputStream(byteOut);
                try {
                    this.sourceModule.writePackageArchive(this.getDaemonPlatform(), zipOut);
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        zipOut.closeEntry();
                        zipOut.flush();
                        zipOut.close();
                    }
                    catch (Exception exception) {}
                }
                this.buf = byteOut.toByteArray();
            }
            return this.buf;
        }

        @Override
        public BIcon getIcon() {
            return icon;
        }
    }
}

