/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.nre.util.NiagaraFiles;
import com.tridium.platform.BPlatformServiceContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.baja.agent.AgentList;
import javax.baja.file.BajaFileUtil;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="platformServiceDescription", type="String", defaultValue="unknown", flags=1)
@NiagaraActions(value={@NiagaraAction(name="poll", flags=2048), @NiagaraAction(name="checkPropertiesLoaded", flags=4), @NiagaraAction(name="savePlatformServiceProperties", flags=4)})
public abstract class BPlatformService
extends BComponent
implements BIService {
    @Generated
    public static final Property platformServiceDescription = BPlatformService.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Action poll = BPlatformService.newAction((int)2048, null);
    @Generated
    public static final Action checkPropertiesLoaded = BPlatformService.newAction((int)4, null);
    @Generated
    public static final Action savePlatformServiceProperties = BPlatformService.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatformService.class);
    protected boolean platformServicePropertiesLoaded = false;
    protected boolean isProxy = true;
    protected boolean isServiceStarted = false;
    protected Clock.Ticket pollTicket = null;

    @Generated
    public String getPlatformServiceDescription() {
        return this.getString(platformServiceDescription);
    }

    @Generated
    public void setPlatformServiceDescription(String v) {
        this.setString(platformServiceDescription, v, null);
    }

    @Generated
    public void poll() {
        this.invoke(poll, null, null);
    }

    @Generated
    public void checkPropertiesLoaded() {
        this.invoke(checkPropertiesLoaded, null, null);
    }

    @Generated
    public void savePlatformServiceProperties() {
        this.invoke(savePlatformServiceProperties, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public boolean isValidPlatform() {
        return false;
    }

    public String getLicenseFeature() {
        return null;
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public int getSlotFlags() {
        return 4;
    }

    public void loadPlatformServiceProperties() {
    }

    public void doStationStarted(BStation station) {
    }

    protected boolean startPollTimerOnSubscribe() {
        return false;
    }

    public BRelTime getPollFrequency() {
        return BRelTime.DEFAULT;
    }

    public AgentList getAgents(Context cx) {
        try {
            AgentList result = super.getAgents(cx);
            result.remove("workbench:PropertySheet");
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        this.checkPropertiesLoaded();
    }

    public final synchronized void doCheckPropertiesLoaded() {
        if (!this.platformServicePropertiesLoaded) {
            AccessController.doPrivileged(() -> {
                this.loadPlatformServiceProperties();
                return null;
            });
            this.platformServicePropertiesLoaded = true;
        }
    }

    public void doSavePlatformServiceProperties() throws Exception {
        try {
            AccessController.doPrivileged(new DoSavePlatformServicesPropertiesPrivilegedAction());
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public void serviceStarted() throws Exception {
        this.isProxy = false;
        this.isServiceStarted = true;
    }

    public void serviceStopped() throws Exception {
        this.isServiceStarted = false;
    }

    public boolean isServiceStarted() {
        return this.isServiceStarted;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BPlatformServiceContainer;
    }

    public void subscribed() {
        if (this.startPollTimerOnSubscribe()) {
            this.startPollTimer();
        } else {
            this.poll();
        }
        super.subscribed();
    }

    public void unsubscribed() {
        if (this.startPollTimerOnSubscribe()) {
            this.stopPollTimer();
        }
    }

    protected void startPollTimer() {
        this.poll();
        if (this.pollTicket == null && this.getPollFrequency().getMillis() > 0L && this.isRunning()) {
            this.pollTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getPollFrequency(), (Action)poll, null);
        }
    }

    protected void stopPollTimer() {
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
            this.pollTicket = null;
        }
    }

    public final String getNavDescription(Context cx) {
        if (this.getPlatformServiceDescription().equals("unknown")) {
            return super.getNavDescription(cx);
        }
        return this.getPlatformServiceDescription();
    }

    public boolean hasNavChildren() {
        return false;
    }

    public static void powerSafeSave(byte[] buf, String fileName) throws Exception {
        File finalFile = new File(fileName);
        File workingFile = BPlatformService.getWorkingCopyPath(finalFile);
        AccessController.doPrivileged(() -> {
            if (!finalFile.getParentFile().exists() && !finalFile.getParentFile().mkdirs()) {
                throw new Exception("Failed to create file at " + fileName + " could not create parent");
            }
            try (FileOutputStream out = new FileOutputStream(workingFile);){
                out.write(buf);
                out.getFD().sync();
            }
            Files.move(workingFile.toPath(), finalFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            return null;
        });
    }

    static File getWorkingCopyPath(File basePath) {
        return new File(basePath.getParentFile(), basePath.getName() + ".working");
    }

    private class DoSavePlatformServicesPropertiesPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private DoSavePlatformServicesPropertiesPrivilegedAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() throws Exception {
            BPlatformServiceContainer container;
            if (!BPlatformService.this.isRunning()) {
                return null;
            }
            BPlatformServiceContainer bPlatformServiceContainer = container = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
            synchronized (bPlatformServiceContainer) {
                File platformFile = NiagaraFiles.getPlatformBogPath();
                File workingFile = BPlatformService.getWorkingCopyPath(platformFile);
                try (ValueDocEncoder encoder = new ValueDocEncoder(workingFile);){
                    encoder.encodeDocument((BValue)container);
                }
                BajaFileUtil.renameToBackup((File)platformFile, (int)1);
                if (!workingFile.renameTo(platformFile)) {
                    throw new BajaRuntimeException("platform.bog rename failed");
                }
            }
            return null;
        }
    }
}

