/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.command;

import com.tridium.platform.command.BIPlatformCommand;
import java.security.AccessController;
import java.util.function.Predicate;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BAbstractPlatformCommand
extends BSingleton
implements BIPlatformCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractPlatformCommand.class);
    public static final Predicate<String> NOT_EMPTY_STRING = value -> value != null && !value.isEmpty();
    public static final Predicate<char[]> NOT_EMPTY_CHARS = value -> value != null && ((char[])value).length > 0;
    protected static final String EMPTY = "";
    protected static final String USAGE = "usage:";
    protected static final String COMMANDS = "commands:";
    protected static final String PARAMETERS = "parameters:";
    protected static final String REQUIRED_FLAGS = "required flags:";
    protected static final String OPTIONAL_FLAGS = "optional flags:";
    protected static final String USAGE_FLAG = "  -usage                   prints this message";
    protected static final String USAGE_SHORT_FLAG = "  -?                       same as -usage";
    protected static final String HELP_FLAG = "  -help                    same as -usage";
    protected static final String PLATFORM_USER_FLAG = "  -usr:<userName>          user name for the host's platform daemon";
    protected static final String PLATFORM_PASSWORD_FLAG = "  -pwd:<password>          password for the host's platform daemon";
    protected static final String HOST_ORD_FLAG = "  -h:<hostord>             ORD for the remote host";
    protected static final String LOCALE_FLAG = "  -locale:<x>              set the default locale (en_US)";
    protected static final String JVM_OPTION_FLAG = "  -@<option>               pass option to Java VM";
    protected static final String BUILD_REGISTRY_FLAG = "  -buildreg                force rebuild of the registry";
    protected static final String NO_INPUT_FLAG = "  -noinput                 if given, command will fail when username\n                             and password are missing or incorrect,\n                             instead of prompting and reading them\n                             from stdin";
    protected static final String PORT_FLAG = "  -p:<port>                port for the host's platform daemon\n                             if omitted, default port 3011 or 5011 is used";
    protected static final String SECURE_FLAG = "  -secure                  if given, the connection will be encrypted with TLS";
    protected static final String SYSTEM_PASSWORD_FLAG = "  -syspwd:<password>       system passphrase used to protect this distribution file\n                             if the target platform is currently protected by the same\n                             system passphrase as this distribution, this argument is ignored";
    protected static final String NO_TCP_FLAG = "  -notcp                   if present, the install will not change the\n                             remote host's TCP/IP settings";
    protected static final String TCP_FLAG = "  -tcp                     if present, the install will change the\n                             remote host's TCP/IP settings";
    protected static final String RECURSE_FLAG = "  -recurse                 apply file operation recursively";
    protected static final String RECURSE_SHORT_FLAG = "  -r                       same as -recurse";
    protected static final String ALL_OUT_OF_DATE_FLAG = "  -ood                     all out-of-date modules are to be upgraded";
    protected static final String OVERWRITE_FLAG = "  -overwrite:<opt>         overwrite option, default is 'prompt', values are:\n                             'all'    unconditionally overwrite\n                             'prompt' prompt for each overwrite\n                             'none'   never overwrite\n                             'crc'    overwrite only if crc is different";
    protected static final String OVERWRITE_SHORT_FLAG = "  -o:<opt>                 same as -overwrite";

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getLicenseVendor() {
        return null;
    }

    @Override
    public String getLicenseFeature() {
        return null;
    }

    @Override
    public boolean includeInCommandListing() {
        return true;
    }

    protected boolean promptBoolean(String text) {
        String result = this.promptString(text);
        return result.charAt(0) == 'Y' || result.charAt(0) == 'y';
    }

    protected char[] promptPassword(String text) {
        return this.promptPassword(text, NOT_EMPTY_CHARS);
    }

    protected char[] promptPassword(String text, Predicate<char[]> validator) {
        try {
            char[] line = AccessController.doPrivileged(() -> System.console().readPassword(text, new Object[0]));
            while (!validator.test(line)) {
                line = AccessController.doPrivileged(() -> System.console().readPassword(text, new Object[0]));
            }
            return line;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected String promptString(String text) {
        return this.promptString(text, NOT_EMPTY_STRING);
    }

    protected String promptString(String text, Predicate<String> validator) {
        try {
            String line = null;
            while (!validator.test(line)) {
                line = AccessController.doPrivileged(() -> System.console().readLine(text, new Object[0]));
            }
            return line;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected static void println(String format, Object ... args) {
        if (args.length == 0) {
            System.out.println(format);
        } else {
            System.out.printf(format + "%n", args);
        }
    }
}

