/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.install.part.BGenericPart;
import com.tridium.nre.util.LicenseMode;
import com.tridium.nre.util.SupportLevel;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BHostIdSettings;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.syslog.BSyslogSettings;
import com.tridium.platform.timezone.BDstSupportLevel;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hostId", type="String", defaultValue="", flags=3), @NiagaraProperty(name="hostIdSettings", type="BHostIdSettings", defaultValue="new BHostIdSettings()", flags=3), @NiagaraProperty(name="brandId", type="String", defaultValue="", flags=3), @NiagaraProperty(name="sessionTimestamp", type="String", defaultValue="", flags=3), @NiagaraProperty(name="moduleContent", type="BModuleContent", defaultValue="BModuleContent.doc", flags=3), @NiagaraProperty(name="daemonVersion", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="httpPort", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="stripLineNumbers", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="hostArch", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="modelName", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="productName", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="modelVersion", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="serialNumber", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="osCrcText", type="String", defaultValue="String.valueOf(-1)", flags=3), @NiagaraProperty(name="osName", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="osDesc", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="osVersion", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="osInstallable", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="nrePartName", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="nrePartDesc", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="nrePartVersion", type="String", defaultValue="", flags=3), @NiagaraProperty(name="vmName", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="vmVendor", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="vmVersion", type="String", defaultValue="", flags=3), @NiagaraProperty(name="isVmUnspecified", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="parts", type="BVector", defaultValue="new BVector()", flags=3), @NiagaraProperty(name="isDirty", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="servletNames", type="BVector", defaultValue="new BVector()", flags=3), @NiagaraProperty(name="maxStations", type="int", defaultValue="1", flags=3), @NiagaraProperty(name="maxSedonaApps", type="int", defaultValue="1", flags=3), @NiagaraProperty(name="numCpus", type="int", defaultValue="1", flags=3), @NiagaraProperty(name="currentCpuUsage", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="overallCpuUsage", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="totalPhysicalMemory", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="freePhysicalMemory", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="filesystemAttributes", type="BVector", defaultValue="new BVector()", flags=3), @NiagaraProperty(name="timezoneDayModeSupport", type="BDstSupportLevel", defaultValue="BDstSupportLevel.none", flags=3), @NiagaraProperty(name="isSystemTimeReadonly", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="accessLevel", type="BDaemonAccessLevel", defaultValue="BDaemonAccessLevel.restricted", flags=3), @NiagaraProperty(name="allowStationRestart", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="failureRebootLimit", type="int", defaultValue="3", flags=3), @NiagaraProperty(name="failureRebootLimitPeriod", type="BRelTime", defaultValue="BRelTime.HOUR", flags=3), @NiagaraProperty(name="configDistFileName", type="String", defaultValue="nre-config-*.dist", flags=3), @NiagaraProperty(name="isNpsdk", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sedonaSupported", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sedonaEnabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="niagaraStationsEnabled", type="boolean", defaultValue="true", flags=3), @NiagaraProperty(name="niagaraR2Supported", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="niagaraR2Enabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sslSupported", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sslSettings", type="BPlatformSSLSettings", defaultValue="new BPlatformSSLSettings()", flags=3), @NiagaraProperty(name="syslogSupported", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="syslogSettings", type="BSyslogSettings", defaultValue="new BSyslogSettings()", flags=3), @NiagaraProperty(name="supportedRuntimeProfilesVector", type="BVector", defaultValue="new BVector()", flags=3), @NiagaraProperty(name="enabledRuntimeProfileNames", type="String", defaultValue="rt,ux,wb,se,doc", flags=3), @NiagaraProperty(name="allowBrandChange", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isNiagaraHomeReadonly", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="requireSubscription", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isLicenseReadonly", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isSoftwareReadonly", type="boolean", defaultValue="false", flags=3)})
@NiagaraTopic(name="hostPropertiesChanged")
public class BHostProperties
extends BComponent {
    @Generated
    public static final Property hostId = BHostProperties.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property hostIdSettings = BHostProperties.newProperty((int)3, (BValue)new BHostIdSettings(), null);
    @Generated
    public static final Property brandId = BHostProperties.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property sessionTimestamp = BHostProperties.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property moduleContent = BHostProperties.newProperty((int)3, (BValue)BModuleContent.doc, null);
    @Generated
    public static final Property daemonVersion = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property httpPort = BHostProperties.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property stripLineNumbers = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property hostArch = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property modelName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property productName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property modelVersion = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property serialNumber = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property osCrcText = BHostProperties.newProperty((int)3, (String)String.valueOf(-1), null);
    @Generated
    public static final Property osName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property osDesc = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property osVersion = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property osInstallable = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property nrePartName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property nrePartDesc = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property nrePartVersion = BHostProperties.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property vmName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property vmVendor = BHostProperties.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property vmVersion = BHostProperties.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property isVmUnspecified = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property parts = BHostProperties.newProperty((int)3, (BValue)new BVector(), null);
    @Generated
    public static final Property isDirty = BHostProperties.newProperty((int)3, (boolean)true, null);
    @Generated
    public static final Property servletNames = BHostProperties.newProperty((int)3, (BValue)new BVector(), null);
    @Generated
    public static final Property maxStations = BHostProperties.newProperty((int)3, (int)1, null);
    @Generated
    public static final Property maxSedonaApps = BHostProperties.newProperty((int)3, (int)1, null);
    @Generated
    public static final Property numCpus = BHostProperties.newProperty((int)3, (int)1, null);
    @Generated
    public static final Property currentCpuUsage = BHostProperties.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property overallCpuUsage = BHostProperties.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property totalPhysicalMemory = BHostProperties.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property freePhysicalMemory = BHostProperties.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property filesystemAttributes = BHostProperties.newProperty((int)3, (BValue)new BVector(), null);
    @Generated
    public static final Property timezoneDayModeSupport = BHostProperties.newProperty((int)3, (BValue)BDstSupportLevel.none, null);
    @Generated
    public static final Property isSystemTimeReadonly = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property accessLevel = BHostProperties.newProperty((int)3, (BValue)BDaemonAccessLevel.restricted, null);
    @Generated
    public static final Property allowStationRestart = BHostProperties.newProperty((int)3, (boolean)true, null);
    @Generated
    public static final Property failureRebootLimit = BHostProperties.newProperty((int)3, (int)3, null);
    @Generated
    public static final Property failureRebootLimitPeriod = BHostProperties.newProperty((int)3, (BValue)BRelTime.HOUR, null);
    @Generated
    public static final Property configDistFileName = BHostProperties.newProperty((int)3, (String)"nre-config-*.dist", null);
    @Generated
    public static final Property isNpsdk = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property sedonaSupported = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property sedonaEnabled = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property niagaraStationsEnabled = BHostProperties.newProperty((int)3, (boolean)true, null);
    @Generated
    public static final Property niagaraR2Supported = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property niagaraR2Enabled = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property sslSupported = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property sslSettings = BHostProperties.newProperty((int)3, (BValue)new BPlatformSSLSettings(), null);
    @Generated
    public static final Property syslogSupported = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property syslogSettings = BHostProperties.newProperty((int)3, (BValue)new BSyslogSettings(), null);
    @Generated
    public static final Property supportedRuntimeProfilesVector = BHostProperties.newProperty((int)3, (BValue)new BVector(), null);
    @Generated
    public static final Property enabledRuntimeProfileNames = BHostProperties.newProperty((int)3, (String)"rt,ux,wb,se,doc", null);
    @Generated
    public static final Property allowBrandChange = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isNiagaraHomeReadonly = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property requireSubscription = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isLicenseReadonly = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isSoftwareReadonly = BHostProperties.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Topic hostPropertiesChanged = BHostProperties.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHostProperties.class);

    @Generated
    public String getHostId() {
        return this.getString(hostId);
    }

    @Generated
    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    @Generated
    public BHostIdSettings getHostIdSettings() {
        return (BHostIdSettings)this.get(hostIdSettings);
    }

    @Generated
    public void setHostIdSettings(BHostIdSettings v) {
        this.set(hostIdSettings, (BValue)v, null);
    }

    @Generated
    public String getBrandId() {
        return this.getString(brandId);
    }

    @Generated
    public void setBrandId(String v) {
        this.setString(brandId, v, null);
    }

    @Generated
    public String getSessionTimestamp() {
        return this.getString(sessionTimestamp);
    }

    @Generated
    public void setSessionTimestamp(String v) {
        this.setString(sessionTimestamp, v, null);
    }

    @Generated
    public BModuleContent getModuleContent() {
        return (BModuleContent)this.get(moduleContent);
    }

    @Generated
    public void setModuleContent(BModuleContent v) {
        this.set(moduleContent, (BValue)v, null);
    }

    @Generated
    public String getDaemonVersion() {
        return this.getString(daemonVersion);
    }

    @Generated
    public void setDaemonVersion(String v) {
        this.setString(daemonVersion, v, null);
    }

    @Generated
    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    @Generated
    public void setHttpPort(int v) {
        this.setInt(httpPort, v, null);
    }

    @Generated
    public boolean getStripLineNumbers() {
        return this.getBoolean(stripLineNumbers);
    }

    @Generated
    public void setStripLineNumbers(boolean v) {
        this.setBoolean(stripLineNumbers, v, null);
    }

    @Generated
    public String getHostArch() {
        return this.getString(hostArch);
    }

    @Generated
    public void setHostArch(String v) {
        this.setString(hostArch, v, null);
    }

    @Generated
    public String getModelName() {
        return this.getString(modelName);
    }

    @Generated
    public void setModelName(String v) {
        this.setString(modelName, v, null);
    }

    @Generated
    public String getProductName() {
        return this.getString(productName);
    }

    @Generated
    public void setProductName(String v) {
        this.setString(productName, v, null);
    }

    @Generated
    public String getModelVersion() {
        return this.getString(modelVersion);
    }

    @Generated
    public void setModelVersion(String v) {
        this.setString(modelVersion, v, null);
    }

    @Generated
    public String getSerialNumber() {
        return this.getString(serialNumber);
    }

    @Generated
    public void setSerialNumber(String v) {
        this.setString(serialNumber, v, null);
    }

    @Generated
    public String getOsCrcText() {
        return this.getString(osCrcText);
    }

    @Generated
    public void setOsCrcText(String v) {
        this.setString(osCrcText, v, null);
    }

    @Generated
    public String getOsName() {
        return this.getString(osName);
    }

    @Generated
    public void setOsName(String v) {
        this.setString(osName, v, null);
    }

    @Generated
    public String getOsDesc() {
        return this.getString(osDesc);
    }

    @Generated
    public void setOsDesc(String v) {
        this.setString(osDesc, v, null);
    }

    @Generated
    public String getOsVersion() {
        return this.getString(osVersion);
    }

    @Generated
    public void setOsVersion(String v) {
        this.setString(osVersion, v, null);
    }

    @Generated
    public boolean getOsInstallable() {
        return this.getBoolean(osInstallable);
    }

    @Generated
    public void setOsInstallable(boolean v) {
        this.setBoolean(osInstallable, v, null);
    }

    @Generated
    public String getNrePartName() {
        return this.getString(nrePartName);
    }

    @Generated
    public void setNrePartName(String v) {
        this.setString(nrePartName, v, null);
    }

    @Generated
    public String getNrePartDesc() {
        return this.getString(nrePartDesc);
    }

    @Generated
    public void setNrePartDesc(String v) {
        this.setString(nrePartDesc, v, null);
    }

    @Generated
    public String getNrePartVersion() {
        return this.getString(nrePartVersion);
    }

    @Generated
    public void setNrePartVersion(String v) {
        this.setString(nrePartVersion, v, null);
    }

    @Generated
    public String getVmName() {
        return this.getString(vmName);
    }

    @Generated
    public void setVmName(String v) {
        this.setString(vmName, v, null);
    }

    @Generated
    public String getVmVendor() {
        return this.getString(vmVendor);
    }

    @Generated
    public void setVmVendor(String v) {
        this.setString(vmVendor, v, null);
    }

    @Generated
    public String getVmVersion() {
        return this.getString(vmVersion);
    }

    @Generated
    public void setVmVersion(String v) {
        this.setString(vmVersion, v, null);
    }

    @Generated
    public boolean getIsVmUnspecified() {
        return this.getBoolean(isVmUnspecified);
    }

    @Generated
    public void setIsVmUnspecified(boolean v) {
        this.setBoolean(isVmUnspecified, v, null);
    }

    @Generated
    public BVector getParts() {
        return (BVector)this.get(parts);
    }

    @Generated
    public void setParts(BVector v) {
        this.set(parts, (BValue)v, null);
    }

    @Generated
    public boolean getIsDirty() {
        return this.getBoolean(isDirty);
    }

    @Generated
    public void setIsDirty(boolean v) {
        this.setBoolean(isDirty, v, null);
    }

    @Generated
    public BVector getServletNames() {
        return (BVector)this.get(servletNames);
    }

    @Generated
    public void setServletNames(BVector v) {
        this.set(servletNames, (BValue)v, null);
    }

    @Generated
    public int getMaxStations() {
        return this.getInt(maxStations);
    }

    @Generated
    public void setMaxStations(int v) {
        this.setInt(maxStations, v, null);
    }

    @Generated
    public int getMaxSedonaApps() {
        return this.getInt(maxSedonaApps);
    }

    @Generated
    public void setMaxSedonaApps(int v) {
        this.setInt(maxSedonaApps, v, null);
    }

    @Generated
    public int getNumCpus() {
        return this.getInt(numCpus);
    }

    @Generated
    public void setNumCpus(int v) {
        this.setInt(numCpus, v, null);
    }

    @Generated
    public int getCurrentCpuUsage() {
        return this.getInt(currentCpuUsage);
    }

    @Generated
    public void setCurrentCpuUsage(int v) {
        this.setInt(currentCpuUsage, v, null);
    }

    @Generated
    public int getOverallCpuUsage() {
        return this.getInt(overallCpuUsage);
    }

    @Generated
    public void setOverallCpuUsage(int v) {
        this.setInt(overallCpuUsage, v, null);
    }

    @Generated
    public int getTotalPhysicalMemory() {
        return this.getInt(totalPhysicalMemory);
    }

    @Generated
    public void setTotalPhysicalMemory(int v) {
        this.setInt(totalPhysicalMemory, v, null);
    }

    @Generated
    public int getFreePhysicalMemory() {
        return this.getInt(freePhysicalMemory);
    }

    @Generated
    public void setFreePhysicalMemory(int v) {
        this.setInt(freePhysicalMemory, v, null);
    }

    @Generated
    public BVector getFilesystemAttributes() {
        return (BVector)this.get(filesystemAttributes);
    }

    @Generated
    public void setFilesystemAttributes(BVector v) {
        this.set(filesystemAttributes, (BValue)v, null);
    }

    @Generated
    public BDstSupportLevel getTimezoneDayModeSupport() {
        return (BDstSupportLevel)this.get(timezoneDayModeSupport);
    }

    @Generated
    public void setTimezoneDayModeSupport(BDstSupportLevel v) {
        this.set(timezoneDayModeSupport, (BValue)v, null);
    }

    @Generated
    public boolean getIsSystemTimeReadonly() {
        return this.getBoolean(isSystemTimeReadonly);
    }

    @Generated
    public void setIsSystemTimeReadonly(boolean v) {
        this.setBoolean(isSystemTimeReadonly, v, null);
    }

    @Generated
    public BDaemonAccessLevel getAccessLevel() {
        return (BDaemonAccessLevel)this.get(accessLevel);
    }

    @Generated
    public void setAccessLevel(BDaemonAccessLevel v) {
        this.set(accessLevel, (BValue)v, null);
    }

    @Generated
    public boolean getAllowStationRestart() {
        return this.getBoolean(allowStationRestart);
    }

    @Generated
    public void setAllowStationRestart(boolean v) {
        this.setBoolean(allowStationRestart, v, null);
    }

    @Generated
    public int getFailureRebootLimit() {
        return this.getInt(failureRebootLimit);
    }

    @Generated
    public void setFailureRebootLimit(int v) {
        this.setInt(failureRebootLimit, v, null);
    }

    @Generated
    public BRelTime getFailureRebootLimitPeriod() {
        return (BRelTime)this.get(failureRebootLimitPeriod);
    }

    @Generated
    public void setFailureRebootLimitPeriod(BRelTime v) {
        this.set(failureRebootLimitPeriod, (BValue)v, null);
    }

    @Generated
    public String getConfigDistFileName() {
        return this.getString(configDistFileName);
    }

    @Generated
    public void setConfigDistFileName(String v) {
        this.setString(configDistFileName, v, null);
    }

    @Generated
    public boolean getIsNpsdk() {
        return this.getBoolean(isNpsdk);
    }

    @Generated
    public void setIsNpsdk(boolean v) {
        this.setBoolean(isNpsdk, v, null);
    }

    @Generated
    public boolean getSedonaSupported() {
        return this.getBoolean(sedonaSupported);
    }

    @Generated
    public void setSedonaSupported(boolean v) {
        this.setBoolean(sedonaSupported, v, null);
    }

    @Generated
    public boolean getSedonaEnabled() {
        return this.getBoolean(sedonaEnabled);
    }

    @Generated
    public void setSedonaEnabled(boolean v) {
        this.setBoolean(sedonaEnabled, v, null);
    }

    @Generated
    public boolean getNiagaraStationsEnabled() {
        return this.getBoolean(niagaraStationsEnabled);
    }

    @Generated
    public void setNiagaraStationsEnabled(boolean v) {
        this.setBoolean(niagaraStationsEnabled, v, null);
    }

    @Generated
    public boolean getNiagaraR2Supported() {
        return this.getBoolean(niagaraR2Supported);
    }

    @Generated
    public void setNiagaraR2Supported(boolean v) {
        this.setBoolean(niagaraR2Supported, v, null);
    }

    @Generated
    public boolean getNiagaraR2Enabled() {
        return this.getBoolean(niagaraR2Enabled);
    }

    @Generated
    public void setNiagaraR2Enabled(boolean v) {
        this.setBoolean(niagaraR2Enabled, v, null);
    }

    @Generated
    public boolean getSslSupported() {
        return this.getBoolean(sslSupported);
    }

    @Generated
    public void setSslSupported(boolean v) {
        this.setBoolean(sslSupported, v, null);
    }

    @Generated
    public BPlatformSSLSettings getSslSettings() {
        return (BPlatformSSLSettings)this.get(sslSettings);
    }

    @Generated
    public void setSslSettings(BPlatformSSLSettings v) {
        this.set(sslSettings, (BValue)v, null);
    }

    @Generated
    public boolean getSyslogSupported() {
        return this.getBoolean(syslogSupported);
    }

    @Generated
    public void setSyslogSupported(boolean v) {
        this.setBoolean(syslogSupported, v, null);
    }

    @Generated
    public BSyslogSettings getSyslogSettings() {
        return (BSyslogSettings)this.get(syslogSettings);
    }

    @Generated
    public void setSyslogSettings(BSyslogSettings v) {
        this.set(syslogSettings, (BValue)v, null);
    }

    @Generated
    public BVector getSupportedRuntimeProfilesVector() {
        return (BVector)this.get(supportedRuntimeProfilesVector);
    }

    @Generated
    public void setSupportedRuntimeProfilesVector(BVector v) {
        this.set(supportedRuntimeProfilesVector, (BValue)v, null);
    }

    @Generated
    public String getEnabledRuntimeProfileNames() {
        return this.getString(enabledRuntimeProfileNames);
    }

    @Generated
    public void setEnabledRuntimeProfileNames(String v) {
        this.setString(enabledRuntimeProfileNames, v, null);
    }

    @Generated
    public boolean getAllowBrandChange() {
        return this.getBoolean(allowBrandChange);
    }

    @Generated
    public void setAllowBrandChange(boolean v) {
        this.setBoolean(allowBrandChange, v, null);
    }

    @Generated
    public boolean getIsNiagaraHomeReadonly() {
        return this.getBoolean(isNiagaraHomeReadonly);
    }

    @Generated
    public void setIsNiagaraHomeReadonly(boolean v) {
        this.setBoolean(isNiagaraHomeReadonly, v, null);
    }

    @Generated
    public boolean getRequireSubscription() {
        return this.getBoolean(requireSubscription);
    }

    @Generated
    public void setRequireSubscription(boolean v) {
        this.setBoolean(requireSubscription, v, null);
    }

    @Generated
    public boolean getIsLicenseReadonly() {
        return this.getBoolean(isLicenseReadonly);
    }

    @Generated
    public void setIsLicenseReadonly(boolean v) {
        this.setBoolean(isLicenseReadonly, v, null);
    }

    @Generated
    public boolean getIsSoftwareReadonly() {
        return this.getBoolean(isSoftwareReadonly);
    }

    @Generated
    public void setIsSoftwareReadonly(boolean v) {
        this.setBoolean(isSoftwareReadonly, v, null);
    }

    @Generated
    public void fireHostPropertiesChanged(BValue event) {
        this.fire(hostPropertiesChanged, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getPartDescription(String partName) {
        BValue value = this.getParts().loadSlots().get(partName);
        return value == null ? null : value.toString();
    }

    public boolean hasFullAccess() {
        return this.getAccessLevel().atLeast(BDaemonAccessLevel.full);
    }

    public long getOsCrc() {
        return Long.parseLong(this.getOsCrcText());
    }

    public void reset() {
        this.removeAll();
        this.getParts().removeAll();
        this.getServletNames().removeAll();
        this.getFilesystemAttributes().removeAll();
        this.getSupportedRuntimeProfilesVector().removeAll();
        this.copyFrom((BComplex)new BHostProperties());
        this.set(daemonVersion, daemonVersion.getDefaultValue());
    }

    public void checkTimestamp(String stamp) {
        if (!this.getSessionTimestamp().equals(stamp)) {
            this.reset();
            this.setSessionTimestamp(stamp);
        }
    }

    public void loadServletsInfo(XElem servletsElem) {
        this.getServletNames().removeAll();
        this.setAccessLevel(BDaemonAccessLevel.restricted);
        for (XElem servletElem : servletsElem.elems("servlet")) {
            String servletName = servletElem.get("name");
            this.getServletNames().add(servletName, (BValue)BString.make((String)servletName));
            if (!servletName.equals("reboot")) continue;
            this.setAccessLevel(BDaemonAccessLevel.full);
        }
    }

    public boolean supportsServlet(String servletName) {
        return this.getServletNames().getProperty(servletName) != null;
    }

    public boolean isNiagara4() {
        try {
            if (new Version(this.getDaemonVersion()).compareTo(new Version("4.0")) >= 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isFips() {
        BGenericPart[] parts;
        for (BGenericPart part : parts = (BGenericPart[])this.getParts().getChildren(BGenericPart.class)) {
            if (!part.getPartName().startsWith("FIPS_140")) continue;
            return true;
        }
        return false;
    }

    public final Set<RuntimeProfile> getEnabledRuntimeProfiles() {
        TreeSet<RuntimeProfile> result = new TreeSet<RuntimeProfile>();
        for (String profileName : this.getEnabledRuntimeProfileNames().split(",")) {
            result.add(RuntimeProfile.valueOf((String)profileName));
        }
        return result;
    }

    public final SupportLevel getSupportForRuntimeProfile(RuntimeProfile profile) {
        Property prop = this.getSupportedRuntimeProfilesVector().getProperty(SlotPath.escape((String)profile.name()));
        if (prop == null) {
            return SupportLevel.unsupported;
        }
        return SupportLevel.valueOf((String)this.getSupportedRuntimeProfilesVector().get(prop).toString());
    }

    public void load(XElem platformInfoElem) throws Exception {
        XElem modelElem;
        XElem nreElem;
        XElem osElem;
        this.removeAll();
        this.setHttpPort(platformInfoElem.geti("httpPort", -1));
        this.setDaemonVersion(platformInfoElem.get("daemonVersion", "unknown"));
        String brandStr = platformInfoElem.get("brandId", "noBrand");
        if (brandStr.trim().length() == 0) {
            brandStr = "noBrand";
        }
        this.setBrandId(brandStr);
        this.setSerialNumber(platformInfoElem.get("serialNumber", "unknown"));
        String moduleContentTag = platformInfoElem.get("moduleContent", null);
        if (moduleContentTag == null) {
            moduleContentTag = platformInfoElem.get("installFlag", null);
        }
        if (moduleContentTag == null) {
            moduleContentTag = platformInfoElem.getb("embedded", false) ? "runtime" : "doc";
        }
        this.setModuleContent(BModuleContent.make(moduleContentTag));
        if (platformInfoElem.get("stripLineNumbers", null) != null) {
            this.setStripLineNumbers(platformInfoElem.getb("stripLineNumbers", false));
        } else {
            this.setStripLineNumbers(platformInfoElem.getb("embedded", false));
        }
        if (platformInfoElem.get("maxStations", null) != null) {
            this.setMaxStations(platformInfoElem.geti("maxStations", 32));
        } else if (platformInfoElem.getb("embedded", false)) {
            this.setMaxStations(1);
        } else {
            this.setMaxStations(32);
        }
        if (platformInfoElem.get("maxSedonaApps", null) != null) {
            this.setMaxSedonaApps(platformInfoElem.geti("maxSedonaApps", 65535));
        } else if (platformInfoElem.getb("embedded", false)) {
            this.setMaxSedonaApps(1);
        } else {
            this.setMaxSedonaApps(65535);
        }
        this.setFailureRebootLimit(platformInfoElem.geti("failureRebootLimit", 3));
        if (platformInfoElem.get("failureRebootLimitPeriod", null) != null) {
            this.setFailureRebootLimitPeriod(BRelTime.make((long)platformInfoElem.getl("failureRebootLimitPeriod")));
        } else {
            this.setFailureRebootLimitPeriod(BRelTime.HOUR);
        }
        this.setConfigDistFileName(platformInfoElem.get("configDistFileName", "nre-config-*.dist"));
        this.setIsNpsdk(platformInfoElem.getb("npsdk", false));
        this.setAllowBrandChange(platformInfoElem.getb("allowBrandChange", false));
        this.setIsLicenseReadonly(platformInfoElem.getb("isLicenseReadonly", false));
        this.setIsSoftwareReadonly(platformInfoElem.getb("isSoftwareReadonly", false));
        this.setIsNiagaraHomeReadonly(platformInfoElem.getb("isNiagaraHomeReadonly", false));
        this.setRequireSubscription(platformInfoElem.getb("requireSubscription", false));
        this.setSedonaSupported(platformInfoElem.getb("sedonaSupported", false));
        this.setSedonaEnabled(platformInfoElem.getb("sedonaEnabled", false));
        this.setNiagaraStationsEnabled(platformInfoElem.getb("niagaraStationsEnabled", true));
        this.setNiagaraR2Supported(platformInfoElem.getb("niagaraR2Supported", false));
        this.setNiagaraR2Enabled(platformInfoElem.getb("niagaraR2Enabled", false));
        String value = platformInfoElem.get("arch", null);
        if (value != null) {
            if (value.equals("amd64")) {
                value = "x64";
            }
            this.setHostArch(value);
        }
        if ((osElem = platformInfoElem.elem("os")) != null) {
            this.setOsName(osElem.get("name", "unknown"));
            value = osElem.get("arch", null);
            if (value != null) {
                this.setHostArch(value);
            }
            this.setOsDesc(osElem.get("desc", osElem.get("description", "unknown")));
            this.setOsVersion(osElem.get("version", ""));
            this.setOsCrcText(osElem.get("crc", "-1"));
            boolean osInstallableDefault = this.getOsName().startsWith("qnx-jace") || this.getOsName().startsWith("tridium-qnx7");
            this.setOsInstallable(osElem.getb("installable", osInstallableDefault));
        }
        this.getSupportedRuntimeProfilesVector().removeAll();
        if (platformInfoElem.elem("runtimeProfileSupport") == null) {
            if (this.isNiagara4()) {
                Logger.getLogger("platform").log(Level.WARNING, "Platform daemon does not report runtime profile support, using defaults");
                for (RuntimeProfile profile : RuntimeProfile.values()) {
                    if (profile == RuntimeProfile.se) {
                        this.getSupportedRuntimeProfilesVector().add(SlotPath.escape((String)profile.name()), (BValue)BString.make((String)(this.getOsName().toLowerCase().startsWith("win") ? SupportLevel.optional.name() : SupportLevel.unsupported.name())));
                        continue;
                    }
                    if (profile == RuntimeProfile.rt) {
                        this.getSupportedRuntimeProfilesVector().add(SlotPath.escape((String)profile.name()), (BValue)BString.make((String)SupportLevel.required.name()));
                        continue;
                    }
                    this.getSupportedRuntimeProfilesVector().add(SlotPath.escape((String)profile.name()), (BValue)BString.make((String)SupportLevel.optional.name()));
                }
            }
            if (this.getOsName().toLowerCase().startsWith("win")) {
                this.setEnabledRuntimeProfileNames("rt,ux,wb,se,doc");
            } else {
                this.setEnabledRuntimeProfileNames("rt,ux,wb,doc");
            }
        } else {
            HashSet<String> enabledProfileNames = new HashSet<String>();
            for (XElem profileElem : platformInfoElem.elem("runtimeProfileSupport").elems("profile")) {
                this.getSupportedRuntimeProfilesVector().add(SlotPath.escape((String)profileElem.get("name")), (BValue)BString.make((String)profileElem.get("supportLevel")));
                if (!profileElem.get("supportLevel").equals("required") && (!profileElem.get("supportLevel").equals("optional") || !profileElem.getb("enabled", false))) continue;
                enabledProfileNames.add(profileElem.get("name"));
            }
            this.setEnabledRuntimeProfileNames(String.join((CharSequence)",", enabledProfileNames));
        }
        XElem tzSupportElem = platformInfoElem.elem("tzSupport");
        if (tzSupportElem != null) {
            this.setTimezoneDayModeSupport(BDstSupportLevel.make(tzSupportElem.get("dayMode", "none")));
        }
        boolean timeReadonlyOnlyDefault = !this.getOsName().toLowerCase().contains("qnx") && !this.getIsNpsdk();
        this.setIsSystemTimeReadonly(platformInfoElem.getb("isSystemTimeReadonly", timeReadonlyOnlyDefault));
        boolean restartDefault = this.getOsName().toLowerCase().startsWith("win");
        this.setAllowStationRestart(platformInfoElem.getb("allowStationRestart", restartDefault));
        XElem vmElem = platformInfoElem.elem("vm");
        if (vmElem != null) {
            String vmName = vmElem.get("name", null);
            if (vmName == null || vmName.contains("Undetermined")) {
                this.setIsVmUnspecified(true);
            } else {
                this.setVmName(vmName);
                this.setVmVendor(vmElem.get("vendor", "unknown"));
                this.setVmVersion(vmElem.get("version", ""));
            }
        }
        if ((nreElem = platformInfoElem.elem("nre")) != null) {
            this.setNrePartName(nreElem.get("name", "unknown"));
            this.setNrePartDesc(nreElem.get("desc", nreElem.get("description", "unknown")));
            this.setNrePartVersion(nreElem.get("version", ""));
        }
        if ((modelElem = platformInfoElem.elem("model")) != null) {
            this.setModelName(modelElem.get("name", "unknown"));
            this.setProductName(modelElem.get("desc", modelElem.get("description", "unknown")));
            this.setModelVersion(modelElem.get("version", ""));
        }
        this.getParts().removeAll();
        for (XElem partElem : platformInfoElem.elems("part")) {
            this.getParts().add(SlotPath.escape((String)partElem.get("name")), (BValue)BGenericPart.make(partElem));
        }
        this.getFilesystemAttributes().removeAll();
        this.update(platformInfoElem);
    }

    public void update(XElem platformInfoElem) {
        XElem memElem;
        XElem cpuElem;
        XElem syslogSupported;
        this.setHostId(platformInfoElem.get("hostId"));
        XElem hostIdElem = platformInfoElem.elem("hostIdSupport");
        if (hostIdElem != null) {
            this.getHostIdSettings().updateFromXml(hostIdElem);
        } else {
            this.getHostIdSettings().setLicenseMode(LicenseMode.PERPETUAL);
            this.getHostIdSettings().setHostIdStatus(BHostIdStatus.perpetual);
            this.getHostIdSettings().setPerpetualHostId(this.getHostId());
        }
        XElem sslSupported = platformInfoElem.elem("sslSupported");
        if (sslSupported != null) {
            this.setSslSupported(true);
            if (this.getSslSettings() == null) {
                this.setSslSettings(new BPlatformSSLSettings());
            }
            this.getSslSettings().updateFromXml(sslSupported);
        }
        if ((syslogSupported = platformInfoElem.elem("syslogSupported")) != null) {
            this.setSyslogSupported(true);
            if (this.getSyslogSettings() == null) {
                this.setSyslogSettings(new BSyslogSettings());
            }
            this.getSyslogSettings().updateFromXml(syslogSupported);
        } else {
            this.setSyslogSupported(false);
        }
        XElem fileSystemsElem = platformInfoElem.elem("filesystems");
        if (fileSystemsElem != null) {
            for (XElem fileSystemElem : fileSystemsElem.elems("filesystem")) {
                BVector fileSystemAttributes;
                BFilesystemAttributes attr;
                String fsName = fileSystemElem.get("name");
                String displayName = fileSystemElem.get("displayName", fsName);
                String propName = SlotPath.escape((String)fsName);
                if (displayName == null) {
                    displayName = "";
                }
                if ((attr = (BFilesystemAttributes)(fileSystemAttributes = this.getFilesystemAttributes()).get(propName)) == null) {
                    attr = new BFilesystemAttributes(fileSystemElem.getl("totalBytes") / 1024L, fileSystemElem.getl("freeBytes") / 1024L, fileSystemElem.getl("maxFileCount", -1L), fileSystemElem.getl("currentFileCount", -1L));
                    int fileSystemAttrFlag = 3;
                    if (displayName.isEmpty()) {
                        fileSystemAttrFlag |= 4;
                    }
                    Property newAttr = fileSystemAttributes.add(propName, (BValue)attr, fileSystemAttrFlag);
                    fileSystemAttributes.setDisplayName(newAttr, BFormat.make((String)displayName), null);
                    continue;
                }
                attr.setTotalSpace(fileSystemElem.getl("totalBytes") / 1024L);
                attr.setFreeSpace(fileSystemElem.getl("freeBytes") / 1024L);
                attr.setMaxFileCount(fileSystemElem.getl("maxFileCount", -1L));
                attr.setCurrentFileCount(fileSystemElem.getl("currentFileCount", -1L));
            }
        }
        if ((cpuElem = platformInfoElem.elem("cpu")) != null) {
            this.setCurrentCpuUsage(cpuElem.geti("currentUtilization", -1));
            this.setOverallCpuUsage(cpuElem.geti("overallUtilization", -1));
            this.setNumCpus(cpuElem.geti("nCpus", 1));
        }
        if ((memElem = platformInfoElem.elem("physicalMemory")) != null) {
            this.setTotalPhysicalMemory((int)(memElem.getl("totalBytes") / 1024L));
            this.setFreePhysicalMemory((int)(memElem.getl("freeBytes") / 1024L));
        }
        this.fireHostPropertiesChanged(null);
    }
}

