/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.nre.security.NullAlgorithmBundle;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.nre.security.SecretChars;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.AbortFileTransactionMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.StartPBETransactionMessage;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XElem;

public class DaemonClientEncodingInfo
extends PBEEncodingInfo
implements AutoCloseable {
    private final String transactionId;
    private final BDaemonSession session;

    private DaemonClientEncodingInfo(XElem elem, BDaemonSession session) throws IOException {
        super(elem.get("encodingValidator"), elem.get("encodingSalt"), elem.geti("encodingIterationCount"));
        this.transactionId = elem.get("transactionId");
        this.session = session;
    }

    protected DaemonClientEncodingInfo(BDaemonSession session, String transactionId) throws IOException {
        super((CryptographicAlgorithmBundle)NullAlgorithmBundle.getInstance());
        this.session = session;
        this.transactionId = transactionId;
    }

    /*
     * Exception decompiling
     */
    public static DaemonClientEncodingInfo make(BDaemonSession session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static DaemonClientEncodingInfo make(BDaemonSession session, PBEEncodingKey encodingKey) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static FileTransferMessage makeMessage(BDaemonSession session, PBEEncodingKey key) throws Exception {
        Objects.requireNonNull(session);
        Objects.requireNonNull(key);
        FileTransferMessage result = new FileTransferMessage(session.getFileSpace());
        DaemonClientEncodingInfo.makeMessageInitializer(session, Optional.of(key), Optional.empty()).accept(result);
        return result;
    }

    public static Consumer<FileTransferMessage> makeMessageInitializer(BDaemonSession session, Optional<PBEEncodingInfo> encodingInfoParam, Optional<SecretChars> passPhrase) throws Exception {
        Objects.requireNonNull(session);
        Objects.requireNonNull(encodingInfoParam);
        Objects.requireNonNull(passPhrase);
        if (encodingInfoParam.isPresent()) {
            if (encodingInfoParam.get() instanceof PBEEncodingKey || passPhrase.isPresent()) {
                PBEEncodingKey encodingKey = encodingInfoParam.get() instanceof PBEEncodingKey ? (PBEEncodingKey)((PBEEncodingKey)encodingInfoParam.get()).newCopy() : encodingInfoParam.get().makePBEKey(passPhrase.get());
                StartPBETransactionMessage startTransaction = new StartPBETransactionMessage(encodingKey, true);
                String errorText = session.getErrorText(startTransaction);
                if (errorText != null) {
                    startTransaction.close();
                    throw new BajaRuntimeException(errorText);
                }
                return startTransaction::initializeMessage;
            }
            return fileTransferMessage -> fileTransferMessage.setPBEEncodingInfo((PBEEncodingInfo)encodingInfoParam.get());
        }
        if (passPhrase.isPresent()) {
            try (PBEEncodingKey encodingKey = new PBEEncodingKey(passPhrase.get());){
                StartPBETransactionMessage startTransaction = new StartPBETransactionMessage(encodingKey, true);
                String errorText = session.getErrorText(startTransaction);
                if (errorText != null) {
                    startTransaction.close();
                    throw new BajaRuntimeException(errorText);
                }
                Consumer<FileTransferMessage> consumer = startTransaction::initializeMessage;
                return consumer;
            }
        }
        return fileTransferMessage -> {};
    }

    @Override
    public void close() {
        try {
            this.session.sendMessage(new AbortFileTransactionMessage(this.transactionId));
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public String getTransactionId() {
        return this.transactionId;
    }
}

