/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.baja.file.BIFile;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.platform.InstallOperation;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.Version;

public class PlatformInstallOperation
extends InstallOperation {
    final Map<String, Version> installModuleVersions = new HashMap<String, Version>();
    final List<BDistribution> installDists = new ArrayList<BDistribution>();
    final Set<String> uninstallModuleNames = new HashSet<String>();
    Set<RuntimeProfile> enabledRuntimeProfiles = null;
    boolean ignoreTcpIpChanges = false;
    boolean ignoreAuthChanges = false;

    @Override
    public void setIgnoreTcpIpChanges(boolean value) {
        this.ignoreTcpIpChanges = value;
    }

    @Override
    public void setIgnoreAuthChanges(boolean value) {
        this.ignoreAuthChanges = value;
    }

    @Override
    public void installModule(String moduleName, Version version) {
        Objects.requireNonNull(moduleName);
        if (version == null) {
            this.installModuleVersions.put(moduleName, Version.NULL);
        } else {
            this.installModuleVersions.put(moduleName, version);
        }
    }

    @Override
    public void installDistribution(BIFile distFile) throws Exception {
        Objects.requireNonNull(distFile);
        if (!"dist".equals(distFile.getExtension())) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.notDistFile", new Object[]{distFile.getFilePath().getBody()});
        }
        BDistribution dist = new BDistribution(distFile);
        this.installDists.add(dist);
    }

    @Override
    public void installDistribution(String distName, Version version) {
        Objects.requireNonNull(distName);
        if (version == null) {
            version = Version.NULL;
        }
        try {
            BInstallable dist = LocalInstallableRegistry.getInstance().findInstallable(distName, version, BDistribution.TYPE, null);
            if (dist == null) {
                throw new LocalizableRuntimeException("platform", "PlatformInstallManager.softwareNotFound", new Object[]{distName, version});
            }
            this.installDists.add((BDistribution)dist);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public void uninstallModule(String moduleName) {
        Objects.requireNonNull(moduleName);
        this.uninstallModuleNames.add(moduleName);
    }

    @Override
    public void updateEnabledRuntimeProfiles(Set<RuntimeProfile> enabledRuntimeProfiles) {
        if (enabledRuntimeProfiles == null) {
            this.enabledRuntimeProfiles = null;
        } else {
            this.enabledRuntimeProfiles = new HashSet<RuntimeProfile>(enabledRuntimeProfiles);
            if (this.enabledRuntimeProfiles.contains(RuntimeProfile.ux) != this.enabledRuntimeProfiles.contains(RuntimeProfile.wb)) {
                this.enabledRuntimeProfiles.add(RuntimeProfile.ux);
                this.enabledRuntimeProfiles.add(RuntimeProfile.wb);
            }
        }
    }
}

