/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.IPlatformOperationListener;

public class PlatformOperationListener
implements DaemonSessionTaskListener,
ICancelHint {
    private IPlatformOperationListener listener;
    private String lastStatus = null;

    public PlatformOperationListener(IPlatformOperationListener listener) {
        this.listener = listener;
    }

    @Override
    public void taskStarted(DaemonSessionTask task) {
        this.taskUpdated(task);
    }

    @Override
    public void taskUpdated(DaemonSessionTask task) {
        if (this.listener == null) {
            return;
        }
        String updatedStatus = task.getMessage();
        if (updatedStatus.equals(this.lastStatus)) {
            return;
        }
        this.lastStatus = updatedStatus;
        this.listener.notifyStatus(updatedStatus);
    }

    @Override
    public void taskFinished(DaemonSessionTask task) {
        this.taskUpdated(task);
    }

    @Override
    public boolean isCancelEnabled() {
        return this.listener != null;
    }

    @Override
    public boolean isCanceled() {
        return this.listener != null && this.listener.isCanceled();
    }

    public void notifyStatus(String status) {
        this.listener.notifyStatus(status);
    }
}

