/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Clock;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
public class BDaemonDirectoryStore
extends BAbstractFileStore {
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonDirectoryStore.class);
    private final String fileUri;
    private final boolean recurseDir;
    private final boolean sendCrc;
    private final boolean sendLocalPath;
    private final StoreCache cache;
    private final FilePath altPath;
    private XElem element;
    private List<BIFileStore> children = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BDaemonDirectoryStore(BDaemonFileSpace fileSpace, FilePath path, XElem element, boolean recurseDir, boolean sendCrc, boolean sendLocalPath, StoreCache cache) {
        super((BFileSpace)fileSpace, path);
        this.fileUri = fileSpace.filePathToUri(path);
        this.element = element;
        this.recurseDir = recurseDir;
        this.sendCrc = sendCrc;
        this.sendLocalPath = sendLocalPath;
        this.cache = cache;
        this.altPath = fileSpace.getAltPath(path);
        if (recurseDir) {
            this.getChildren(BCacheAccessPolicy.lazyFetch, true, sendCrc, sendLocalPath);
        }
    }

    public static BDaemonDirectoryStore make(BDaemonFileSpace fileSpace, FilePath path) throws ConnectException, SecurityException {
        return BDaemonDirectoryStore.make(fileSpace, path, false, false, true, null);
    }

    public static BDaemonDirectoryStore make(BDaemonFileSpace fileSpace, FilePath path, StoreCache cache) throws ConnectException, SecurityException {
        return BDaemonDirectoryStore.make(fileSpace, path, false, false, true, cache);
    }

    public static BDaemonDirectoryStore make(BDaemonFileSpace fileSpace, FilePath path, boolean recurseDir, boolean sendCrc, boolean sendLocalPath, StoreCache cache) throws ConnectException, SecurityException {
        return BDaemonDirectoryStore.make(fileSpace, path, recurseDir, sendCrc, sendLocalPath, cache, BDaemonSession.DEFAULT_TIMEOUT);
    }

    public static BDaemonDirectoryStore make(BDaemonFileSpace fileSpace, FilePath path, boolean recurseDir, boolean sendCrc, boolean sendLocalPath, StoreCache cache, int timeout) throws ConnectException, SecurityException {
        Logger log;
        XElem dirElem;
        FilePath altPath = fileSpace.getAltPath(path);
        if (cache != null) {
            int cacheStatus = cache.getCacheStatus(path);
            if (cacheStatus == 1) {
                return null;
            }
            if (cacheStatus == 0) {
                return (BDaemonDirectoryStore)cache.getStore(path);
            }
        }
        long t0 = Clock.ticks();
        InputStream stream = fileSpace.getDaemonSession().getInputStream((DaemonMessage)new GetDirectoryMessage(path, recurseDir, sendCrc, sendLocalPath, fileSpace), timeout);
        if (stream == null) {
            Logger log2;
            if (cache != null) {
                cache.cacheNotFound(path);
                if (altPath != null) {
                    cache.cacheNotFound(altPath);
                }
            }
            if ((log2 = Logger.getLogger("platform.daemonTuning")).isLoggable(Level.FINE)) {
                log2.fine("parsed " + path.getBody() + " " + (Clock.ticks() - t0) + "ms");
            }
            return null;
        }
        try {
            dirElem = XParser.make((InputStream)stream).parse();
        }
        catch (Exception e) {
            Logger log3 = Logger.getLogger("platform.daemonTuning");
            if (log3.isLoggable(Level.FINE)) {
                log3.fine("parse failed " + path.getBody() + " " + (Clock.ticks() - t0) + "ms");
            }
            throw new LocalizableRuntimeException("platform", "RemoteDirectory.exception.contentParse", new Object[]{path.getBody()}, (Throwable)e);
        }
        BDaemonDirectoryStore result = new BDaemonDirectoryStore(fileSpace, path, (XElem)(recurseDir ? dirElem : null), recurseDir, sendCrc, sendLocalPath, cache);
        if (cache != null) {
            cache.cacheResult((BIFileStore)result);
            if (altPath != null) {
                cache.cacheResult((BIFileStore)new BDaemonDirectoryStore(fileSpace, altPath, (XElem)(recurseDir ? dirElem : null), recurseDir, sendCrc, sendLocalPath, cache));
            }
            if (recurseDir) {
                cache.cacheCompleted(path);
                if (altPath != null) {
                    cache.cacheCompleted(altPath);
                }
            }
        }
        if ((log = Logger.getLogger("platform.daemonTuning")).isLoggable(Level.FINE)) {
            log.fine("parsed " + path.getBody() + " " + (Clock.ticks() - t0) + "ms");
        }
        return result;
    }

    public BDaemonFileSpace getDaemonFileSpace() {
        return (BDaemonFileSpace)this.getFileSpace();
    }

    public void reset() {
        this.children = null;
        this.element = null;
        if (this.cache != null) {
            this.cache.clear(this.getFilePath());
            if (this.getAltPath() != null) {
                this.cache.clear(this.getAltPath());
            }
        }
    }

    public boolean isReadonly() {
        return true;
    }

    public boolean isDirectory() {
        return true;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public String getLocalPath() {
        if (this.element == null) {
            this.getChildren(BCacheAccessPolicy.lazyFetch);
        }
        return this.element.get("path", null);
    }

    public boolean copyToLocalHost() throws ConnectException, AuthenticationException {
        return this.copyToLocalHost(this.getFilePath(), null);
    }

    public boolean copyToLocalHost(FilePath destPath) throws ConnectException, AuthenticationException {
        return this.copyToLocalHost(destPath, null);
    }

    public boolean copyToLocalHost(FilePath destPath, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        if (!this.getFilePath().isSysHomeAbsolute() && !this.getFilePath().isUserHomeAbsolute()) {
            throw new IllegalStateException("Only system and user absolute files can be copied to local host");
        }
        for (BIFileStore kid : this.listChildren()) {
            BDaemonFileStore file;
            BDaemonDirectoryStore dir;
            if (!(kid instanceof BDaemonDirectoryStore ? !(dir = (BDaemonDirectoryStore)kid).copyToLocalHost(destPath.merge(dir.getFileName()), listener) : !(file = (BDaemonFileStore)kid).copyToLocalHost(destPath.merge(file.getFileName()), listener))) continue;
            return false;
        }
        return true;
    }

    public FilePath getAltPath() {
        return this.altPath;
    }

    public BDaemonSession getDaemonSession() {
        return ((BDaemonFileSpace)this.getFileSpace()).getDaemonSession();
    }

    public BIFileStore getChild(String childName) {
        return this.getChild(childName, BCacheAccessPolicy.lazyFetch);
    }

    public BIFileStore getChild(String childName, BCacheAccessPolicy cachePolicy) {
        if (this.getChildren(cachePolicy) == null) {
            return null;
        }
        for (BIFileStore child : this.children) {
            if (!child.getFileName().equals(childName)) continue;
            return child;
        }
        if (this.cache != null) {
            this.cache.cacheNotFound(this.getFilePath().merge(childName));
            if (this.getAltPath() != null) {
                this.cache.cacheNotFound(this.getAltPath().merge(childName));
            }
        }
        return null;
    }

    public List<BIFileStore> listChildren() {
        return this.listChildren(BCacheAccessPolicy.lazyFetch, this.recurseDir, this.sendCrc, this.sendLocalPath);
    }

    public Array<BIFileStore> getChildren() {
        return this.getChildren(BCacheAccessPolicy.lazyFetch, this.recurseDir, this.sendCrc, this.sendLocalPath);
    }

    public List<BIFileStore> listChildren(BCacheAccessPolicy cachePolicy) {
        return this.listChildren(cachePolicy, this.recurseDir, this.sendCrc, this.sendLocalPath);
    }

    public Array<BIFileStore> getChildren(BCacheAccessPolicy cachePolicy) {
        return this.getChildren(cachePolicy, this.recurseDir, this.sendCrc, this.sendLocalPath);
    }

    public Array<BIFileStore> getChildren(BCacheAccessPolicy cachePolicy, boolean recurseKids, boolean sendKidCrc, boolean sendKidLocalPath) {
        List<BIFileStore> resultList = this.listChildren(cachePolicy, recurseKids, sendKidCrc, sendKidLocalPath);
        return resultList == null ? null : new Array(BIFileStore.class, resultList);
    }

    public List<BIFileStore> listChildren(BCacheAccessPolicy cachePolicy, boolean recurseKids, boolean sendKidCrc, boolean sendKidLocalPath) {
        long t0 = Clock.ticks();
        if (cachePolicy == BCacheAccessPolicy.forceFetch || cachePolicy == BCacheAccessPolicy.lazyFetch && this.element == null) {
            try {
                this.element = XParser.make((InputStream)this.getDaemonSession().getInputStream(new GetDirectoryMessage(this.getFilePath(), recurseKids, sendKidCrc, sendKidLocalPath, this.getDaemonFileSpace()))).parse();
                Logger log = Logger.getLogger("platform.daemonTuning");
                if (log.isLoggable(Level.FINE)) {
                    log.fine("parsed " + this.getFilePath().getBody() + " " + (Clock.ticks() - t0) + "ms");
                }
            }
            catch (Exception e) {
                Logger log = Logger.getLogger("platform.daemonTuning");
                if (log.isLoggable(Level.FINE)) {
                    log.fine("parse failed " + this.getFilePath().getBody() + " " + (Clock.ticks() - t0) + "ms");
                }
                throw new LocalizableRuntimeException("platform", "RemoteDirectory.exception.contentParse", new Object[]{this.getFileUri()}, (Throwable)e);
            }
            this.children = null;
        }
        if (this.children == null && cachePolicy != BCacheAccessPolicy.cacheOnly) {
            this.children = new ArrayList<BIFileStore>();
            for (XElem kid : this.element.elems()) {
                Logger log;
                BAbstractFileStore newKid;
                if (kid.name().equals("file")) {
                    try {
                        newKid = new BDaemonFileStore(this.getDaemonFileSpace(), this.getFilePath().merge(kid.get("name")), kid);
                        if (this.cache != null) {
                            this.cache.cacheResult((BIFileStore)newKid);
                            if (this.getAltPath() != null) {
                                this.cache.cacheResult((BIFileStore)new BDaemonFileStore(this.getDaemonFileSpace(), this.getAltPath().merge(kid.get("name")), kid));
                            }
                        }
                        this.children.add((BIFileStore)newKid);
                    }
                    catch (SyntaxException e) {
                        log = Logger.getLogger("platform.daemonTuning");
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("ignoring illegal child " + kid.get("name") + " of " + this.getFilePath());
                    }
                    continue;
                }
                if (!kid.name().equals("directory")) continue;
                try {
                    newKid = new BDaemonDirectoryStore(this.getDaemonFileSpace(), this.getFilePath().merge(kid.get("name")), (XElem)(recurseKids ? kid : null), recurseKids, sendKidCrc, sendKidLocalPath, this.cache);
                    if (this.cache != null) {
                        this.cache.cacheResult((BIFileStore)newKid);
                        if (this.getAltPath() != null) {
                            this.cache.cacheResult((BIFileStore)new BDaemonDirectoryStore(this.getDaemonFileSpace(), this.getAltPath().merge(kid.get("name")), (XElem)(recurseKids ? kid : null), recurseKids, sendKidCrc, sendKidLocalPath, this.cache));
                        }
                    }
                    this.children.add((BIFileStore)newKid);
                }
                catch (SyntaxException e) {
                    log = Logger.getLogger("platform.daemonTuning");
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("ignoring illegal child " + kid.get("name") + " of " + this.getFilePath());
                }
            }
            if (this.cache != null) {
                this.cache.cacheCompleted(this.getFilePath());
                if (this.getAltPath() != null) {
                    this.cache.cacheCompleted(this.getAltPath());
                }
            }
        }
        return this.children;
    }
}

