/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.message.FileTransferMessage;
import java.util.Iterator;
import java.util.TreeMap;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;

public class DirectoryClean {
    private TreeMap<String, Node> sysHomeAbsRootsByName = new TreeMap();
    private TreeMap<String, Node> userHomeAbsRootsByName = new TreeMap();
    private TreeMap<String, Node> localAbsRootsByName = new TreeMap();
    private static final int UNKNOWN = 0;
    private static final int KEEP_SOME = 1;
    private static final int KEEP_ALL = 2;
    private static final int CLEAN_SOME = 16;
    private static final int CLEAN_ALL = 32;
    private static final int CASCADE_PARENT = 1;
    private static final int CASCADE_CHILD = 16;
    private static final int CASCADE_ANY = 17;

    public void clean(BIFileStore store) {
        if (store == null) {
            return;
        }
        FilePath path = this.normalizePath(store.getFilePath());
        Node node = this.makeNode(path);
        node.setStore(store);
        node.transition(32);
    }

    public void keep(FilePath path) {
        this.makeNode(this.normalizePath(path)).transition(2);
    }

    public void addTransferElements(FileTransferMessage message) {
        Iterator<Node> i = this.sysHomeAbsRootsByName.values().iterator();
        while (i.hasNext()) {
            i.next().addTransferElements(message);
        }
        i = this.userHomeAbsRootsByName.values().iterator();
        while (i.hasNext()) {
            i.next().addTransferElements(message);
        }
        i = this.localAbsRootsByName.values().iterator();
        while (i.hasNext()) {
            i.next().addTransferElements(message);
        }
    }

    public void dump() {
        Iterator<Node> i = this.sysHomeAbsRootsByName.values().iterator();
        while (i.hasNext()) {
            i.next().dump("!");
        }
        i = this.userHomeAbsRootsByName.values().iterator();
        while (i.hasNext()) {
            i.next().dump("~");
        }
        i = this.localAbsRootsByName.values().iterator();
        while (i.hasNext()) {
            i.next().dump("/");
        }
    }

    private FilePath normalizePath(FilePath value) {
        if (value == null || value.isSysHomeAbsolute()) {
            return value;
        }
        if (value.isLocalAbsolute()) {
            if (value.depth() == 0 || !value.nameAt(0).equals("niagara") && !value.nameAt(0).equals("niagarad")) {
                return value;
            }
            if (value.nameAt(0).equals("niagara")) {
                FilePath result = new FilePath("!");
                for (int i = 1; i < value.depth(); ++i) {
                    result = result.merge(value.nameAt(i));
                }
                return result;
            }
            FilePath result = new FilePath("~");
            for (int i = 1; i < value.depth(); ++i) {
                result = result.merge(value.nameAt(i));
            }
            return result;
        }
        throw new IllegalArgumentException("path must be sys home or local absolute");
    }

    private Node makeNode(FilePath path) {
        if (path.depth() == 0) {
            throw new IllegalArgumentException("root path");
        }
        TreeMap<String, Node> rootsByName = null;
        if (path.isSysHomeAbsolute()) {
            rootsByName = this.sysHomeAbsRootsByName;
        } else if (path.isUserHomeAbsolute()) {
            rootsByName = this.userHomeAbsRootsByName;
        } else if (path.isLocalAbsolute()) {
            rootsByName = this.localAbsRootsByName;
        } else {
            throw new IllegalArgumentException("Path must be sys home or local absolute");
        }
        Node node = rootsByName.get(path.nameAt(0));
        if (node == null) {
            node = new Node(null, path.nameAt(0));
            rootsByName.put(path.nameAt(0), node);
        }
        for (int i = 1; i < path.depth(); ++i) {
            node = node.makeChild(path.nameAt(i));
        }
        return node;
    }

    private static class Node {
        private BIFileStore store;
        private String name;
        private Node parent;
        private TreeMap<String, Node> childByName = new TreeMap();
        private int status = 0;

        public Node(Node parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public Node makeChild(String childName) {
            Node result = this.childByName.get(childName);
            if (result == null) {
                result = new Node(this, childName);
                this.childByName.put(childName, result);
            }
            return result;
        }

        public void setStore(BIFileStore store) {
            if (this.store == null) {
                this.store = store;
                if (store instanceof BDaemonDirectoryStore) {
                    Array<BIFileStore> kids = ((BDaemonDirectoryStore)store).getChildren(BCacheAccessPolicy.lazyFetch, true, true, false);
                    for (int i = 0; i < kids.size(); ++i) {
                        BIFileStore kidStore = (BIFileStore)kids.get(i);
                        Node child = this.makeChild(kidStore.getFilePath().getName());
                        child.setStore(kidStore);
                    }
                }
            }
        }

        public void addTransferElements(FileTransferMessage message) {
            if (this.status == 32) {
                message.addDelete(this.store.getFilePath());
            } else if ((this.status & 0x10) > 0) {
                Iterator<Node> i = this.childByName.values().iterator();
                while (i.hasNext()) {
                    i.next().addTransferElements(message);
                }
            }
        }

        public void dump(String prefix) {
            System.out.print(prefix);
            System.out.print(this.name);
            System.out.print("  ");
            if (this.status == 0) {
                System.out.print("unknown ");
            }
            if ((this.status & 1) > 0) {
                System.out.print("keepSome ");
            }
            if ((this.status & 2) > 0) {
                System.out.print("keepAll ");
            }
            if ((this.status & 0x10) > 0) {
                System.out.print("cleanSome ");
            }
            if ((this.status & 0x20) > 0) {
                System.out.print("cleanAll ");
            }
            System.out.println();
            Iterator<Node> i = this.childByName.values().iterator();
            while (i.hasNext()) {
                i.next().dump(prefix + this.name + '/');
            }
        }

        public void transition(int value) {
            this.transition(value, 17);
        }

        private void transition(int value, int cascadePolicy) {
            if (value == this.status || this.status == 2) {
                return;
            }
            if (value == 0) {
                throw new IllegalArgumentException("Can't transition to unknown");
            }
            if (value == 2) {
                this.status = 2;
                this.transitionParent(1, cascadePolicy);
                this.transitionChildren(2, cascadePolicy);
            } else if (value == 1) {
                if (this.status == 0) {
                    this.status = 1;
                    this.transitionParent(1, cascadePolicy);
                } else if (this.status == 32 || this.status == 16) {
                    this.status = 17;
                    this.transitionParent(1, cascadePolicy);
                }
            } else if (value == 16) {
                if (this.status == 0) {
                    this.status = 16;
                    this.transitionParent(16, cascadePolicy);
                } else if (this.status == 1) {
                    this.status = 17;
                    this.transitionParent(16, cascadePolicy);
                }
            } else if (value == 32) {
                if (this.status == 0) {
                    this.status = 32;
                    this.transitionChildren(32, cascadePolicy);
                    this.transitionParent(16, cascadePolicy);
                } else if ((this.status & 1) > 0) {
                    this.status |= 0x10;
                    this.transitionChildren(32, cascadePolicy);
                    this.transitionParent(16, cascadePolicy);
                } else if (this.status == 16) {
                    this.transitionChildren(32, cascadePolicy);
                }
            }
        }

        private void transitionParent(int value, int cascadePolicy) {
            if ((cascadePolicy & 1) > 0 && this.parent != null) {
                this.parent.transition(value, cascadePolicy & 0xFFFFFFEF);
            }
        }

        private void transitionChildren(int value, int cascadePolicy) {
            if ((cascadePolicy & 0x10) > 0) {
                Iterator<Node> i = this.childByName.values().iterator();
                while (i.hasNext()) {
                    i.next().transition(value, cascadePolicy & 0xFFFFFFFE);
                }
            }
        }
    }
}

