/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import javax.baja.file.FilePath;

public class GetJarContentMessage
extends DaemonMessage {
    private final StringBuilder path;

    public GetJarContentMessage(FilePath filePath, FilePath entryPath) {
        int i;
        if (!filePath.isSysHomeAbsolute() && !filePath.isUserHomeAbsolute()) {
            throw new IllegalArgumentException("Cannot retrieve jar contents: filePath not system or user home absolute '" + filePath.getBody() + "'");
        }
        this.path = new StringBuilder("/jars" + (filePath.isSysHomeAbsolute() ? "/niagara" : "/niagara_user"));
        for (i = 0; i < filePath.depth(); ++i) {
            this.path.append('/');
            this.path.append(HttpUtil.encodeUrl((String)filePath.nameAt(i)));
        }
        for (i = 0; i < entryPath.depth(); ++i) {
            this.path.append('/');
            this.path.append(HttpUtil.encodeUrl((String)entryPath.nameAt(i)));
        }
    }

    @Override
    public String getMessageString() {
        return this.path.toString();
    }
}

