/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.message.EncryptableXmlResponseMessage;
import java.security.AccessController;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.security.BPassword;

public class UpdateFileAuthenticationMessage
extends EncryptableXmlResponseMessage {
    String authenticationScheme;
    String adminUser;
    String adminPasswordEncoding;

    public UpdateFileAuthenticationMessage(String authenticationScheme, String adminUser, BPassword adminPassword, SharedSecretKey sharedSecretKey) {
        this.sharedSecretKey = sharedSecretKey;
        this.adminUser = adminUser;
        this.adminPasswordEncoding = this.prepareMessage(AccessController.doPrivileged(() -> ((BPassword)adminPassword).getValue()));
        this.authenticationScheme = authenticationScheme;
    }

    @Override
    public String getMessageString() {
        if (this.sharedSecretKey == null) {
            throw new IllegalStateException("Attempting to generate message string without a shared key for encryption");
        }
        StringBuilder buf = new StringBuilder("auth?update=true&authtype=");
        buf.append(HttpUtil.encodeUrl((String)this.authenticationScheme));
        buf.append("&user=");
        buf.append(HttpUtil.encodeUrl((String)this.adminUser));
        if (this.adminPasswordEncoding != null) {
            buf.append("&password=").append(this.adminPasswordEncoding);
            buf.append("&").append("sharedKeyName").append("=").append(this.sharedSecretKey.getName());
        }
        return buf.toString();
    }

    @Override
    public int getConnectionFlags() {
        return 16;
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

