/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.nre.security.Aes256PasswordEncoderUtil;
import com.tridium.platform.daemon.message.EncryptableXmlResponseMessage;
import com.tridium.platform.syslog.BSyslogSettings;
import java.net.URLEncoder;
import javax.baja.nre.security.SharedSecretKey;

public class UpdateSyslogConfigurationMessage
extends EncryptableXmlResponseMessage {
    private final StringBuilder message;

    public UpdateSyslogConfigurationMessage(BSyslogSettings settings, SharedSecretKey sharedSecretKey) throws Exception {
        this.setSharedKey(sharedSecretKey);
        this.message = new StringBuilder();
        this.message.append("syslog?update=true");
        this.message.append('&').append("enabled=").append(URLEncoder.encode(Boolean.toString(settings.getEnabled()), "UTF-8"));
        this.message.append('&').append("serverHost=").append(URLEncoder.encode(settings.getServerHost(), "UTF-8"));
        this.message.append('&').append("serverPort=").append(URLEncoder.encode(Integer.toString(settings.getServerPort()), "UTF-8"));
        this.message.append('&').append("messageType=").append(URLEncoder.encode(settings.getMessageType().getTag(), "UTF-8"));
        this.message.append('&').append("transportProtocol=").append(URLEncoder.encode(settings.getTransportProtocol().getTag(), "UTF-8"));
        this.message.append('&').append("clientAlias=").append(URLEncoder.encode(settings.getClientAliasAndPassword().getAlias(), "UTF-8"));
        if (settings.getClientPasswordModified()) {
            if (!settings.getClientAliasAndPassword().getPassword().isDefault()) {
                this.message.append('&').append("clientPassword=").append(URLEncoder.encode(this.prepareMessage(settings.getClientAliasAndPassword().getPassword().getValue()), "UTF-8"));
            } else {
                this.message.append('&').append("clientPassword=").append(URLEncoder.encode(this.prepareMessage(Aes256PasswordEncoderUtil.DEFAULT_PASSWORD), "UTF-8"));
            }
        }
        this.message.append('&').append("platformLogEnabled=").append(URLEncoder.encode(Boolean.toString(settings.getPlatformLogEnabled()), "UTF-8"));
        this.message.append('&').append("stationLogEnabled=").append(URLEncoder.encode(Boolean.toString(settings.getStationLogEnabled()), "UTF-8"));
        this.message.append('&').append("logLevelFilter=").append(URLEncoder.encode(settings.getLogLevelFilter().getTag(), "UTF-8"));
        this.message.append('&').append("stationAuditEnabled=").append(URLEncoder.encode(Boolean.toString(settings.getStationAuditEnabled()), "UTF-8"));
        this.message.append('&').append("securityAuditEnabled=").append(URLEncoder.encode(Boolean.toString(settings.getSecurityAuditEnabled()), "UTF-8"));
        this.message.append('&').append("facility=").append(URLEncoder.encode(settings.getFacility().getTag(), "UTF-8"));
        this.message.append('&').append("queueSize=").append(URLEncoder.encode(Integer.toString(settings.getQueueSize()), "UTF-8"));
        this.message.append("&").append("sharedKeyName").append("=");
        this.message.append(URLEncoder.encode(sharedSecretKey.getName(), "UTF-8"));
    }

    @Override
    public String getMessageString() {
        return this.message.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

