/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.task;

import com.tridium.platform.daemon.task.DaemonSessionTask;
import javax.baja.platform.ICancelHint;
import javax.baja.util.Lexicon;

public class CancelableDaemonSessionTask
extends DaemonSessionTask
implements ICancelHint {
    private String cancelLabel = null;
    private boolean canceled = false;
    private ICancelHint cancelHint;
    private boolean allowCancel = true;

    public CancelableDaemonSessionTask(Lexicon lex, String titleKey, String messageKey) {
        this(lex, titleKey, messageKey, new Object[0], -1, null);
    }

    public CancelableDaemonSessionTask(Lexicon lex, String titleKey, String messageKey, Object[] messageArgs) {
        this(lex, titleKey, messageKey, messageArgs, -1, null);
    }

    public CancelableDaemonSessionTask(Lexicon lex, String titleKey, String messageKey, int total) {
        this(lex, titleKey, messageKey, new Object[0], total, null);
    }

    public CancelableDaemonSessionTask(Lexicon lex, String titleKey, String messageKey, Object[] messageArgs, int total) {
        this(lex, titleKey, messageKey, messageArgs, total, null);
    }

    public CancelableDaemonSessionTask(Lexicon lex, String titleKey, String messageKey, ICancelHint cancelHint) {
        this(lex, titleKey, messageKey, new Object[0], -1, cancelHint);
    }

    public CancelableDaemonSessionTask(Lexicon lex, String titleKey, String messageKey, Object[] messageArgs, ICancelHint cancelHint) {
        this(lex, titleKey, messageKey, messageArgs, -1, cancelHint);
    }

    public CancelableDaemonSessionTask(Lexicon lex, String titleKey, String messageKey, int total, ICancelHint cancelHint) {
        this(lex, titleKey, messageKey, new Object[0], total, cancelHint);
    }

    public CancelableDaemonSessionTask(Lexicon lex, String titleKey, String messageKey, Object[] messageArgs, int total, ICancelHint cancelHint) {
        super(lex, titleKey, messageKey, messageArgs, total);
        this.cancelHint = cancelHint;
    }

    public synchronized void cancel() {
        if (this.allowCancel) {
            this.canceled = true;
        }
    }

    public synchronized void setIsCancelEnabled(boolean value) {
        this.allowCancel = value;
    }

    public synchronized boolean isCancelEnabled() {
        return this.allowCancel;
    }

    @Override
    public synchronized boolean isCanceled() {
        return this.allowCancel && (this.canceled || this.cancelHint != null && this.cancelHint.isCanceled());
    }

    public String getCancelLabel(String defaultValue) {
        return this.cancelLabel == null ? defaultValue : this.cancelLabel;
    }

    public void setCancelLabel(String value) {
        this.cancelLabel = value;
    }
}

