/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    private FoxCircuit circuit;
    private byte[] buf = new byte[Fox.circuitChunkSize - 256];
    private int n;

    public ChunkedOutputStream(FoxCircuit circuit) {
        this.circuit = circuit;
    }

    @Override
    public void write(int b) throws IOException {
        this.buf[this.n++] = (byte)(0xFF & b);
        if (this.n >= this.buf.length) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.n > 0) {
            FoxMessage msg = new FoxMessage();
            msg.add("type", "chunk");
            msg.add("chunk", this.buf, this.n);
            this.writeMessage(msg);
            this.n = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        FoxMessage msg = new FoxMessage();
        msg.add("type", "chunk");
        msg.add("chunk", this.buf, 0);
        this.writeMessage(msg);
        FoxMessage reply = this.readMessage();
        this.circuit.close();
        String err = reply.getString("error", null);
        if (err != null) {
            throw new IOException(err);
        }
    }

    private FoxMessage readMessage() throws IOException {
        try {
            return this.circuit.readMessage();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    private void writeMessage(FoxMessage msg) throws IOException {
        try {
            this.circuit.writeMessage(msg);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }
}

