/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.nre.subscription.EntitlementApi;
import com.tridium.nre.subscription.EntitlementStatusListener;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.fox.BLicenseChannel;
import com.tridium.sys.license.Brand;
import com.tridium.sys.license.subscription.SubscriptionLicenseManager;
import java.util.HashMap;
import javax.baja.license.LicenseException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="brand", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="entitlementAlarmSupport", type="BPlatformAlarmSupport", defaultValue="initEntitlementAlarmSupport()"), @NiagaraProperty(name="entitlementAlarmProxy", type="BPlatformAlarmProxy", defaultValue="new BPlatformAlarmProxy()", flags=6)})
@NiagaraAction(name="ackAlarm", parameterType="BPlatformServiceAlarmRecord", defaultValue="new BPlatformServiceAlarmRecord()", returnType="BBoolean", flags=4)
public final class BLicensePlatformService
extends BPlatformService
implements BIAlarmablePlatformService,
EntitlementStatusListener {
    @Generated
    public static final Property brand = BLicensePlatformService.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property entitlementAlarmSupport = BLicensePlatformService.newProperty((int)0, (BValue)BLicensePlatformService.initEntitlementAlarmSupport(), null);
    @Generated
    public static final Property entitlementAlarmProxy = BLicensePlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    @Generated
    public static final Action ackAlarm = BLicensePlatformService.newAction((int)4, (BValue)new BPlatformServiceAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLicensePlatformService.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/licenseService.png");

    @Generated
    public String getBrand() {
        return this.getString(brand);
    }

    @Generated
    public void setBrand(String v) {
        this.setString(brand, v, null);
    }

    @Generated
    public BPlatformAlarmSupport getEntitlementAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(entitlementAlarmSupport);
    }

    @Generated
    public void setEntitlementAlarmSupport(BPlatformAlarmSupport v) {
        this.set(entitlementAlarmSupport, (BValue)v, null);
    }

    @Generated
    public BPlatformAlarmProxy getEntitlementAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(entitlementAlarmProxy);
    }

    @Generated
    public void setEntitlementAlarmProxy(BPlatformAlarmProxy v) {
        this.set(entitlementAlarmProxy, (BValue)v, null);
    }

    @Override
    @Generated
    public BBoolean ackAlarm(BPlatformServiceAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLicensePlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("LicensePlatformService.description"));
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public boolean isValidPlatform() {
        return true;
    }

    @Override
    public int getSlotFlags() {
        return 0;
    }

    @Override
    public void serviceStarted() throws Exception {
        super.serviceStarted();
        try {
            this.setBrand(Brand.getBrandId());
        }
        catch (LicenseException le) {
            this.setBrand("");
        }
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("license") == null) {
            registry.add("license", (BValue)new BLicenseChannel());
        }
        if (this.isSubscriptionPlatform()) {
            this.setFlags((Slot)entitlementAlarmSupport, this.getFlags((Slot)entitlementAlarmSupport) & 0xFFFFFFFB);
            SubscriptionLicenseManager licenseManager = (SubscriptionLicenseManager)Sys.getLicenseManager();
            licenseManager.addEntitlementStatusListener((EntitlementStatusListener)this);
            this.getEntitlementAlarmProxy().setAlarmSupport(this.getEntitlementAlarmSupport());
        } else {
            this.setFlags((Slot)entitlementAlarmSupport, this.getFlags((Slot)entitlementAlarmSupport) | 4);
        }
    }

    @Override
    public void serviceStopped() throws Exception {
        BFoxChannelRegistry registry;
        super.serviceStopped();
        if (this.isSubscriptionPlatform()) {
            SubscriptionLicenseManager licenseManager = (SubscriptionLicenseManager)Sys.getLicenseManager();
            licenseManager.removeEntitlementStatusListener((EntitlementStatusListener)this);
        }
        if ((registry = BFoxChannelRegistry.getPrototype()).get("license") != null) {
            registry.remove("license");
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isSubscriptionPlatform() {
        return Sys.getLicenseManager() instanceof SubscriptionLicenseManager;
    }

    @Override
    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getEntitlementAlarmProxy().addPlatformServiceAlarmListener(listener);
    }

    @Override
    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getEntitlementAlarmProxy().removePlatformServiceAlarmListener(listener);
    }

    @Override
    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord alarm) {
        throw new IllegalStateException();
    }

    public BBoolean doAckAlarm(BPlatformServiceAlarmRecord data) {
        throw new IllegalStateException();
    }

    public void entitlementCheckin(EntitlementApi.EntitlementStatus status) {
        if (status.isFailure()) {
            BPlatformServiceAlarmRecord alarm = this.getEntitlementAlarmSupport().makeNewOffnormalAlarm(BFacets.make((String)"failureCause", (String)status.getMessage()));
            this.getEntitlementAlarmProxy().firePlatformServiceAlarmEvent(alarm);
        } else if (status.isSuccess()) {
            BPlatformServiceAlarmRecord alarm = this.getEntitlementAlarmSupport().makeToNormal();
            this.getEntitlementAlarmProxy().firePlatformServiceAlarmEvent(alarm);
        }
    }

    private static BPlatformAlarmSupport initEntitlementAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setSourceName(BFormat.make((String)"%parent.displayName%"));
        pas.setToOffnormalText(BFormat.make((String)"%lexicon(platform:entitlementCheckinFailure)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platform:entitlementCheckinSuccess)%"));
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmType", BString.make((String)"license"));
        pas.setMetaData(BFacets.make(map));
        return pas;
    }
}

