/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.VendorLicense;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="licenseGenerated", type="long", defaultValue="Long.MIN_VALUE", flags=1), @NiagaraProperty(name="licenseExpires", type="long", defaultValue="Long.MIN_VALUE", flags=1), @NiagaraProperty(name="licenseSignatureString", type="String", defaultValue="", flags=1), @NiagaraProperty(name="licenseVersionString", type="String", defaultValue="", flags=1)})
public class BVendorLicenseSummary
extends BStruct {
    @Generated
    public static final Property licenseGenerated = BVendorLicenseSummary.newProperty((int)1, (long)Long.MIN_VALUE, null);
    @Generated
    public static final Property licenseExpires = BVendorLicenseSummary.newProperty((int)1, (long)Long.MIN_VALUE, null);
    @Generated
    public static final Property licenseSignatureString = BVendorLicenseSummary.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property licenseVersionString = BVendorLicenseSummary.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVendorLicenseSummary.class);

    @Generated
    public long getLicenseGenerated() {
        return this.getLong(licenseGenerated);
    }

    @Generated
    public void setLicenseGenerated(long v) {
        this.setLong(licenseGenerated, v, null);
    }

    @Generated
    public long getLicenseExpires() {
        return this.getLong(licenseExpires);
    }

    @Generated
    public void setLicenseExpires(long v) {
        this.setLong(licenseExpires, v, null);
    }

    @Generated
    public String getLicenseSignatureString() {
        return this.getString(licenseSignatureString);
    }

    @Generated
    public void setLicenseSignatureString(String v) {
        this.setString(licenseSignatureString, v, null);
    }

    @Generated
    public String getLicenseVersionString() {
        return this.getString(licenseVersionString);
    }

    @Generated
    public void setLicenseVersionString(String v) {
        this.setString(licenseVersionString, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVendorLicenseSummary() {
    }

    public BVendorLicenseSummary(long licenseGenerated, long licenseExpires, String licenseSignature) {
        this.setLicenseGenerated(licenseGenerated);
        this.setLicenseExpires(licenseExpires);
        this.setLicenseSignature(licenseSignature);
    }

    public BVendorLicenseSummary(long licenseGenerated, long licenseExpires, String licenseSignature, String licenseVersionString) {
        this.setLicenseGenerated(licenseGenerated);
        this.setLicenseExpires(licenseExpires);
        this.setLicenseSignature(licenseSignature);
        this.setLicenseVersionString(licenseVersionString);
    }

    public static BVendorLicenseSummary make(XElem xml) {
        String generatedString = xml.get("licenseGenerated", null);
        long licenseGenerated = generatedString == null ? Long.MIN_VALUE : LicenseUtil.parseDate((String)generatedString, (boolean)true);
        String expiresString = xml.get("licenseExpires", null);
        long licenseExpires = expiresString == null ? Long.MIN_VALUE : LicenseUtil.parseDate((String)expiresString, (boolean)false);
        XElem sigElem = xml.elem("licenseSignature");
        String licenseSignature = sigElem == null ? null : sigElem.string();
        return new BVendorLicenseSummary(licenseGenerated, licenseExpires, licenseSignature, xml.get("version", ""));
    }

    public static BVendorLicenseSummary make(VendorLicense license) {
        return new BVendorLicenseSummary(license == null ? Long.MIN_VALUE : license.getGenerated(), license == null ? Long.MIN_VALUE : license.getExpiration(), license == null ? "" : license.getSignature(), license == null ? "" : license.getVersion().toString());
    }

    public String getLicenseSignature() {
        String result = this.getLicenseSignatureString();
        return result.length() == 0 ? null : result;
    }

    public void setLicenseSignature(String value) {
        this.setLicenseSignatureString(value == null ? "" : value);
    }

    public String getVendor() {
        return SlotPath.unescape((String)this.getPropertyInParent().getName());
    }

    public Version getLicenseVersion() {
        return this.getLicenseVersionString().length() == 0 ? null : new Version(this.getLicenseVersionString());
    }

    public void update(VendorLicense license) {
        if (license.getGenerated() > this.getLicenseGenerated()) {
            this.setLicenseGenerated(license.getGenerated());
            this.setLicenseExpires(license.getExpiration());
            this.setLicenseSignatureString(license.getSignature());
            this.setLicenseVersionString(license.getVersion().toString());
        }
    }

    public void update(BVendorLicenseSummary summary) {
        if (summary.getLicenseGenerated() > this.getLicenseGenerated()) {
            this.setLicenseGenerated(summary.getLicenseGenerated());
            this.setLicenseExpires(summary.getLicenseExpires());
            this.setLicenseSignatureString(summary.getLicenseSignatureString());
            this.setLicenseVersionString(summary.getLicenseVersionString());
        }
    }

    public XElem asXml() {
        XElem result = new XElem("vendorInfo");
        result.setAttr("vendor", this.getVendor());
        result.setAttr("version", this.getLicenseVersionString());
        if (this.getLicenseExpires() > Long.MIN_VALUE) {
            result.setAttr("licenseExpires", LicenseUtil.formatDate((long)this.getLicenseExpires()));
        }
        if (this.getLicenseSignature() != null) {
            XElem sigElem = new XElem("licenseSignature");
            sigElem.addText(this.getLicenseSignature());
            result.addContent((XContent)sigElem);
        }
        return result;
    }
}

