/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.linux;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.timezone.BDstSupportLevel;
import java.security.AccessController;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
public class BSystemPlatformServiceLinux
extends BSystemPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemPlatformServiceLinux.class);
    private static long lastFileCheck = 0L;
    private String[] fileSystems;
    private Property[] filesystemProps;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSystemPlatformServiceLinux() {
        this.setTimezoneDayModeSupport(BDstSupportLevel.full);
    }

    @Override
    public boolean isValidPlatform() {
        return false;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        IPlatformProvider platformProvider = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE;
        BVector fileSystemAttributes = this.getFilesystemAttributes();
        fileSystemAttributes.removeAll();
        this.fileSystems = platformProvider.getAllFileSystemNames();
        this.filesystemProps = new Property[this.fileSystems.length];
        for (int i = 0; i < this.fileSystems.length; ++i) {
            String fsName = this.fileSystems[i];
            String displayName = platformProvider.getFileSystemDisplayName(fsName);
            String propName = SlotPath.escape((String)fsName);
            if (displayName == null) {
                displayName = "";
            }
            BFilesystemAttributes attr = new BFilesystemAttributes(platformProvider.getTotalBytes(fsName) / 1024L, platformProvider.getFreeBytes(fsName) / 1024L);
            int fileSystemAttrFlag = 3;
            if (displayName.isEmpty()) {
                fileSystemAttrFlag |= 4;
            }
            this.filesystemProps[i] = fileSystemAttributes.add(propName, (BValue)attr, fileSystemAttrFlag);
            fileSystemAttributes.setDisplayName(this.filesystemProps[i], BFormat.make((String)displayName), null);
        }
        this.setTotalPhysicalMemory((int)(platformProvider.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(platformProvider.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(platformProvider.getCurrentCPUUtilization());
        this.setOverallCpuUsage(platformProvider.getOverallCPUUtilization());
        this.setNumCpus(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public String makeRootName(String rootDirName) {
        return "/" + rootDirName + "/";
    }

    @Override
    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        IPlatformProvider platformProvider = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE;
        this.setFreePhysicalMemory((int)(platformProvider.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(platformProvider.getCurrentCPUUtilization());
        this.setOverallCpuUsage(platformProvider.getOverallCPUUtilization());
        if (cx != null && cx.getFacets().getb("resourceOnly", false)) {
            return;
        }
        super.doPoll(cx);
        long fileCheck = Clock.ticks();
        if (fileCheck - lastFileCheck > 15000L) {
            lastFileCheck = fileCheck;
            if (this.fileSystems != null) {
                for (int i = 0; i < this.fileSystems.length; ++i) {
                    BFilesystemAttributes attrs = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[i]);
                    attrs.setFreeSpace(platformProvider.getFreeBytes(this.fileSystems[i]) / 1024L);
                }
            }
        }
    }

    private static final class PlatformProviderHolder {
        private static final IPlatformProvider PLATFORM_PROVIDER_INSTANCE = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);

        private PlatformProviderHolder() {
        }
    }
}

