/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.npsdk;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platform.npsdk.NpsdkCmdPage;
import java.security.AccessController;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

class NpsdkDiagnosticsPage
extends SpyDir {
    NpsdkDiagnosticsPage() {
        this.add("Niagara Station JMX Info", (Spy)new NpsdkCmdPage("Niagara Station JMX Info", "jmxinfo", -1));
        String[][] diagnosticCommands = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getNativeDiagnosticsCommands();
        if (diagnosticCommands == null || diagnosticCommands.length == 0) {
            return;
        }
        for (int i = 0; i < diagnosticCommands.length; ++i) {
            String[] commandTuple = diagnosticCommands[i];
            String description = commandTuple[0];
            String command = commandTuple[1];
            this.add(description, (Spy)new NpsdkCmdPage(description, command, i));
        }
    }

    public void write(SpyWriter out) throws Exception {
        String[] list;
        out.startTable(false);
        out.trTitle((Object)"Platform Diagnostics", 2);
        for (String name : list = this.list()) {
            NpsdkCmdPage npsdkCmdPage = (NpsdkCmdPage)this.find(name);
            out.w((Object)"<tr><td>").a(name, (Object)npsdkCmdPage.getName()).w((Object)"</td><td style=\"padding-left: 20px;\">").w((Object)npsdkCmdPage.getCommand()).w((Object)"</td></tr>\n");
        }
        out.endTable();
    }

    private static final class PlatformProviderHolder {
        private static final IPlatformProvider PLATFORM_PROVIDER_INSTANCE = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);

        private PlatformProviderHolder() {
        }
    }
}

