/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.syslog;

import com.tridium.nre.syslog.Facility;
import com.tridium.nre.syslog.MessageType;
import com.tridium.nre.syslog.Transport;
import com.tridium.platform.syslog.BSyslogFacilityEnum;
import com.tridium.platform.syslog.BSyslogLevelEnum;
import com.tridium.platform.syslog.BSyslogMessageTypeEnum;
import com.tridium.platform.syslog.BSyslogTransportProtocolEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isReadonly", type="boolean", defaultValue="true", flags=7), @NiagaraProperty(name="serverHost", type="String", defaultValue="", flags=3), @NiagaraProperty(name="serverPort", type="int", defaultValue="1514", flags=3, facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="65535"), @Facet(name="BFacets.RADIX", value="10")}), @NiagaraProperty(name="messageType", type="BSyslogMessageTypeEnum", defaultValue="BSyslogMessageTypeEnum.bsd", flags=3), @NiagaraProperty(name="transportProtocol", type="BSyslogTransportProtocolEnum", defaultValue="BSyslogTransportProtocolEnum.tcp", flags=3, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="clientAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=3, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="clientPasswordModified", type="boolean", defaultValue="false", flags=7), @NiagaraProperty(name="platformLogEnabled", type="boolean", defaultValue="true", flags=3, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="stationLogEnabled", type="boolean", defaultValue="true", flags=3, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="logLevelFilter", type="BSyslogLevelEnum", defaultValue="BSyslogLevelEnum.info", flags=3), @NiagaraProperty(name="stationAuditEnabled", type="boolean", defaultValue="true", flags=3, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="securityAuditEnabled", type="boolean", defaultValue="true", flags=3, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="facility", type="BSyslogFacilityEnum", defaultValue="BSyslogFacilityEnum.local0", flags=3, facets={@Facet(value="BSyslogFacilityEnum.makeFacilitiesFacets()")}), @NiagaraProperty(name="queueSize", type="int", defaultValue="1000", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1), BFacets.MAX, BInteger.make(10000))")})})
public class BSyslogSettings
extends BComponent {
    @Generated
    public static final Property enabled = BSyslogSettings.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isReadonly = BSyslogSettings.newProperty((int)7, (boolean)true, null);
    @Generated
    public static final Property serverHost = BSyslogSettings.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property serverPort = BSyslogSettings.newProperty((int)3, (int)1514, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)65535)), (BFacets)BFacets.make((String)"radix", (int)10)));
    @Generated
    public static final Property messageType = BSyslogSettings.newProperty((int)3, (BValue)BSyslogMessageTypeEnum.bsd, null);
    @Generated
    public static final Property transportProtocol = BSyslogSettings.newProperty((int)3, (BValue)BSyslogTransportProtocolEnum.tcp, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property clientAliasAndPassword = BSyslogSettings.newProperty((int)3, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property clientPasswordModified = BSyslogSettings.newProperty((int)7, (boolean)false, null);
    @Generated
    public static final Property platformLogEnabled = BSyslogSettings.newProperty((int)3, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property stationLogEnabled = BSyslogSettings.newProperty((int)3, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property logLevelFilter = BSyslogSettings.newProperty((int)3, (BValue)BSyslogLevelEnum.info, null);
    @Generated
    public static final Property stationAuditEnabled = BSyslogSettings.newProperty((int)3, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property securityAuditEnabled = BSyslogSettings.newProperty((int)3, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property facility = BSyslogSettings.newProperty((int)3, (BValue)BSyslogFacilityEnum.local0, (BFacets)BSyslogFacilityEnum.makeFacilitiesFacets());
    @Generated
    public static final Property queueSize = BSyslogSettings.newProperty((int)3, (int)1000, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)10000)));
    @Generated
    public static final Type TYPE = Sys.loadType(BSyslogSettings.class);
    private List<String> clientAliasesList;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public boolean getIsReadonly() {
        return this.getBoolean(isReadonly);
    }

    @Generated
    public void setIsReadonly(boolean v) {
        this.setBoolean(isReadonly, v, null);
    }

    @Generated
    public String getServerHost() {
        return this.getString(serverHost);
    }

    @Generated
    public void setServerHost(String v) {
        this.setString(serverHost, v, null);
    }

    @Generated
    public int getServerPort() {
        return this.getInt(serverPort);
    }

    @Generated
    public void setServerPort(int v) {
        this.setInt(serverPort, v, null);
    }

    @Generated
    public BSyslogMessageTypeEnum getMessageType() {
        return (BSyslogMessageTypeEnum)this.get(messageType);
    }

    @Generated
    public void setMessageType(BSyslogMessageTypeEnum v) {
        this.set(messageType, (BValue)v, null);
    }

    @Generated
    public BSyslogTransportProtocolEnum getTransportProtocol() {
        return (BSyslogTransportProtocolEnum)this.get(transportProtocol);
    }

    @Generated
    public void setTransportProtocol(BSyslogTransportProtocolEnum v) {
        this.set(transportProtocol, (BValue)v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getClientAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(clientAliasAndPassword);
    }

    @Generated
    public void setClientAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(clientAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public boolean getClientPasswordModified() {
        return this.getBoolean(clientPasswordModified);
    }

    @Generated
    public void setClientPasswordModified(boolean v) {
        this.setBoolean(clientPasswordModified, v, null);
    }

    @Generated
    public boolean getPlatformLogEnabled() {
        return this.getBoolean(platformLogEnabled);
    }

    @Generated
    public void setPlatformLogEnabled(boolean v) {
        this.setBoolean(platformLogEnabled, v, null);
    }

    @Generated
    public boolean getStationLogEnabled() {
        return this.getBoolean(stationLogEnabled);
    }

    @Generated
    public void setStationLogEnabled(boolean v) {
        this.setBoolean(stationLogEnabled, v, null);
    }

    @Generated
    public BSyslogLevelEnum getLogLevelFilter() {
        return (BSyslogLevelEnum)this.get(logLevelFilter);
    }

    @Generated
    public void setLogLevelFilter(BSyslogLevelEnum v) {
        this.set(logLevelFilter, (BValue)v, null);
    }

    @Generated
    public boolean getStationAuditEnabled() {
        return this.getBoolean(stationAuditEnabled);
    }

    @Generated
    public void setStationAuditEnabled(boolean v) {
        this.setBoolean(stationAuditEnabled, v, null);
    }

    @Generated
    public boolean getSecurityAuditEnabled() {
        return this.getBoolean(securityAuditEnabled);
    }

    @Generated
    public void setSecurityAuditEnabled(boolean v) {
        this.setBoolean(securityAuditEnabled, v, null);
    }

    @Generated
    public BSyslogFacilityEnum getFacility() {
        return (BSyslogFacilityEnum)this.get(facility);
    }

    @Generated
    public void setFacility(BSyslogFacilityEnum v) {
        this.set(facility, (BValue)v, null);
    }

    @Generated
    public int getQueueSize() {
        return this.getInt(queueSize);
    }

    @Generated
    public void setQueueSize(int v) {
        this.setInt(queueSize, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void updateFromXml(XElem syslogSupported) {
        this.setEnabled(syslogSupported.getb("enabled", false));
        this.setIsReadonly(syslogSupported.getb("isReadonly", true));
        this.setServerHost(syslogSupported.get("serverHost", "127.0.0.1"));
        this.setServerPort(syslogSupported.geti("serverPort", 1514));
        this.setMessageType(BSyslogMessageTypeEnum.make(syslogSupported.get("messageType", MessageType.bsd.name())));
        this.setTransportProtocol(BSyslogTransportProtocolEnum.make(syslogSupported.get("transportProtocol", Transport.tcp.name())));
        this.setClientAliasAndPassword(new BCertificateAliasAndPassword(syslogSupported.get("clientAlias", "default"), BPassword.DEFAULT));
        this.setPlatformLogEnabled(syslogSupported.getb("platformLogEnabled", true));
        this.setStationLogEnabled(syslogSupported.getb("stationLogEnabled", true));
        this.setLogLevelFilter(BSyslogLevelEnum.make(syslogSupported.get("logLevelFilter", Level.INFO.getName().toLowerCase(Locale.ENGLISH))));
        this.setStationAuditEnabled(syslogSupported.getb("stationAuditEnabled", true));
        this.setSecurityAuditEnabled(syslogSupported.getb("securityAuditEnabled", true));
        this.setFacility(BSyslogFacilityEnum.make(syslogSupported.get("facility", Facility.local0.name())));
        this.setQueueSize(syslogSupported.geti("queueSize", 1000));
    }

    public List<String> getClientAliasesList() {
        return this.clientAliasesList;
    }

    public void setClientAliasesList(List<String> clientAliasesList) {
        for (int i = 0; i < clientAliasesList.size(); ++i) {
            String alias = clientAliasesList.get(i);
            if (alias == null || alias.equals(alias.toLowerCase(Locale.ENGLISH))) continue;
            alias = alias.toLowerCase(Locale.ENGLISH);
            clientAliasesList.set(i, alias);
        }
        this.clientAliasesList = clientAliasesList;
    }

    public void parseClientAliases(XElem aliasesElem) {
        XElem[] keys = aliasesElem.elems("key");
        ArrayList<String> aliases = new ArrayList<String>(keys.length);
        for (XElem key : keys) {
            aliases.add(key.get("alias"));
        }
        this.setClientAliasesList(aliases);
    }
}

