/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetFileMessage;
import com.tridium.platform.daemon.message.GetTcpIpMessage;
import com.tridium.platform.daemon.message.SaveTcpIpMessage;
import com.tridium.platform.daemon.message.UpdateTcpIpAdapterMessage;
import com.tridium.platform.daemon.message.UpdateTcpIpHostMessage;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.util.Lexicon;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public final class TcpUtil {
    private TcpUtil() {
    }

    public static void loadFromSession(BTcpIpHostSettings hostSettings, BDaemonSession session) throws Exception {
        InputStream stream = session.getInputStream(new GetTcpIpMessage());
        TcpUtil.updateFields(hostSettings, XParser.make((InputStream)stream).parse());
        BIFile file = session.getFileSpace().findFile(new FilePath("/"), BCacheAccessPolicy.cacheOnly);
        FilePath hostsPath = file == null ? (session.getHostProperties().isNiagara4() ? new FilePath("~etc/hosts") : new FilePath("!etc/hosts")) : new FilePath("/etc/hosts");
        InputStream in = session.getInputStream(new GetFileMessage(hostsPath, session.getFileSpace()));
        if (in != null) {
            hostSettings.loadHostFileContents(in);
        }
    }

    public static XElem getHostSettingsXml(BTcpIpHostSettings hostSettings) {
        SlotCursor c;
        XElem result = new XElem("tcpIpSettings");
        boolean hasIpv6Adapter = false;
        result.addAttr("hostname", hostSettings.getHostName());
        result.addAttr("isReadonly", String.valueOf(hostSettings.getIsReadonly()));
        result.addAttr("usesAdapterLevelSettings", String.valueOf(hostSettings.getUsesAdapterLevelSettings()));
        SlotCursor c2 = hostSettings.getAdapters().getProperties();
        while (c2.next(BTcpIpAdapterSettings.class)) {
            BTcpIpAdapterSettings tempSettings = (BTcpIpAdapterSettings)c2.get();
            if (!tempSettings.getIsIpv6Supported()) continue;
            hasIpv6Adapter = true;
            break;
        }
        if (hasIpv6Adapter) {
            result.addAttr("niagaraUsesIpv6", String.valueOf(hostSettings.getNiagaraUsesIpv6()));
            result.addAttr("isIPv6Readonly", String.valueOf(hostSettings.getIsIPv6Readonly()));
        } else {
            result.addAttr("niagaraUsesIpv6", "false");
            result.addAttr("isIPv6Readonly", "true");
        }
        if (!hostSettings.getUsesAdapterLevelSettings()) {
            XElem temp;
            result.addAttr("domain", hostSettings.getDomain());
            result.addAttr("defaultGateway", hostSettings.getDefaultGateway());
            XElem dnsHosts = new XElem("dnsHosts");
            dnsHosts.addAttr("limit", String.valueOf(hostSettings.getMaxDnsHosts()));
            c = hostSettings.getDnsHosts().getProperties();
            while (c.next(BString.class)) {
                temp = new XElem("dnsHost");
                temp.addAttr("ipAddress", c.get().toString());
                dnsHosts.addContent((XContent)temp);
            }
            result.addContent((XContent)dnsHosts);
            if (hasIpv6Adapter) {
                result.addAttr("ipv6DefaultGateway", hostSettings.getIpv6DefaultGateway());
                XElem ipv6DnsHosts = new XElem("ipv6DnsHosts");
                ipv6DnsHosts.addAttr("limit", String.valueOf(hostSettings.getMaxDnsHosts()));
                SlotCursor c3 = hostSettings.getIpv6DnsHosts().getProperties();
                while (c3.next(BString.class)) {
                    temp = new XElem("ipv6DnsHost");
                    temp.addAttr("ipv6Address", c3.get().toString());
                    ipv6DnsHosts.addContent((XContent)temp);
                }
                result.addContent((XContent)ipv6DnsHosts);
            }
        }
        XElem adapters = new XElem("adapters");
        c = hostSettings.getAdapters().getProperties();
        while (c.next(BTcpIpAdapterSettings.class)) {
            adapters.addContent((XContent)TcpUtil.getAdapterSettingsXml((BTcpIpAdapterSettings)c.get(), hostSettings.getUsesAdapterLevelSettings()));
        }
        result.addContent((XContent)adapters);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static void updateFields(BTcpIpHostSettings hostSettings, XElem hostElem) {
        XElem[] adapterElems;
        String hostnameBuf;
        block23: {
            try {
                hostnameBuf = hostElem.get("hostname");
                if (hostnameBuf == null || hostnameBuf.trim().length() == 0) {
                    hostnameBuf = "localhost";
                }
            }
            catch (XException e) {
                hostnameBuf = hostElem.get("hostName", "localhost");
                if (hostnameBuf != null && hostnameBuf.trim().length() != 0) break block23;
                hostnameBuf = "localhost";
            }
        }
        hostSettings.setHostName(hostnameBuf);
        hostSettings.setIsReadonly(hostElem.getb("isReadonly", false));
        hostSettings.setUsesAdapterLevelSettings(hostElem.getb("usesAdapterLevelSettings", true));
        boolean hasIpv6Adapter = false;
        XElem adaptersElem = hostElem.elem("adapters");
        if (adaptersElem != null) {
            for (XElem adapterElem : adapterElems = adaptersElem.elems("adapter")) {
                if (!adapterElem.getb("ipv6Supported", false)) continue;
                hasIpv6Adapter = true;
                break;
            }
        }
        if (hasIpv6Adapter) {
            hostSettings.setNiagaraUsesIpv6(hostElem.getb("niagaraUsesIpv6", false));
            hostSettings.setIsIPv6Readonly(hostElem.getb("isIPv6Readonly", true));
        } else {
            hostSettings.setNiagaraUsesIpv6(false);
            hostSettings.setIsIPv6Readonly(true);
        }
        if (!hostSettings.getUsesAdapterLevelSettings()) {
            String propName;
            hostSettings.setDefaultGateway(hostElem.get("defaultGateway"));
            hostSettings.setDomain(hostElem.get("domain"));
            XElem dnsHostsElem = hostElem.elem("dnsHosts");
            if (dnsHostsElem == null) {
                hostSettings.getDnsHosts().removeAll();
            } else {
                hostSettings.setMaxDnsHosts(dnsHostsElem.geti("limit", 2));
                XElem[] dnsHostElems = dnsHostsElem.elems("dnsHost");
                HashSet<String> propNames = new HashSet<String>();
                for (XElem dnsHostElem : dnsHostElems) {
                    propName = SlotPath.escape((String)dnsHostElem.get("ipAddress"));
                    propNames.add(propName);
                    if (hostSettings.getDnsHosts().getSlot(propName) != null) continue;
                    hostSettings.getDnsHosts().add(propName, (BValue)BString.make((String)dnsHostElem.get("ipAddress")), 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platform:IpHostFE")));
                }
                Property[] props = hostSettings.getDnsHosts().getPropertiesArray();
                for (XElem xElem : props) {
                    if (propNames.contains(xElem.getName())) continue;
                    hostSettings.getDnsHosts().remove(xElem.getName());
                }
            }
            if (hasIpv6Adapter) {
                hostSettings.setIpv6DefaultGateway(hostElem.get("ipv6DefaultGateway", ""));
                XElem ipv6DnsHostsElem = hostElem.elem("ipv6DnsHosts");
                if (ipv6DnsHostsElem == null) {
                    hostSettings.getIpv6DnsHosts().removeAll();
                } else {
                    void var14_33;
                    Property[] ipv6Props;
                    XElem[] ipv6DnsHostElems = ipv6DnsHostsElem.elems("ipv6DnsHost");
                    HashSet<String> ipv6PropNames = new HashSet<String>();
                    for (XElem xElem : ipv6DnsHostElems) {
                        propName = SlotPath.escape((String)xElem.get("ipv6Address"));
                        ipv6PropNames.add(propName);
                        if (hostSettings.getIpv6DnsHosts().getSlot(propName) != null) continue;
                        hostSettings.getIpv6DnsHosts().add(propName, (BValue)BString.make((String)xElem.get("ipv6Address")), 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platform:IpHostFE")));
                    }
                    Property[] propertyArray = ipv6Props = hostSettings.getIpv6DnsHosts().getPropertiesArray();
                    int n = propertyArray.length;
                    boolean bl = false;
                    while (var14_33 < n) {
                        Property ipv6Prop = propertyArray[var14_33];
                        if (!ipv6PropNames.contains(ipv6Prop.getName())) {
                            hostSettings.getIpv6DnsHosts().remove(ipv6Prop.getName());
                        }
                        ++var14_33;
                    }
                }
            }
        }
        HashSet<String> adapterNames = new HashSet<String>();
        if (adaptersElem == null) {
            hostSettings.getAdapters().removeAll();
        } else {
            Property[] props;
            for (XElem adapterElem : adapterElems = adaptersElem.elems("adapter")) {
                String adapterPropName = SlotPath.escape((String)adapterElem.get("id"));
                adapterNames.add(adapterPropName);
                BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)hostSettings.getAdapters().get(adapterPropName);
                if (adapter == null) {
                    adapter = new BTcpIpAdapterSettings();
                    hostSettings.getAdapters().add(adapterPropName, (BValue)adapter, 3);
                }
                TcpUtil.updateFields(adapter, adapterElem);
            }
            for (Property prop : props = hostSettings.getAdapters().getPropertiesArray()) {
                if (adapterNames.contains(prop.getName())) continue;
                hostSettings.getAdapters().remove(prop.getName());
            }
        }
    }

    public static XElem getAdapterSettingsXml(BTcpIpAdapterSettings adapterSettings, boolean usesAdapterLevelSettings) {
        XElem result = new XElem("adapter");
        result.addAttr("id", adapterSettings.getAdapterId());
        result.addAttr("isReadonly", String.valueOf(adapterSettings.getIsAdapterReadonly()));
        result.addAttr("enabled", String.valueOf(adapterSettings.getIsAdapterEnabled()));
        result.addAttr("canDisable", String.valueOf(adapterSettings.getCanDisableAdapter()));
        result.addAttr("desc", adapterSettings.getDescription());
        result.addAttr("macAddress", adapterSettings.getMediaAccessControlAddress());
        result.addAttr("ipAddress", adapterSettings.getIpAddress());
        result.addAttr("subnetMask", adapterSettings.getSubnetMask());
        result.addAttr("canUseDhcp", String.valueOf(adapterSettings.getCanUseDhcp()));
        if (usesAdapterLevelSettings) {
            result.addAttr("defaultGateway", adapterSettings.getDefaultGateway());
            result.addAttr("domain", adapterSettings.getDomain());
        }
        result.addAttr("ipv6Supported", String.valueOf(adapterSettings.getIsIpv6Supported()));
        if (adapterSettings.getIsIpv6Supported()) {
            result.addAttr("canDisableIpv6", String.valueOf(adapterSettings.getCanDisableIpv6()));
            result.addAttr("ipv6Enabled", String.valueOf(adapterSettings.getIsIpv6Enabled()));
            result.addAttr("canUseIpv6Dhcp", String.valueOf(adapterSettings.getCanUseIpv6Dhcp()));
            if (adapterSettings.getIsIpv6Enabled()) {
                result.addAttr("ipv6Address", adapterSettings.getIpv6Address());
                result.addAttr("ipv6SubnetPrefixLength", String.valueOf(adapterSettings.getIpv6SubnetPrefixLength()));
                if (usesAdapterLevelSettings) {
                    result.addAttr("ipv6DefaultGateway", adapterSettings.getIpv6DefaultGateway());
                }
            }
        }
        if (adapterSettings.getCanUseDhcp()) {
            result.addAttr("dhcpEnabled", String.valueOf(adapterSettings.getIsDhcpEnabled()));
            if (adapterSettings.getIsDhcpEnabled()) {
                result.addAttr("dhcpHost", adapterSettings.getDhcpHost());
                result.addAttr("dhcpLeaseGranted", adapterSettings.getDhcpLeaseGranted());
                result.addAttr("dhcpLeaseExpires", adapterSettings.getDhcpLeaseExpires());
            }
        }
        if (adapterSettings.getIsIpv6Enabled() && adapterSettings.getCanUseIpv6Dhcp()) {
            result.addAttr("ipv6DhcpEnabled", String.valueOf(adapterSettings.getIsIpv6DhcpEnabled()));
            if (adapterSettings.getIsIpv6DhcpEnabled()) {
                result.addAttr("ipv6DhcpHost", adapterSettings.getIpv6DhcpHost());
                result.addAttr("ipv6DhcpLeaseGranted", adapterSettings.getIpv6DhcpLeaseGranted());
                result.addAttr("ipv6DhcpLeaseExpires", adapterSettings.getIpv6DhcpLeaseExpires());
            }
        }
        if (usesAdapterLevelSettings) {
            XElem dnsHosts = new XElem("dnsHosts");
            dnsHosts.addAttr("limit", String.valueOf(adapterSettings.getMaxDnsHosts()));
            SlotCursor c = adapterSettings.getDnsHosts().getProperties();
            while (c.next(BString.class)) {
                XElem host = new XElem("dnsHost");
                host.addAttr("ipAddress", c.get().toString());
                dnsHosts.addContent((XContent)host);
            }
            result.addContent((XContent)dnsHosts);
            if (adapterSettings.getIsIpv6Enabled()) {
                XElem ipv6DnsHosts = new XElem("ipv6DnsHosts");
                ipv6DnsHosts.addAttr("limit", String.valueOf(adapterSettings.getMaxDnsHosts()));
                SlotCursor c2 = adapterSettings.getIpv6DnsHosts().getProperties();
                while (c2.next(BString.class)) {
                    XElem ipv6Host = new XElem("ipv6DnsHost");
                    ipv6Host.addAttr("ipv6Address", c2.get().toString());
                    ipv6DnsHosts.addContent((XContent)ipv6Host);
                }
                result.addContent((XContent)ipv6DnsHosts);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static void updateFields(BTcpIpAdapterSettings adapterSettings, XElem adapterElem) {
        XElem ipv6DnsHostsElem;
        String propName;
        XElem dnsHostsElem;
        adapterSettings.setAdapterId(adapterElem.get("id"));
        adapterSettings.setIsAdapterReadonly(adapterElem.getb("isReadonly", false));
        adapterSettings.setIsAdapterEnabled(adapterElem.getb("enabled", true));
        adapterSettings.setCanDisableAdapter(adapterElem.getb("canDisable", false));
        adapterSettings.setDescription(adapterElem.get("desc"));
        adapterSettings.setMediaAccessControlAddress(adapterElem.get("macAddress", "Unavailable"));
        adapterSettings.setIpAddress(adapterElem.get("ipAddress"));
        adapterSettings.setSubnetMask(adapterElem.get("subnetMask"));
        boolean canUseDhcp = adapterElem.getb("canUseDhcp", true);
        boolean ipv6Supported = adapterElem.getb("ipv6Supported", false);
        boolean ipv6Enabled = ipv6Supported && adapterElem.getb("ipv6Enabled", false);
        boolean canDisableIpv6 = ipv6Supported && adapterElem.getb("canDisableIpv6", false);
        boolean canUseIpv6Dhcp = adapterElem.getb("canUseIpv6Dhcp", false);
        adapterSettings.setCanUseDhcp(canUseDhcp);
        adapterSettings.setIsIpv6Supported(ipv6Supported);
        adapterSettings.setIsIpv6Enabled(ipv6Enabled);
        adapterSettings.setCanDisableIpv6(canDisableIpv6);
        adapterSettings.setCanUseIpv6Dhcp(canUseIpv6Dhcp);
        if (adapterElem.get("domain", null) != null) {
            adapterSettings.setDomain(adapterElem.get("domain"));
        }
        if (adapterElem.get("defaultGateway", null) != null) {
            adapterSettings.setDefaultGateway(adapterElem.get("defaultGateway"));
        }
        if (ipv6Enabled) {
            if (adapterElem.get("ipv6Address", null) != null) {
                adapterSettings.setIpv6Address(adapterElem.get("ipv6Address"));
            }
            if (adapterElem.get("ipv6DefaultGateway", null) != null) {
                adapterSettings.setIpv6DefaultGateway(adapterElem.get("ipv6DefaultGateway"));
            }
            if (adapterElem.get("ipv6SubnetPrefixLength", null) != null) {
                adapterSettings.setIpv6SubnetPrefixLength(adapterElem.geti("ipv6SubnetPrefixLength"));
            }
        }
        adapterSettings.setIsDhcpEnabled(canUseDhcp && adapterElem.getb("dhcpEnabled", false));
        adapterSettings.setIsIpv6DhcpEnabled(canUseIpv6Dhcp && adapterElem.getb("ipv6DhcpEnabled", false));
        if (adapterSettings.getIsDhcpEnabled()) {
            adapterSettings.setDhcpHost(adapterElem.get("dhcpHost", ""));
            adapterSettings.setDhcpLeaseGranted(adapterElem.get("dhcpLeaseGranted", ""));
            adapterSettings.setDhcpLeaseExpires(adapterElem.get("dhcpLeaseExpires", ""));
        } else {
            adapterSettings.setDhcpHost("");
            adapterSettings.setDhcpLeaseGranted("");
            adapterSettings.setDhcpLeaseExpires("");
        }
        if (ipv6Enabled) {
            if (adapterSettings.getIsIpv6DhcpEnabled()) {
                adapterSettings.setIpv6DhcpHost(adapterElem.get("ipv6DhcpHost", ""));
                adapterSettings.setIpv6DhcpLeaseGranted(adapterElem.get("ipv6DhcpLeaseGranted", ""));
                adapterSettings.setIpv6DhcpLeaseExpires(adapterElem.get("ipv6DhcpLeaseExpires", ""));
            } else {
                adapterSettings.setIpv6DhcpHost("");
                adapterSettings.setIpv6DhcpLeaseGranted("");
                adapterSettings.setIpv6DhcpLeaseExpires("");
            }
        }
        if ((dnsHostsElem = adapterElem.elem("dnsHosts")) != null) {
            XElem[] dnsHostElems = dnsHostsElem.elems("dnsHost");
            adapterSettings.setMaxDnsHosts(dnsHostsElem.geti("limit", 2));
            HashSet<String> propNames = new HashSet<String>();
            for (XElem dnsHostElem : dnsHostElems) {
                propName = SlotPath.escape((String)dnsHostElem.get("ipAddress"));
                propNames.add(propName);
                if (adapterSettings.getDnsHosts().getSlot(propName) != null) continue;
                adapterSettings.getDnsHosts().add(propName, (BValue)BString.make((String)dnsHostElem.get("ipAddress")), 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platform:IpHostFE")));
            }
            Property[] props = adapterSettings.getDnsHosts().getPropertiesArray();
            for (XElem xElem : props) {
                if (propNames.contains(xElem.getName())) continue;
                adapterSettings.getDnsHosts().remove(xElem.getName());
            }
        }
        if (ipv6Enabled && (ipv6DnsHostsElem = adapterElem.elem("ipv6DnsHosts")) != null) {
            void var15_22;
            Property[] ipv6Props;
            XElem[] ipv6DnsHostElems = ipv6DnsHostsElem.elems("ipv6DnsHost");
            HashSet<String> ipv6PropNames = new HashSet<String>();
            for (XElem xElem : ipv6DnsHostElems) {
                propName = SlotPath.escape((String)xElem.get("ipv6Address"));
                ipv6PropNames.add(propName);
                if (adapterSettings.getIpv6DnsHosts().getSlot(propName) != null) continue;
                adapterSettings.getIpv6DnsHosts().add(propName, (BValue)BString.make((String)xElem.get("ipv6Address")), 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platform:IpHostFE")));
            }
            Property[] propertyArray = ipv6Props = adapterSettings.getIpv6DnsHosts().getPropertiesArray();
            int n = propertyArray.length;
            boolean bl = false;
            while (var15_22 < n) {
                Property ipv6Prop = propertyArray[var15_22];
                if (!ipv6PropNames.contains(ipv6Prop.getName())) {
                    adapterSettings.getIpv6DnsHosts().remove(ipv6Prop.getName());
                }
                ++var15_22;
            }
        }
    }

    public static void saveToSession(BTcpIpHostSettings hostSettings, BDaemonSession session, boolean saveHosts) throws Exception {
        if (hostSettings == null) {
            return;
        }
        if (hostSettings.getIsReadonly()) {
            return;
        }
        BHostProperties props = session.getHostProperties();
        if (props.getOsName().startsWith("win") && hostSettings.getHostName().length() > 15) {
            throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.invalidHostName"));
        }
        if (props.getOsName().startsWith("qnx-jace") || props.getOsName().startsWith("tridium-qnx7")) {
            int dhcpCount = 0;
            int autoIpv6Count = 0;
            SlotCursor c = hostSettings.getAdapters().getProperties();
            while (c.next(BTcpIpAdapterSettings.class)) {
                BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
                if (adapter.getIsAdapterEnabled() && adapter.getIsDhcpEnabled()) {
                    ++dhcpCount;
                }
                if (!adapter.getIsAdapterEnabled() || !adapter.getIsIpv6Enabled() || !adapter.getIsIpv6DhcpEnabled()) continue;
                ++autoIpv6Count;
            }
            if (dhcpCount > 1) {
                throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.multipleDhcpAdapters"));
            }
            if (autoIpv6Count > 1) {
                throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.multipleAutoIPv6Adapters"));
            }
        }
        session.sendMessage(new UpdateTcpIpHostMessage(hostSettings));
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            if (adapter.getIsAdapterReadonly()) continue;
            session.sendMessage(new UpdateTcpIpAdapterMessage(adapter));
        }
        if (session.getHostProperties().isNiagara4()) {
            session.sendMessage(new SaveTcpIpMessage());
        }
        if (saveHosts) {
            BIFile file = session.getFileSpace().findFile(new FilePath("/"), BCacheAccessPolicy.cacheOnly);
            FilePath hostsPath = file == null ? new FilePath("~etc/hosts") : new FilePath("/etc/hosts");
            FileTransferMessage msg = new FileTransferMessage(session.getFileSpace());
            msg.addElement(new ByteArrayFileTransferElement(hostsPath, hostSettings.getHostFileContents().getBytes(StandardCharsets.UTF_8), session.getFileSpace()));
            DaemonFileUtil.transfer(session, msg, null);
        }
    }
}

