/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.time;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.timezone.TimeZoneUtil;
import java.util.Locale;
import javax.baja.platform.time.TimeManager;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.TimeZoneDatabase;

public class PlatformTimeManager
implements TimeManager {
    private PlatformTimeManager() {
        this.loadProperties();
    }

    public static PlatformTimeManager make() {
        return new PlatformTimeManager();
    }

    @Override
    public boolean isSystemTimeReadonly() {
        return this.getSystemPlatformService().getIsSystemTimeReadonly();
    }

    @Override
    public boolean isTimeZoneSupported(String tzId) {
        try {
            return TimeZoneUtil.isSupported(TimeZoneDatabase.getTimeZone((String)tzId), this.getSystemPlatformService().getTimezoneDayModeSupport());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean setTimeZone(String tzId) {
        return this.setTimeZone(tzId, false);
    }

    @Override
    public boolean setTimeZone(String tzId, boolean allowUTC) {
        if (Sys.getStation() != null && !this.getSystemPlatformService().getIsSystemTimeReadonly() && !this.getSystemPlatformService().getIsServiceReadonly() && (allowUTC || this.isTimeZoneSupported(tzId))) {
            try {
                this.getSystemPlatformService().setTimeZone(TimeZoneDatabase.getTimeZone((String)tzId));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public String getLocale() {
        return this.getSystemPlatformService().getLocale();
    }

    @Override
    public boolean setLocale(String newLocale) {
        BSystemPlatformService platService = this.getSystemPlatformService();
        BFacets facets = platService.getProperty("locale").getFacets();
        int min = -1;
        int max = -1;
        try {
            BInteger minFacet = (BInteger)facets.get("min");
            if (minFacet != null) {
                min = minFacet.getInt();
            }
        }
        catch (Exception minFacet) {
            // empty catch block
        }
        try {
            BInteger maxFacet = (BInteger)facets.get("fieldWidth");
            if (maxFacet != null) {
                max = maxFacet.getInt();
            }
        }
        catch (Exception maxFacet) {
            // empty catch block
        }
        int len = newLocale.length();
        if (min != -1 && len < min) {
            return false;
        }
        if (max != -1 && len > max) {
            return false;
        }
        Locale[] availableLocales = Locale.getAvailableLocales();
        boolean foundLocale = false;
        for (Locale locale : availableLocales) {
            if (!locale.toString().equals(newLocale)) continue;
            foundLocale = true;
        }
        if (!foundLocale) {
            return false;
        }
        platService.setLocale(newLocale);
        return true;
    }

    @Override
    public void saveProperties() {
        this.getSystemPlatformService().savePlatformServiceProperties();
    }

    private BSystemPlatformService getSystemPlatformService() {
        return (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
    }

    private void loadProperties() {
        this.getSystemPlatformService().poll();
    }
}

