/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platform.install;

import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BFileReconciler
extends BSingleton {
    @Generated
    public static final Type TYPE = Sys.loadType(BFileReconciler.class);
    public static final ReconciliationResults NO_RECONCILIATION = new ReconciliationResults(){

        @Override
        public InputStream getInputStream() throws Exception {
            throw new IllegalStateException();
        }

        @Override
        public long getSize() throws Exception {
            throw new IllegalStateException();
        }

        @Override
        public boolean shouldReplaceContents() {
            return false;
        }
    };

    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract ReconciliationResults reconcile(BIFile var1, BIFile var2) throws Exception;

    public final ReconciliationResults reconcile(BIFile newContents, long newContentCrc, BIFile existingContents, long existingContentCrc) throws Exception {
        if (newContents == null || newContentCrc == existingContentCrc && newContentCrc != -1L) {
            return NO_RECONCILIATION;
        }
        if (existingContents == null) {
            return new FileReconciliationResults(newContents);
        }
        return new LazyReconciliationResults(newContents, existingContents);
    }

    protected class LazyReconciliationResults
    implements ReconciliationResults {
        private ReconciliationResults results = null;
        private BIFile newContents;
        private BIFile existingContents;

        public LazyReconciliationResults(BIFile newContents, BIFile existingContents) {
            this.newContents = newContents;
            this.existingContents = existingContents;
        }

        @Override
        public InputStream getInputStream() throws Exception {
            return this.results().getInputStream();
        }

        @Override
        public long getSize() throws Exception {
            return this.results().getSize();
        }

        @Override
        public boolean shouldReplaceContents() throws Exception {
            return this.results().shouldReplaceContents();
        }

        private ReconciliationResults results() throws Exception {
            if (this.results == null) {
                this.results = BFileReconciler.this.reconcile(this.newContents, this.existingContents);
            }
            return this.results;
        }
    }

    public static class FileReconciliationResults
    implements ReconciliationResults {
        private BIFile file;

        public FileReconciliationResults(BIFile file) {
            this.file = file;
        }

        @Override
        public InputStream getInputStream() throws Exception {
            return this.file.getInputStream();
        }

        @Override
        public long getSize() throws Exception {
            return this.file.getSize();
        }

        @Override
        public boolean shouldReplaceContents() {
            return true;
        }
    }

    public static interface ReconciliationResults {
        public InputStream getInputStream() throws Exception;

        public long getSize() throws Exception;

        public boolean shouldReplaceContents() throws Exception;
    }
}

