/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.LocalizableExceptionTranslator;
import com.tridium.remoteVideo.BRemoteVideoSource;
import com.tridium.remoteVideo.RemoteVideoSourceBogEncoder;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.driver.util.BAbstractPollService;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BRemoteVideoChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BRemoteVideoChannel.class);
    protected Object foxMethodViaCircuitMonitor = new Object();
    public static LocalizableExceptionTranslator exceptionTranslator = new LocalizableExceptionTranslator();
    public static final String CHANNEL_NAME = "remoteVideo";
    public static final String CMD_GET_NETWORK_FOR_VIDEO_SOURCE = "cmdNet";
    public static final String CMD_EVENT_RECALLER_ORD = "cmdEventRecallerOrd";
    public static final String CMD_REMOTE_METHOD = "cmdRemoteMethod";
    public static final String CMD_CHECK_CONNECTIVITY = "cmdCheckConnectivity";
    public static final String CMD_REMOTE_HANDLE_ORD = "cmdRemoteHandleOrd";
    public static final String PARAM_DRIVER_VIDEO_SOURCE_SLOT_PATH_ORD = "spOrd";
    public static final String PARAM_DRIVER_VIDEO_SOURCE_HANDLE_ORD = "hOrd";
    public static final String PARAM_DRIVER_VIDEO_SOURCE_ORD = "pOrd";
    public static final String PARAM_RETRIEVE_ACTION_PARAM = "pRetreiveActionParam";
    public static final String PARAM_DRIVER_VIDEO_SOURCE_NET = "pNet";
    public static final String PARAM_NIAGARA_STATION_NAME = "pNiagaraStationName";
    public static final String PARAM_REMOTE_STATION_NAME = "pRemoteStationName";
    public static final String ERROR = "e";
    public static final int ERROR_ORD_NOT_VIDEO_SOURCE = 1;
    public static final int ERROR_ORD_NOT_COMPONENT = 2;
    public static final int ERROR_VIDEO_SOURCE_NOT_UNDER_DRIVER_NETWORK = 2;
    public static final int ERROR_VIDEO_SOURCE_NOT_BI_EVENT_PROVIDER = 3;
    public static final int ERROR_NO_EVENT_RECALL_SUPPORT = 4;
    public static final int ERROR_UNABLE_TO_FIND_REMOTE_VIDEO_SOURCE = 5;
    public static final int ERROR_VIDEO_SOURCE_HAS_NO_HANDLE_ORD_IMPOSSIBLE = 6;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRemoteVideoChannel() {
        super(CHANNEL_NAME);
    }

    protected boolean useSharedKeyEncryption() {
        return true;
    }

    Context makeRemoteEncryptionContext(Context baseContext, boolean outgoing) {
        return this.makeEncryptionContext(baseContext, outgoing);
    }

    public BOrd doGetEventRecaller(BOrd driverVideoSourceOrdInItsStation) throws Exception {
        FoxResponse rsp;
        int errorCode;
        if (this.log.isTraceOn()) {
            this.log.trace("doGetEventRecaller - driverVideoSourceOrdInItsStation = " + driverVideoSourceOrdInItsStation);
        }
        FoxRequest req = this.makeRequest(CMD_EVENT_RECALLER_ORD);
        req.add(PARAM_DRIVER_VIDEO_SOURCE_ORD, driverVideoSourceOrdInItsStation.toString());
        if (this.isTraceOn()) {
            this.trace("r:pOrd");
            req.dump();
        }
        if ((errorCode = (rsp = this.sendSync(req)).getInt(ERROR, -1)) != -1) {
            return null;
        }
        String eventProviderOrdString = rsp.getString(PARAM_DRIVER_VIDEO_SOURCE_ORD, null);
        if (eventProviderOrdString == null) {
            return null;
        }
        if (eventProviderOrdString.startsWith("station:|")) {
            return BOrd.make((String)eventProviderOrdString);
        }
        return BOrd.make((String)("station:|" + eventProviderOrdString));
    }

    public FoxResponse doGetEventRecaller(FoxRequest request) throws Exception {
        BObject resolvedVideoSource;
        if (this.log.isTraceOn()) {
            this.log.trace("doGetEventRecaller");
        }
        FoxResponse resp = new FoxResponse(request);
        BOrd ord = BOrd.make((String)request.getString(PARAM_DRIVER_VIDEO_SOURCE_ORD));
        if (this.log.isTraceOn()) {
            this.log.trace("doGetEventRecaller - resolving ord = " + ord);
        }
        if ((resolvedVideoSource = ord.get((BObject)Sys.getStation())) instanceof BIVideoEventProvider) {
            BIVideoEventProvider eventProvider;
            BVideoEventRecall eventRecallComponent;
            if (this.log.isTraceOn()) {
                this.log.trace("doGetEventRecaller - ord resolves to a BIVideoEventProvider - good");
            }
            if ((eventRecallComponent = (eventProvider = (BIVideoEventProvider)resolvedVideoSource).getEventRecaller()) != null) {
                resp.add(PARAM_DRIVER_VIDEO_SOURCE_ORD, eventRecallComponent.getSlotPathOrd().toString());
                return resp;
            }
            if (this.log.isTraceOn()) {
                this.log.trace("doGetEventRecaller - error - the resolved BIVideoEventProvider's getEventRecaller() method returns null");
            }
            return this.foxErrorRsp(resp, 4);
        }
        if (this.log.isTraceOn()) {
            this.log.trace("doGetEventRecaller - error - the resolved object does not implement BIVideoEventProvider");
        }
        return this.foxErrorRsp(resp, 3);
    }

    public BOrd doGetCameraHandleOrd(BOrd driverVideoSourceOrdInItsStation) throws Exception {
        FoxResponse rsp;
        int errorCode;
        if (this.log.isTraceOn()) {
            this.log.trace("doGetCameraHandleOrd - driverVideoSourceOrdInItsStation = " + driverVideoSourceOrdInItsStation);
        }
        FoxRequest req = this.makeRequest(CMD_REMOTE_HANDLE_ORD);
        req.add(PARAM_DRIVER_VIDEO_SOURCE_ORD, driverVideoSourceOrdInItsStation.toString());
        if (this.isTraceOn()) {
            this.trace("r:pOrd");
            req.dump();
        }
        if ((errorCode = (rsp = this.sendSync(req)).getInt(ERROR, -1)) != -1) {
            return null;
        }
        String videoSourceHandleOrd = rsp.getString(PARAM_DRIVER_VIDEO_SOURCE_ORD, null);
        if (videoSourceHandleOrd == null) {
            return null;
        }
        return BOrd.make((String)videoSourceHandleOrd);
    }

    public FoxResponse doGetCameraHandleOrd(FoxRequest request) throws Exception {
        BObject resolvedVideoSource;
        if (this.log.isTraceOn()) {
            this.log.trace("doGetCameraHandleOrd");
        }
        FoxResponse resp = new FoxResponse(request);
        BOrd ord = BOrd.make((String)request.getString(PARAM_DRIVER_VIDEO_SOURCE_ORD));
        if (this.log.isTraceOn()) {
            this.log.trace("doGetCameraHandleOrd - resolving ord = " + ord);
        }
        if ((resolvedVideoSource = ord.get((BObject)Sys.getStation())) instanceof BComponent) {
            BOrd handleOrd;
            if (this.log.isTraceOn()) {
                this.log.trace("doGetCameraHandleOrd - ord resolves to a BComponent - good");
            }
            if ((handleOrd = ((BComponent)resolvedVideoSource).getHandleOrd()) != null) {
                resp.add(PARAM_DRIVER_VIDEO_SOURCE_ORD, handleOrd.toString());
                return resp;
            }
            if (this.log.isTraceOn()) {
                this.log.trace("doGetCameraHandleOrd - error - the resolved video source's getHandleOrd() method returns null");
            }
            return this.foxErrorRsp(resp, 6);
        }
        if (this.log.isTraceOn()) {
            this.log.trace("doGetCameraHandleOrd - error - the resolved object is not a BComponent");
        }
        return this.foxErrorRsp(resp, 2);
    }

    public BRemoteVideoSource getNetworkForDriverVideoSource(BOrd driverVideoSourceOrdInItsStation) throws Exception {
        FoxResponse resp;
        int errorCode;
        FoxRequest req = this.makeRequest(CMD_GET_NETWORK_FOR_VIDEO_SOURCE);
        req.add(PARAM_DRIVER_VIDEO_SOURCE_ORD, driverVideoSourceOrdInItsStation.toString());
        if (this.isTraceOn()) {
            this.trace("c:pOrd");
            req.dump();
        }
        if ((errorCode = (resp = this.sendSync(req)).getInt(ERROR, 0)) == 0) {
            byte[] bogBytes = resp.getBlob(PARAM_DRIVER_VIDEO_SOURCE_NET);
            ByteArrayInputStream bin = new ByteArrayInputStream(bogBytes);
            ValueDocDecoder bogDecoder = new ValueDocDecoder((InputStream)bin, this.makeRemoteEncryptionContext(null, false));
            BRemoteVideoSource container = (BRemoteVideoSource)bogDecoder.decodeDocument();
            BOrd cameraSlotPathOrd = BOrd.make((String)resp.getString(PARAM_DRIVER_VIDEO_SOURCE_SLOT_PATH_ORD));
            BOrd cameraHandleOrd = BOrd.make((String)resp.getString(PARAM_DRIVER_VIDEO_SOURCE_HANDLE_ORD));
            container.setCameraOrd(cameraSlotPathOrd);
            container.setCameraHandleOrd(cameraHandleOrd);
            return container;
        }
        return null;
    }

    protected void disablePingingAndPolling(BComponent root) {
        SlotCursor sc = root.getSlots();
        while (sc.nextObject()) {
            BValue next = sc.get();
            if (next instanceof BPingMonitor) {
                BPingMonitor pingMonitor = (BPingMonitor)next;
                pingMonitor.setPingEnabled(false);
            }
            if (next instanceof BAbstractPollService) {
                BAbstractPollService pollService = (BAbstractPollService)next;
                pollService.setPollEnabled(false);
            }
            if (!(next instanceof BComponent)) continue;
            this.disablePingingAndPolling((BComponent)next);
        }
    }

    public FoxResponse getNetworkForDriverVideoSource(FoxRequest request) throws Exception {
        BObject resolvedObject;
        FoxResponse resp = new FoxResponse(request);
        String ordString = request.getString(PARAM_DRIVER_VIDEO_SOURCE_ORD);
        if (!ordString.startsWith("station:|")) {
            ordString = "station:|" + ordString;
        }
        BOrd ord = BOrd.make((String)ordString);
        try {
            resolvedObject = ord.get((BObject)Sys.getStation());
        }
        catch (UnresolvedException ue) {
            throw new LocalizableRuntimeException("videoDriver", "RemoteVideo.RemoteStation.Camera.Unresolved", new Object[]{ord, Sys.getStation().getStationName()});
        }
        if (this.log.isTraceOn()) {
            this.log.trace("getNetworkForDriverVideoSource");
        }
        if (resolvedObject instanceof BIVideoSource) {
            if (this.log.isTraceOn()) {
                this.log.trace("Calling foxNetForVideoSource. ord=" + ord);
            }
            return this.foxNetForVideoSource(resp, (BIVideoSource)resolvedObject);
        }
        if (this.log.isTraceOn()) {
            this.log.trace("getNetworkForDriverVideoSource - Error - Ord did not resolve to a BIVideoSource. ord=" + ord);
        }
        return this.foxErrorRsp(resp, 1);
    }

    protected FoxResponse foxNetForVideoSource(FoxResponse resp, BIVideoSource videoSrc) throws Exception {
        if (videoSrc instanceof BComponent) {
            if (this.log.isTraceOn()) {
                this.log.trace("foxNetForVideoSource - Calling foxNetForVideoSourceComponent");
            }
            return this.foxNetForVideoSourceComponent(resp, (BComponent)videoSrc);
        }
        if (this.log.isTraceOn()) {
            this.log.trace("foxNetForVideoSource - Error - Resolved BIVideoSource object does not resolve to a BComponent");
        }
        return this.foxErrorRsp(resp, 2);
    }

    protected FoxResponse foxNetForVideoSourceComponent(FoxResponse resp, BComponent videoSrcComponent) throws Exception {
        Stack<BComponent> ancestryStack;
        if (this.log.isTraceOn()) {
            this.log.trace("foxNetForVideoSourceComponent - Calling getAncestryStack");
        }
        if ((ancestryStack = this.getAncestryStack(videoSrcComponent)).size() > 0 && ancestryStack.peek() instanceof BDeviceNetwork) {
            if (this.log.isTraceOn()) {
                this.log.trace("foxNetForVideoSourceComponent - Calling getBogOfVideoSourceAndAncestry");
            }
            return this.getBogOfVideoSourceAndAncestry(resp, ancestryStack, videoSrcComponent);
        }
        if (this.log.isTraceOn()) {
            this.log.trace("foxNetForVideoSourceComponent - Error - Resolved BIVideoSource object is not located under a driver network");
        }
        return this.foxErrorRsp(resp, 2);
    }

    protected FoxResponse getBogOfVideoSourceAndAncestry(FoxResponse resp, Stack<BComponent> ancestryStack, BComponent videoSrcComponent) throws Exception {
        ByteArrayOutputStream bogByteStream = new ByteArrayOutputStream();
        if (this.log.isTraceOn()) {
            this.log.trace("getBogOfVideoSourceAndAncestry - Allocating new RemoteVideoSourceBogEncoder");
        }
        RemoteVideoSourceBogEncoder bogEncoder = new RemoteVideoSourceBogEncoder(bogByteStream, this.makeRemoteEncryptionContext(null, true));
        if (this.log.isTraceOn()) {
            this.log.trace("getBogOfVideoSourceAndAncestry - Calling encodeVideoSource");
        }
        bogEncoder.encodeVideoSource(ancestryStack, videoSrcComponent);
        bogEncoder.close();
        resp.add(PARAM_DRIVER_VIDEO_SOURCE_NET, bogByteStream.toByteArray());
        resp.add(PARAM_DRIVER_VIDEO_SOURCE_SLOT_PATH_ORD, videoSrcComponent.getSlotPathOrd().toString());
        resp.add(PARAM_DRIVER_VIDEO_SOURCE_HANDLE_ORD, videoSrcComponent.getHandleOrd().toString());
        if (this.log.isTraceOn()) {
            this.log.trace("getBogOfVideoSourceAndAncestry - success - returning resp to client");
        }
        return resp;
    }

    protected void removeAllDynamicSlots(BComponent comp) {
        comp.removeAll();
        BComponent[] childComponents = comp.getChildComponents();
        for (int i = 0; i < childComponents.length; ++i) {
            this.removeAllDynamicSlots(childComponents[i]);
        }
    }

    protected Stack<BComponent> getSanitizedAncestryStack(BComponent videoSrcComponent) {
        BComplex parent;
        Stack<BComponent> ancestryStack = new Stack<BComponent>();
        for (parent = videoSrcComponent.getParent(); parent != null && !(parent instanceof BDeviceNetwork); parent = parent.getParent()) {
            if (!(parent instanceof BComponent)) continue;
            BComponent parentCopy = (BComponent)parent.newCopy(true);
            this.removeAllDynamicSlots(parentCopy);
            ancestryStack.push((BComponent)parent);
        }
        if (parent != null && parent instanceof BDeviceNetwork) {
            BDeviceNetwork copyOfDriverVideoNetwork = (BDeviceNetwork)parent.newCopy(true);
            this.removeAllDynamicSlots((BComponent)copyOfDriverVideoNetwork);
            ancestryStack.push((BComponent)((BDeviceNetwork)parent));
        }
        return ancestryStack;
    }

    protected Stack<BComponent> getAncestryStack(BComponent videoSrcComponent) {
        BComplex parent;
        Stack<BComponent> ancestryStack = new Stack<BComponent>();
        for (parent = videoSrcComponent.getParent(); parent != null && !(parent instanceof BDeviceNetwork); parent = parent.getParent()) {
            if (!(parent instanceof BComponent)) continue;
            ancestryStack.push((BComponent)parent);
        }
        if (parent != null && parent instanceof BDeviceNetwork) {
            ancestryStack.push((BComponent)((BDeviceNetwork)parent));
        }
        return ancestryStack;
    }

    protected FoxResponse foxErrorRsp(FoxResponse resp, int errorCode) {
        resp.add(ERROR, errorCode);
        return resp;
    }

    public BValue remoteMethod(String ord, String methodName, BValue arg, boolean async) throws Exception {
        FoxRequest req = this.makeRequest(CMD_REMOTE_METHOD);
        req.add("ord", ord);
        req.add("method", methodName);
        if (arg != null) {
            req.add("arg", ValueDocEncoder.marshal((BValue)arg));
        }
        if (this.isTraceOn()) {
            this.trace("c:remoteMethod");
            req.dump();
        }
        if (async) {
            this.sendAsync(req);
            return null;
        }
        FoxResponse resp = this.sendSync(req);
        BValue result = null;
        String resultStr = resp.getString("return", null);
        if (resultStr != null) {
            result = ValueDocDecoder.unmarshal((String)resultStr, (Context)this.makeRemoteEncryptionContext(null, false));
        }
        return result;
    }

    private FoxResponse remoteMethod(FoxMessage req) throws Exception {
        String ord = req.getString("ord");
        String methodName = req.getString("method");
        String argStr = req.getString("arg", null);
        OrdTarget t = BOrd.make((String)ord).resolve((BObject)Sys.getStation());
        BComponent target = t.getComponent();
        if (target == null) {
            throw new UnresolvedException(ord);
        }
        Class<?> targetClass = target.getClass();
        BValue arg = null;
        Method method = null;
        Object methodReturnValue = null;
        if (argStr != null) {
            arg = ValueDocDecoder.unmarshal((String)argStr, (Context)this.makeRemoteEncryptionContext(null, false));
            for (Class<?> argClass = arg.getClass(); argClass != null; argClass = argClass.getSuperclass()) {
                try {
                    method = targetClass.getMethod(methodName, argClass);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (method == null) {
                throw new UnresolvedException("No public method " + methodName + "(" + arg.getClass().getName() + ")");
            }
            methodReturnValue = method.invoke((Object)target, arg);
        } else {
            method = targetClass.getMethod(methodName, new Class[0]);
            if (method == null) {
                throw new UnresolvedException("No public method " + methodName);
            }
            methodReturnValue = method.invoke((Object)target, new Object[0]);
        }
        FoxResponse resp = req instanceof FoxRequest ? new FoxResponse((FoxRequest)req) : new FoxResponse();
        if (methodReturnValue != null && methodReturnValue instanceof BValue) {
            resp.add("return", ValueDocEncoder.marshal((BValue)((BValue)methodReturnValue), (Context)this.makeRemoteEncryptionContext(null, true)));
        }
        if (this.isTraceOn()) {
            this.trace("s:remoteMethod");
            resp.dump();
        }
        return resp;
    }

    public FoxResponse process(FoxRequest request) throws Throwable {
        String command = request.command;
        if (command == CMD_GET_NETWORK_FOR_VIDEO_SOURCE) {
            return this.getNetworkForDriverVideoSource(request);
        }
        if (command == CMD_EVENT_RECALLER_ORD) {
            return this.doGetEventRecaller(request);
        }
        if (command == CMD_REMOTE_HANDLE_ORD) {
            return this.doGetCameraHandleOrd(request);
        }
        if (command == CMD_REMOTE_METHOD) {
            return this.remoteMethod((FoxMessage)request);
        }
        throw new InvalidCommandException(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void circuitOpened(FoxCircuit circuit) throws Throwable {
        if (circuit.command == CMD_REMOTE_METHOD) {
            Throwable e = null;
            try {
                FoxMessage methodReq = circuit.readMessage();
                FoxResponse methodRsp = this.remoteMethod(methodReq);
                circuit.writeMessage((FoxMessage)methodRsp);
            }
            catch (InvocationTargetException ite) {
                Throwable targetException = ite.getTargetException();
                if (targetException == null) {
                    e = ite;
                }
                if (targetException instanceof ActionInvokeException) {
                    e = ((ActionInvokeException)targetException).getCause();
                }
                e = targetException;
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (e != null) {
                    if (this.log.isTraceOn()) {
                        this.log.trace("Unable to invoke remote method via circuit.", e);
                    }
                    circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage(e));
                }
            }
        } else {
            super.circuitOpened(circuit);
        }
    }

    public BValue remoteMethodViaCircuit(String ord, String methodName, BValue arg, boolean async) throws Exception {
        FoxRequest req = this.makeRequest(CMD_REMOTE_METHOD);
        req.add("ord", ord);
        req.add("method", methodName);
        if (arg != null) {
            req.add("arg", ValueDocEncoder.marshal((BValue)arg, (Context)this.makeRemoteEncryptionContext(null, true)));
        }
        if (this.isTraceOn()) {
            this.trace("c:remoteMethodViaCircuit");
            req.dump();
        }
        if (async) {
            FoxCircuit c = this.openCircuit(CMD_REMOTE_METHOD);
            c.writeMessage((FoxMessage)req);
            return null;
        }
        FoxCircuit c = this.openCircuit(CMD_REMOTE_METHOD);
        c.writeMessage((FoxMessage)req);
        FoxMessage resp = c.readMessage();
        if (resp.getString("exception", null) != null) {
            throw exceptionTranslator.messageToException(resp);
        }
        BValue result = null;
        String resultStr = resp.getString("return", null);
        if (resultStr != null) {
            result = ValueDocDecoder.unmarshal((String)resultStr, (Context)this.makeRemoteEncryptionContext(null, false));
        }
        return result;
    }
}

