/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.remoteVideo.BRemoteVideoChannel;
import com.tridium.remoteVideo.BRemoteVideoService;
import com.tridium.videoDriver.camera.UnresolvedOrOfflineStationException;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="remoteVideo")
@NiagaraSingleton
public class BRemoteVideoScheme
extends BOrdScheme {
    @Generated
    public static final BRemoteVideoScheme INSTANCE = new BRemoteVideoScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BRemoteVideoScheme.class);
    public static Log log = Log.getLog((String)"remoteVideo.remoteVideoScheme");

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BRemoteVideoScheme() {
        super("remoteVideo");
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        if (log.isTraceOn()) {
            log.trace("resolve base=" + base + " query=" + query);
        }
        BObject baseObject = base.get();
        if (log.isTraceOn()) {
            log.trace("baseObject=" + baseObject);
        }
        BComponentSpace cs = null;
        if (baseObject instanceof BComponent) {
            if (log.isTraceOn()) {
                log.trace("baseObject instanceof BComponent");
            }
            cs = ((BComponent)baseObject).getComponentSpace();
            if (log.isTraceOn()) {
                log.trace("cs=" + cs);
            }
        }
        if (baseObject instanceof BComponentSpace) {
            if (log.isTraceOn()) {
                log.trace("baseObject instanceof BComponentSpace");
            }
            cs = (BComponentSpace)baseObject;
            if (log.isTraceOn()) {
                log.trace("cs=" + cs);
            }
        }
        if (cs != null) {
            if (log.isTraceOn()) {
                log.trace("cs is not null");
            }
            BComponent root = cs.getRootComponent();
            if (log.isTraceOn()) {
                log.trace("root=" + root);
            }
            if (root instanceof BStation) {
                if (log.isTraceOn()) {
                    log.trace("root is instance of BStation");
                }
                BStation proxyStation = (BStation)root;
                BRemoteVideoService[] remoteVideoServices = (BRemoteVideoService[])proxyStation.getServices().getChildren(BRemoteVideoService.class);
                BRemoteVideoService remoteVideoService = null;
                if (remoteVideoServices.length > 0) {
                    remoteVideoService = remoteVideoServices[0];
                }
                if (remoteVideoService == null) {
                    throw new BajaRuntimeException("No remote video service available in the station.");
                }
                if (remoteVideoService.getStatus().isFault()) {
                    throw new BajaRuntimeException("Remote video service in the station is in fault condition.");
                }
                BOrd remoteVideoSourceOrd = null;
                try {
                    BISession niagaraSession;
                    if (log.isTraceOn()) {
                        log.trace("Resolving remote video source");
                    }
                    if ((niagaraSession = remoteVideoService.getSession()) instanceof BFoxSession) {
                        BFoxSession foxSession = (BFoxSession)remoteVideoService.getSession();
                        BRemoteVideoChannel remoteVideoChannel = (BRemoteVideoChannel)foxSession.getConnection().getChannels().get("remoteVideo", BRemoteVideoChannel.TYPE);
                        remoteVideoSourceOrd = (BOrd)remoteVideoChannel.remoteMethodViaCircuit("station:|" + remoteVideoService.getSlotPathOrd(), "resolveRemoteVideoSource", (BValue)BString.make((String)query.getBody()), false);
                    } else {
                        remoteVideoSourceOrd = remoteVideoService.resolveRemoteVideoSource(BString.make((String)query.getBody()));
                    }
                }
                catch (Exception e) {
                    String localizedResolveMessage;
                    if (log.isTraceOn()) {
                        log.trace("Exception resolving remote video source", (Throwable)e);
                    }
                    if ((localizedResolveMessage = BRemoteVideoService.getLocalResolveMessage(e)) == null) {
                        throw new UnresolvedException("Remote video service reported the following exception: " + e, (Throwable)e);
                    }
                    throw new UnresolvedOrOfflineStationException(localizedResolveMessage, (Throwable)e);
                }
                if (log.isTraceOn()) {
                    log.trace("remoteVideoSourceOrd=" + remoteVideoSourceOrd);
                }
                BObject remoteVideoSource = null;
                try {
                    remoteVideoSource = remoteVideoSourceOrd.resolve((BObject)remoteVideoService.getComponentSpace().getRootComponent()).get();
                }
                catch (Exception e) {
                    throw new UnresolvedException("Exception while trying to resolve remote video source", (Throwable)e);
                }
                if (remoteVideoSource == null) {
                    if (log.isTraceOn()) {
                        log.trace("Unable to resolve remote video source due to potential Client-server sync issue." + remoteVideoSourceOrd);
                    }
                    throw new UnresolvedException("Unable to resolve remote video source due to potential Client-server sync issue");
                }
                if (log.isTraceOn()) {
                    log.trace("remoteVideoSource=" + remoteVideoSource);
                }
                return new OrdTarget(base, remoteVideoSource);
            }
            if (log.isTraceOn()) {
                log.trace("Component space root not a BStation");
            }
            throw new UnresolvedException("Component space root not a BStation");
        }
        if (log.isTraceOn()) {
            log.trace("Component space is not available.");
        }
        throw new UnresolvedException("Component space is not available.");
    }
}

