/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.remoteVideo.BRemoteVideoChannel;
import com.tridium.remoteVideo.BRemoteVideoSource;
import com.tridium.remoteVideo.nd.BNiagaraCameraExt;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoChannel;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addCameraExtToNiagaraStations", flags=4), @NiagaraAction(name="resolveRemoteVideoSource", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BOrd", flags=4)})
public final class BRemoteVideoService
extends BAbstractService {
    @Generated
    public static final Action addCameraExtToNiagaraStations = BRemoteVideoService.newAction((int)4, null);
    @Generated
    public static final Action resolveRemoteVideoSource = BRemoteVideoService.newAction((int)4, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRemoteVideoService.class);
    private static final BIcon icon = BIcon.make((String)"module://remoteVideo/icons/remoteVideoService.png");
    private boolean serviceStarted = false;
    private Object serviceStartedMonitor = new Object();
    protected Object remoteVideoSourceAdditionMonitor = new Object();
    protected Object videoSourceAccess = new Object();
    private static Type[] serviceTypes = new Type[]{TYPE};
    public static Log log = Log.getLog((String)"remoteVideo.remoteVideoService");

    @Generated
    public void addCameraExtToNiagaraStations() {
        this.invoke(addCameraExtToNiagaraStations, null, null);
    }

    @Generated
    public BOrd resolveRemoteVideoSource(BString parameter) {
        return (BOrd)this.invoke(resolveRemoteVideoSource, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStarted() throws Exception {
        this.getComponentSpace().enableMixIn(BNiagaraCameraExt.TYPE);
        Object object = this.serviceStartedMonitor;
        synchronized (object) {
            this.serviceStarted = true;
            this.serviceStartedMonitor.notifyAll();
        }
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        this.getComponentSpace().disableMixIn(BNiagaraCameraExt.TYPE);
        super.serviceStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServiceStarted() throws InterruptedException {
        Object object = this.serviceStartedMonitor;
        synchronized (object) {
            if (!this.serviceStarted) {
                this.serviceStartedMonitor.wait(10000L);
                if (!this.serviceStarted) {
                    throw new ServiceNotFoundException("BRemoteVideoService did not start even after 10 seconds.");
                }
            }
        }
    }

    public void doAddCameraExtToNiagaraStations() {
        BNiagaraNetwork niagaraNet = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] niagaraStations = niagaraNet.getDevices();
        for (int i = 0; i < niagaraStations.length; ++i) {
            BNiagaraStation niagaraStation = (BNiagaraStation)niagaraStations[i];
            this.addCameraToNiagaraStationIfNecessary(niagaraStation);
        }
    }

    public void addCameraToNiagaraStationIfNecessary(BNiagaraStation niagaraStation) {
        boolean niagaraStationHasCameraExt = this.scanForCameraExt(niagaraStation);
        if (!niagaraStationHasCameraExt) {
            niagaraStation.add("Cameras", (BValue)new BNiagaraCameraExt());
        }
    }

    public boolean scanForCameraExt(BNiagaraStation niagaraStation) {
        BDeviceExt[] exts = niagaraStation.getDeviceExts();
        boolean niagaraStationHasCameraExt = false;
        for (int j = 0; j < exts.length && !niagaraStationHasCameraExt; ++j) {
            if (!(exts[j] instanceof BNiagaraCameraExt)) continue;
            niagaraStationHasCameraExt = true;
        }
        return niagaraStationHasCameraExt;
    }

    public BOrd doResolveRemoteVideoSource(BString remoteVideoOrd) {
        String remoteVideoOrdString = remoteVideoOrd.toString();
        int indexOfSlashSlash = remoteVideoOrdString.indexOf("//");
        if (indexOfSlashSlash >= 0) {
            String niagaraStationName = remoteVideoOrdString.substring(0, indexOfSlashSlash);
            String remoteCameraOrdString = remoteVideoOrdString.substring(indexOfSlashSlash + 2);
            if (!remoteCameraOrdString.startsWith("h:")) {
                remoteCameraOrdString = "slot:/" + remoteCameraOrdString;
            }
            BOrd remoteCameraOrd = BOrd.make((String)remoteCameraOrdString);
            if (log.isTraceOn()) {
                log.trace("Resolving remote video source. Niagara Station Name = " + niagaraStationName + " remoteCameraOrd=" + remoteCameraOrd);
            }
            return this.doResolveRemoteVideoSource(niagaraStationName, remoteCameraOrd);
        }
        throw new BajaRuntimeException("remoteVideo: missing \"//\"\nHINT: The remoteVideo ord needs to be of the format \"<stationName>//<remote camera slot path>\"");
    }

    /*
     * Exception decompiling
     */
    protected BOrd doCopyRemoteVideoSourceToThisStation(BNiagaraStation niagaraStation, BOrd remoteCameraOrd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getLocalResolveMessage(Exception e) {
        LocalizableRuntimeException lre;
        if (e instanceof LocalizableRuntimeException && (lre = (LocalizableRuntimeException)e).getLexiconModule().equals("videoDriver") && lre.getLexiconKey().startsWith("RemoteVideo.")) {
            return lre.toString();
        }
        return null;
    }

    protected String getLocalStationName() {
        try {
            BStation localStation = (BStation)BOrd.make((String)"station:|slot:/").get();
            if (localStation == null) {
                log.error("Unable to find local station.");
                throw new IllegalStateException("Unable to find local station. ");
            }
            String localStationName = localStation.getStationName();
            if (localStationName == null || localStationName.length() == 0) {
                throw new IllegalStateException("Unable to determine local station name.");
            }
            return localStationName;
        }
        catch (UnresolvedException ure) {
            throw new IllegalStateException("Unable to resolve local station");
        }
    }

    protected BOrd doResolveRemoteVideoSource(String niagaraStationName, BOrd cameraInOtherStation) {
        if (niagaraStationName.equals(this.getLocalStationName())) {
            if (cameraInOtherStation.toString().startsWith("station:|")) {
                return cameraInOtherStation;
            }
            return BOrd.make((String)("station:|" + cameraInOtherStation.toString()));
        }
        BNiagaraNetwork niagaraNet = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        if (niagaraNet == null) {
            throw new LocalizableRuntimeException("videoDriver", "RemoteVideo.NiagaraNetwork.NotFound");
        }
        BNiagaraStation niagaraStation = (BNiagaraStation)niagaraNet.getStation(niagaraStationName);
        if (niagaraStation == null) {
            throw new LocalizableRuntimeException("videoDriver", "RemoteVideo.NiagaraStation.NotFound", new Object[]{niagaraStationName});
        }
        return this.doCopyRemoteVideoSourceToThisStation(niagaraStation, cameraInOtherStation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BOrd doCopyRemoteVideoSourceToThisStation(BRemoteVideoChannel wsVideoChannel, String niagaraStation, BOrd remoteCameraOrd) throws Exception {
        if (log.isTraceOn()) {
            log.trace("Copying remote video source to this station -- 2 --. Niagara Station Name = " + niagaraStation + " remoteCameraOrd=" + remoteCameraOrd);
        }
        BRemoteVideoSource unmountedRemoteVideoSource = wsVideoChannel.getNetworkForDriverVideoSource(remoteCameraOrd);
        Object object = this.videoSourceAccess;
        synchronized (object) {
            if (log.isTraceOn()) {
                log.trace("Copying remote video source to this station -- 3 --. Niagara Station Name = " + niagaraStation + " remoteCameraOrd=" + remoteCameraOrd);
            }
            BRemoteVideoSource existingRemoteVideoSource = this.getRemoteVideoSource(niagaraStation, remoteCameraOrd);
            existingRemoteVideoSource.setCameraOrd(unmountedRemoteVideoSource.getCameraOrd());
            existingRemoteVideoSource.setCameraHandleOrd(unmountedRemoteVideoSource.getCameraHandleOrd());
            BDeviceNetwork videoDriverNetworkUnderUnmountedRemoteVideoSource = ((BDeviceNetwork[])unmountedRemoteVideoSource.getChildren(BDeviceNetwork.class))[0];
            String videoDriverNetworkName = videoDriverNetworkUnderUnmountedRemoteVideoSource.getPropertyInParent().getName();
            CopyHints hints = new CopyHints();
            hints.swizzleHandles = true;
            hints.defaultOnClone = false;
            BDeviceNetwork unmountedVideoDriverNetwork = (BDeviceNetwork)videoDriverNetworkUnderUnmountedRemoteVideoSource.newCopy(hints);
            this.hideDynamicComponents((BComponent)unmountedVideoDriverNetwork);
            BDeviceNetwork mountedVideoDriverNetwork = (BDeviceNetwork)existingRemoteVideoSource.get(videoDriverNetworkName);
            if (mountedVideoDriverNetwork == null) {
                Property p = existingRemoteVideoSource.add(videoDriverNetworkName + "?", (BValue)unmountedVideoDriverNetwork);
                mountedVideoDriverNetwork = (BDeviceNetwork)existingRemoteVideoSource.get(p);
                if (!mountedVideoDriverNetwork.isFatalFault() && !existingRemoteVideoSource.isLicensed()) {
                    mountedVideoDriverNetwork.configFail("Unlicensed: javax.baja.license.FeatureNotLicensedException: tridium:remotevideo");
                }
            } else {
                try {
                    this.deepCopy((BComponent)unmountedVideoDriverNetwork, (BComponent)mountedVideoDriverNetwork);
                }
                finally {
                    mountedVideoDriverNetwork.fw(11);
                    if (!mountedVideoDriverNetwork.isFatalFault() && !existingRemoteVideoSource.isLicensed()) {
                        mountedVideoDriverNetwork.configFail("Unlicensed: javax.baja.license.FeatureNotLicensedException: tridium:remotevideo");
                    }
                    mountedVideoDriverNetwork.updateStatus();
                }
            }
            return existingRemoteVideoSource.getSlotPathOrd();
        }
    }

    protected void hideDynamicComponents(BComponent root) {
        SlotCursor rootSc = root.getSlots();
        while (rootSc.nextComponent()) {
            Property rootP = rootSc.property();
            if (rootP == null) continue;
            try {
                int flags = root.getFlags((Slot)rootP);
                root.setFlags((Slot)rootP, flags | 4);
                this.hideDynamicComponents(rootSc.get().asComponent());
            }
            catch (Exception e) {
                log.error("Unable to hide video driver property under temporarily mounted driver", (Throwable)e);
            }
        }
    }

    protected void deepCopy(BComponent from, BComponent to) {
        BStatus origFromStatus;
        BStatus origToStatus;
        if (to instanceof BDevice && from instanceof BDevice) {
            BDevice toDevice = (BDevice)to;
            BDevice fromDevice = (BDevice)from;
            origToStatus = toDevice.getStatus();
            origFromStatus = fromDevice.getStatus();
            to.copyFrom((BComplex)from, Context.decoding);
            toDevice.setStatus(BStatus.make((int)(origToStatus.getBits() | origFromStatus.getBits())));
            toDevice.fw(11);
        } else if (to instanceof BDeviceNetwork && from instanceof BDeviceNetwork) {
            BDeviceNetwork toNet = (BDeviceNetwork)to;
            BDeviceNetwork fromNet = (BDeviceNetwork)from;
            origToStatus = toNet.getStatus();
            origFromStatus = fromNet.getStatus();
            to.copyFrom((BComplex)from, Context.decoding);
            toNet.setStatus(BStatus.make((int)(origToStatus.getBits() | origFromStatus.getBits())));
            toNet.fw(11);
        } else {
            to.copyFrom((BComplex)from, Context.decoding);
        }
        SlotCursor fromSc = from.getSlots();
        while (fromSc.nextComponent()) {
            BValue toV;
            Property fromP = fromSc.property();
            Property toP = to.getProperty(fromP.getName());
            if (toP == null || !((toV = to.get(toP)) instanceof BComponent)) continue;
            this.deepCopy((BComponent)fromSc.get(), (BComponent)toV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BRemoteVideoSource getRemoteVideoSource(String niagaraStation, BOrd remoteCameraOrd) {
        if (log.isTraceOn()) {
            log.trace("getRemoteVideoSource(Niagara Station Name = " + niagaraStation + " remoteCameraOrd=" + remoteCameraOrd);
        }
        Object object = this.remoteVideoSourceAdditionMonitor;
        synchronized (object) {
            BRemoteVideoSource remoteVideoSource;
            boolean isHandleOrd;
            boolean bl = isHandleOrd = remoteCameraOrd.toString().startsWith("h:") || remoteCameraOrd.toString().indexOf("|h:") > 0;
            if (this.getComponentSpace().isProxyComponentSpace()) {
                this.lease(1);
            }
            SlotCursor sc = this.getSlots();
            while (sc.next(BRemoteVideoSource.class)) {
                remoteVideoSource = (BRemoteVideoSource)sc.get();
                if (!remoteVideoSource.getNiagaraStation().equals(niagaraStation)) continue;
                if (isHandleOrd) {
                    System.out.println("Remote video source handle ord = " + remoteVideoSource.getCameraHandleOrd());
                    System.out.println("remoteCameraOrd = " + remoteCameraOrd);
                    if (!remoteVideoSource.getCameraHandleOrd().equals((Object)remoteCameraOrd)) continue;
                    return remoteVideoSource;
                }
                if (!remoteVideoSource.getCameraOrd().equals((Object)remoteCameraOrd)) continue;
                return remoteVideoSource;
            }
            remoteVideoSource = new BRemoteVideoSource();
            remoteVideoSource.setNiagaraStation(niagaraStation);
            this.add("RemoteVideoSource?", (BValue)remoteVideoSource, 6);
            return remoteVideoSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="r")
    public BOrd getLocalCameraOrdFromAlarmRPC(Object obj, Context cx) throws Exception {
        BComponent params = (BComponent)obj;
        BOrd cameraOrd = (BOrd)params.get("cameraOrd");
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation niagaraStation = (BNiagaraStation)network.get(params.get("stationName").toString());
        niagaraStation.getClientConnection();
        String stringInterest = TYPE + ".getLocalCameraOrdFromAlarm." + BUuid.make().toString();
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest(stringInterest);
        try {
            niagaraStation.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)interest);
            BDataChannel dataChannel = (BDataChannel)niagaraStation.getClientConnection().getChannels().get("data", BDataChannel.TYPE);
            BOrd dataOrd = BOrd.make((String)("station:|" + cameraOrd + "/proxyExt/pointId"));
            BString dataValue = (BString)dataChannel.resolve(dataOrd, new String[0]);
            BOrd bOrd = BOrd.make((String)dataValue.toString());
            return bOrd;
        }
        finally {
            niagaraStation.getClientConnection().disengage((BFoxClientConnection.Interest)interest);
        }
    }

    public AgentList getAgents(Context cx) {
        try {
            AgentList result = super.getAgents(cx);
            result.remove("workbench:PropertySheet");
            result.remove("workbench:SlotSheet");
            result.remove("workbench:LinkSheet");
            result.remove("wiresheet:WireSheet");
            result.remove("wiresheet:WebWiresheet");
            result.remove("pxEditor:PxEditor");
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BRemoteVideoSource;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        BFoxChannelRegistry foxRegistry = BFoxChannelRegistry.getPrototype();
        if (foxRegistry.get("remoteVideo") == null) {
            if (log.isTraceOn()) {
                log.trace("Registering fox channel: remoteVideo");
            }
            foxRegistry.add("remoteVideo", (BValue)new BRemoteVideoChannel());
        } else if (log.isTraceOn()) {
            log.trace("Not registering fox channel: remoteVideo");
        }
        if (foxRegistry.get("FoxVideoChannel") == null) {
            if (log.isTraceOn()) {
                log.trace("Registering fox channel: FoxVideoChannel");
            }
            foxRegistry.add("FoxVideoChannel", (BValue)new BFoxVideoChannel());
        } else if (log.isTraceOn()) {
            log.trace("Not registering fox channel: FoxVideoChannel");
        }
    }
}

