/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.csmgrbase.datatypes.BCsReqCmd;
import com.tridium.csmgrbase.datatypes.BCsRspValue;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.BTlsDeviceFolder;
import com.tridium.tls.datatypes.BBirAdjustedDeliveryTable;
import com.tridium.tls.datatypes.BFuelDataUpdateParams;
import com.tridium.tls.datatypes.BInTankInventoryTable;
import com.tridium.tls.datatypes.BInTankStatusTable;
import com.tridium.tls.datatypes.BPriorityAlarmHistoryTable;
import com.tridium.tls.messages.TlsMessageConst;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="stationNameWebSupervisor", type="String", defaultValue="", flags=64), @NiagaraProperty(name="lastCsMgrCommFailureCause", type="String", defaultValue="", flags=1), @NiagaraProperty(name="staleDataTime", type="BRelTime", defaultValue="BRelTime.makeHours(24)"), @NiagaraProperty(name="userData", type="String", defaultValue="")})
public abstract class BTlsConsole
extends BBasicNetwork
implements TlsMessageConst {
    @Generated
    public static final Property stationNameWebSupervisor = BTlsConsole.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property lastCsMgrCommFailureCause = BTlsConsole.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property staleDataTime = BTlsConsole.newProperty((int)0, (BValue)BRelTime.makeHours((int)24), null);
    @Generated
    public static final Property userData = BTlsConsole.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTlsConsole.class);
    BFoxClientConnection.Interest tlsInterest = new TlsInterest();
    private BNiagaraNetwork nn;
    private BNiagaraStation ns;

    @Generated
    public String getStationNameWebSupervisor() {
        return this.getString(stationNameWebSupervisor);
    }

    @Generated
    public void setStationNameWebSupervisor(String v) {
        this.setString(stationNameWebSupervisor, v, null);
    }

    @Generated
    public String getLastCsMgrCommFailureCause() {
        return this.getString(lastCsMgrCommFailureCause);
    }

    @Generated
    public void setLastCsMgrCommFailureCause(String v) {
        this.setString(lastCsMgrCommFailureCause, v, null);
    }

    @Generated
    public BRelTime getStaleDataTime() {
        return (BRelTime)this.get(staleDataTime);
    }

    @Generated
    public void setStaleDataTime(BRelTime v) {
        this.set(staleDataTime, (BValue)v, null);
    }

    @Generated
    public String getUserData() {
        return this.getString(userData);
    }

    @Generated
    public void setUserData(String v) {
        this.setString(userData, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "tls");
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        return super.post(action, arg, cx);
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public Type getDeviceType() {
        return BTlsDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BTlsDeviceFolder.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent);
    }

    public boolean isChildLegal(BComponent child) {
        return super.isParentLegal(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BCsRspValue sendFuelDataUpdate(BFuelDataUpdateParams fdUpdate) {
        BFuelDataUpdateParams fdUpdateSendCopy = (BFuelDataUpdateParams)fdUpdate.newCopy();
        BCsRspValue rv = new BCsRspValue();
        String wsn = this.getStationNameWebSupervisor();
        if (wsn != null && wsn.length() > 0) {
            if (!this.getNiagaraStation(wsn)) {
                if (!this.getLog().isTraceOn()) return rv;
                if (this.getUserData().indexOf("action") == -1) return rv;
                this.getLog().trace("TlsConsole sendFuelDataUpdate... Web Supervisor NiagaraStation not configured");
                return rv;
            }
            BControlPoint cpt = this.getControlPointWithNiagaraProxyExtWithPointId("CsMgrNetwork/fuelCentral");
            if (cpt == null) {
                if (!this.getLog().isTraceOn()) return rv;
                if (this.getUserData().indexOf("action") == -1) return rv;
                this.getLog().trace("TlsConsole sendFuelDataUpdate... NiagaraStation point not configured");
                return rv;
            }
            cpt = (BControlPoint)cpt.loadSlots();
            BFoxClientConnection conn = new BFoxClientConnection();
            try {
                BCsReqCmd cmd = new BCsReqCmd();
                cmd.setReqComp((BComponent)fdUpdateSendCopy);
                if (fdUpdate.getUpdateList().getType() == BPriorityAlarmHistoryTable.TYPE) {
                    cmd.setReqCode("PRI_ALM_HIS_STATUS");
                } else if (fdUpdate.getUpdateList().getType() == BBirAdjustedDeliveryTable.TYPE) {
                    cmd.setReqCode("BIR_ADJ_DEL_STATUS");
                } else if (fdUpdate.getUpdateList().getType() == BInTankInventoryTable.TYPE) {
                    cmd.setReqCode("IN_TANK_INV_STATUS");
                } else if (fdUpdate.getUpdateList().getType() == BInTankStatusTable.TYPE) {
                    cmd.setReqCode("IN_TANK_STA_STATUS");
                } else {
                    String cause = "data type match for " + fdUpdateSendCopy.getType() + " not found... cannot process update";
                    if (this.getLog().isTraceOn() && this.getUserData().indexOf("csmgr") != -1) {
                        this.getLog().trace("TlsConsole sendFuelDataUpdate... " + cause);
                    }
                    BCsRspValue bCsRspValue = new BCsRspValue("NOT_OK_DATA_ERROR", cause);
                    return bCsRspValue;
                }
                conn = this.makeRemoteStationConnection();
                Slot pnSlot = cpt.getSlot("submitTlsReqCmd");
                int slotsLoadedRetryCount = 0;
                while (pnSlot == null) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (++slotsLoadedRetryCount > 5) {
                        String cause = " abort action...  ProxyPoint " + cpt.getName() + " submitTlsReqCmd slot ==null";
                        this.setLastCsMgrCommFailureCause(cause);
                        if (this.getLog().isTraceOn() && this.getUserData().indexOf("action") != -1) {
                            this.getLog().trace("TlsConsole sendFuelDataUpdate... " + cause);
                        }
                        BCsRspValue bCsRspValue = rv;
                        return bCsRspValue;
                    }
                    pnSlot = cpt.getSlot("submitTlsReqCmd");
                    if (!this.getLog().isTraceOn() || this.getUserData().indexOf("action") == -1) continue;
                    this.getLog().trace("TlsConsole sendFuelDataUpdate... slrc=" + slotsLoadedRetryCount);
                }
                BAction pnAction = (BAction)cpt.get("submitTlsReqCmd");
                if (this.getLog().isTraceOn() && this.getUserData().indexOf("action") != -1) {
                    this.getLog().trace("TlsConsole sendFuelDataUpdate... cpt=" + cpt);
                    this.getLog().trace("TlsConsole sendFuelDataUpdate... cmd=" + cmd);
                    this.getLog().trace("TlsConsole sendFuelDataUpdate... pnAction=" + pnAction);
                }
                rv = (BCsRspValue)pnAction.invoke((BComponent)cpt, (BValue)cmd);
                if (this.getLog().isTraceOn() && this.getUserData().indexOf("action") != -1) {
                    this.getLog().trace("TlsConsole sendFuelDataUpdate... status update sent to WS... rv=" + rv.getRspCode());
                }
                if (rv.getRspCode().equals("OK")) {
                    this.setLastCsMgrCommFailureCause("");
                    return rv;
                }
                String cause = rv.getSimpleResponseData();
                this.setLastCsMgrCommFailureCause(cause);
                if (!this.getLog().isTraceOn()) return rv;
                if (this.getUserData().indexOf("action") == -1) return rv;
                this.getLog().trace("!cc! " + this.getName() + " sendOvenRecipesDlStatusUpdate response from CsMgr=" + cause);
                return rv;
            }
            catch (Exception e) {
                this.getLog().error("e=" + e);
                e.printStackTrace();
                return rv;
            }
            finally {
                try {
                    this.endRemoteStationConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
        if (!this.getLog().isTraceOn()) return rv;
        if (this.getUserData().indexOf("action") == -1) return rv;
        this.getLog().trace("TlsConsole sendFuelDataUpdate... Web Supervisor Station Name property not configured");
        return rv;
    }

    private BControlPoint getControlPointWithNiagaraProxyExtWithPointId(String pointIdString) {
        BControlPoint[] points;
        if (this.getNiagaraStation(this.getStationNameWebSupervisor()) && (points = this.ns.getPoints().getPoints()) != null && points.length > 0) {
            for (int i = 0; i < points.length; ++i) {
                BPointExtension[] ptext = points[i].getExtensions();
                if (ptext == null || ptext.length <= 0) continue;
                for (int j = 0; j < ptext.length; ++j) {
                    BNiagaraProxyExt npext;
                    if (!(ptext[j] instanceof BNiagaraProxyExt) || !(npext = (BNiagaraProxyExt)ptext[j]).getPointId().endsWith(pointIdString)) continue;
                    npext.forceUpdate();
                    return points[i];
                }
            }
        }
        return null;
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        if (this.nn == null) {
            this.nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        }
        return this.nn;
    }

    public boolean getNiagaraStation(String nsn) {
        if (this.ns == null) {
            this.ns = (BNiagaraStation)this.getNiagaraNetwork().getStation(nsn);
            if (this.ns == null) {
                if (this.getLog().isTraceOn() && this.getUserData().indexOf("csmgr") != -1) {
                    this.getLog().trace("getNiagaraStation for <" + this + "> not found for stationName=" + nsn);
                }
                return false;
            }
            if (this.getLog().isTraceOn() && this.getUserData().indexOf("csmgr") != -1) {
                this.getLog().trace("getNiagaraStation for <" + this + "> ns=" + this.ns);
            }
            return true;
        }
        return true;
    }

    private BFoxClientConnection makeRemoteStationConnection() throws Exception {
        if (this.getLog().isTraceOn() && this.getUserData().indexOf("csmgr") != -1) {
            this.getLog().trace("makeRemoteStationConnection for <" + this + "> find stationName=" + this.getStationNameWebSupervisor());
        }
        BFoxClientConnection tlsClientConnection = new BFoxClientConnection();
        if (this.getNiagaraNetwork() != null) {
            if (this.getNiagaraStation(this.getStationNameWebSupervisor())) {
                tlsClientConnection = this.ns.getClientConnection();
                try {
                    tlsClientConnection.engageNoRetry(this.tlsInterest, 60000L);
                    return tlsClientConnection;
                }
                catch (Exception e) {
                    this.getLog().error("makeRemoteStationConnection for <" + this + "> ns=" + this.ns.getName() + " attempt engage connection failed... Exception e=" + e);
                    this.getLog().error("makeRemoteStationConnection for <" + this + "> ns=" + this.ns.getName() + " attempt engage connection failed... abort operation");
                }
            }
        } else if (this.getLog().isTraceOn() && this.getUserData().indexOf("csmgr") != -1) {
            this.getLog().trace("makeRemoteStationConnection for <" + this + "> nn==null... abort operation");
        }
        return null;
    }

    private void endRemoteStationConnection(BFoxClientConnection clientConnection) throws Exception {
        clientConnection.disengage(this.tlsInterest);
    }

    static class TlsInterest
    implements BFoxClientConnection.Interest {
        TlsInterest() {
        }

        public String toString() {
            return "TlsInterest";
        }
    }
}

