/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350FuelMgmtProxyExt;
import java.util.Vector;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class Tls350FuelManagementReportResponse
extends Tls350Response {
    public BAbsTime readTime;
    public int messageTank = 0;
    public int numTankProdCodePairs;
    public int numberFieldsToFollowInt;
    public FuelManagement[] fuelManagementEntries = null;
    private BTls350FuelMgmtProxyExt ext;
    private boolean debug;

    public Tls350FuelManagementReportResponse() {
    }

    public Tls350FuelManagementReportResponse(BTls350FuelMgmtProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public FuelManagement[] getFuelManagementEntries() {
        if (this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse fuelManagementEntries.length=" + this.fuelManagementEntries.length);
        }
        return this.fuelManagementEntries;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16 || !this.functionCode.equalsIgnoreCase("281")) {
            this.fuelManagementEntries = new FuelManagement[0];
            this.messageTank = this.tank;
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        if (this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse readTime=" + this.readTime.encodeToString());
        }
        boolean readResponseDone = false;
        Vector<FuelManagement> entries = new Vector<FuelManagement>();
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) {
                this.fuelManagementEntries = new FuelManagement[0];
                this.messageTank = this.tank;
                return inStream;
            }
            inStream.reset();
            if (inStream.available() < 8) {
                this.fuelManagementEntries = new FuelManagement[0];
                this.messageTank = this.tank;
                return inStream;
            }
            String numTankProdCodePairsStr = inStream.readString(2);
            try {
                this.numTankProdCodePairs = Integer.parseInt(numTankProdCodePairsStr, 16);
            }
            catch (NumberFormatException nfe) {
                System.out.println("FuelManagementReportResponse could not convert numTankProdCodePairsStr from str-hex-int... numTankProdCodePairsStr=" + numTankProdCodePairsStr);
                return inStream;
            }
            if (this.debug) {
                this.ext.getLog().trace("TlsFMResponse :readResponse numTankProdCodePairs=" + this.numTankProdCodePairs);
            }
            if (this.numTankProdCodePairs != 0) {
                FuelManagement nextEntry = new FuelManagement();
                for (int i = 0; i < this.numTankProdCodePairs; ++i) {
                    nextEntry.setCurrentDateTime(this.readTime);
                    nextEntry.setTankNumber(inStream.readAsciiInt(2));
                    nextEntry.setProductCode(inStream.readString(1));
                    String numberFieldsToFollowIntStr = inStream.readString(2);
                    try {
                        this.numberFieldsToFollowInt = Integer.parseInt(numberFieldsToFollowIntStr, 16);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("AdjustedDeliveryReportResponse could not convert numberFieldsToFollowIntStr from str-hex-int... numberFieldsToFollowIntStr=" + numberFieldsToFollowIntStr);
                        return inStream;
                    }
                    block18: for (int j = 0; j < 10 && j != this.numberFieldsToFollowInt; ++j) {
                        switch (j) {
                            case 0: {
                                nextEntry.setDaysRemaining(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 1: {
                                nextEntry.setPresentInventory(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 2: {
                                nextEntry.setPresentUllage(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 3: {
                                nextEntry.setSundaySales(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 4: {
                                nextEntry.setMondaySales(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 5: {
                                nextEntry.setTuesdaySales(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 6: {
                                nextEntry.setWednesdaySales(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 7: {
                                nextEntry.setThursdaySales(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 8: {
                                nextEntry.setFridaySales(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                                continue block18;
                            }
                            case 9: {
                                nextEntry.setSaturdaySales(j < this.numberFieldsToFollowInt ? inStream.readAsciiFloat() : Float.NaN);
                            }
                        }
                    }
                    if (this.debug) {
                        this.ext.getLog().trace("TlsFMResponse :readResponse nextEntry=" + nextEntry.getFuelManagementLogString());
                    }
                    entries.addElement(nextEntry);
                }
            }
            readResponseDone = true;
        }
        if (entries != null && this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse entries.size()=" + entries.size());
        }
        if (entries == null || entries.size() <= 0) {
            this.fuelManagementEntries = new FuelManagement[0];
        } else {
            this.fuelManagementEntries = new FuelManagement[entries.size()];
            entries.copyInto(this.fuelManagementEntries);
        }
        if (this.fuelManagementEntries != null && this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse fuelManagementEntries.length=" + this.fuelManagementEntries.length);
        }
        return inStream;
    }

    public class FuelManagement {
        BAbsTime currentDateTime;
        int tankNumber;
        String productCode;
        float daysRemaining = Float.NaN;
        float presentInventory = Float.NaN;
        float presentUllage = Float.NaN;
        float sundaySales = Float.NaN;
        float mondaySales = Float.NaN;
        float tuesdaySales = Float.NaN;
        float wednesdaySales = Float.NaN;
        float thursdaySales = Float.NaN;
        float fridaySales = Float.NaN;
        float saturdaySales = Float.NaN;

        public void setCurrentDateTime(BAbsTime dt) {
            this.currentDateTime = dt;
        }

        public void setTankNumber(int tn) {
            this.tankNumber = tn;
        }

        public void setProductCode(String pc) {
            this.productCode = pc;
        }

        public void setDaysRemaining(float dr) {
            this.daysRemaining = dr;
        }

        public void setPresentInventory(float pi) {
            this.presentInventory = pi;
        }

        public void setPresentUllage(float pu) {
            this.presentUllage = pu;
        }

        public void setSundaySales(float ss) {
            this.sundaySales = ss;
        }

        public void setMondaySales(float ms) {
            this.mondaySales = ms;
        }

        public void setTuesdaySales(float ts) {
            this.tuesdaySales = ts;
        }

        public void setWednesdaySales(float ws) {
            this.wednesdaySales = ws;
        }

        public void setThursdaySales(float ts) {
            this.thursdaySales = ts;
        }

        public void setFridaySales(float fs) {
            this.fridaySales = fs;
        }

        public void setSaturdaySales(float ss) {
            this.saturdaySales = ss;
        }

        public BAbsTime getCurrentDateTime() {
            return this.currentDateTime;
        }

        public int getTankNumber() {
            return this.tankNumber;
        }

        public String getProductCode() {
            return this.productCode;
        }

        public float getDaysRemaining() {
            return this.daysRemaining;
        }

        public float getPresentInventory() {
            return this.presentInventory;
        }

        public float getPresentUllage() {
            return this.presentUllage;
        }

        public float getSundaySales() {
            return this.sundaySales;
        }

        public float getMondaySales() {
            return this.mondaySales;
        }

        public float getTuesdaySales() {
            return this.tuesdaySales;
        }

        public float getWednesdaySales() {
            return this.wednesdaySales;
        }

        public float getThursdaySales() {
            return this.thursdaySales;
        }

        public float getFridaySales() {
            return this.fridaySales;
        }

        public float getSaturdaySales() {
            return this.saturdaySales;
        }

        public String getFuelManagementLogString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.currentDateTime.encodeToString());
            sb.append(", ");
            sb.append(this.tankNumber);
            sb.append(", ");
            sb.append(this.productCode);
            sb.append(", ");
            sb.append(this.daysRemaining);
            sb.append(", ");
            sb.append(this.presentInventory);
            sb.append(", ");
            sb.append(this.presentUllage);
            sb.append(", ");
            sb.append(this.sundaySales);
            sb.append(", ");
            sb.append(this.mondaySales);
            sb.append(", ");
            sb.append(this.tuesdaySales);
            sb.append(", ");
            sb.append(this.wednesdaySales);
            sb.append(", ");
            sb.append(this.thursdaySales);
            sb.append(", ");
            sb.append(this.fridaySales);
            sb.append(", ");
            sb.append(this.saturdaySales);
            return sb.toString();
        }
    }
}

